/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.download;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.download.Downloader;
import org.jreleaser.model.internal.common.Http;
import org.jreleaser.model.internal.common.HttpDelegate;
import org.jreleaser.model.internal.download.AbstractDownloader;
import org.jreleaser.model.internal.download.Downloader;

public final class HttpDownloader
extends AbstractDownloader<org.jreleaser.model.api.download.HttpDownloader, HttpDownloader>
implements Http {
    private static final long serialVersionUID = -3365213730876579690L;
    private final HttpDelegate delegate = new HttpDelegate();
    @JsonIgnore
    private final org.jreleaser.model.api.download.HttpDownloader immutable = new org.jreleaser.model.api.download.HttpDownloader(){
        private static final long serialVersionUID = -1955685895966905403L;
        private List<? extends Downloader.Asset> assets;

        public String getUsername() {
            return HttpDownloader.this.getUsername();
        }

        public String getPassword() {
            return HttpDownloader.this.getPassword();
        }

        public Http.Authorization getAuthorization() {
            return HttpDownloader.this.getAuthorization();
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(HttpDownloader.this.getHeaders());
        }

        public String getType() {
            return HttpDownloader.this.getType();
        }

        public String getName() {
            return HttpDownloader.this.getName();
        }

        public List<? extends Downloader.Asset> getAssets() {
            if (null == this.assets) {
                this.assets = HttpDownloader.this.getAssets().stream().map(Downloader.Asset::asImmutable).collect(Collectors.toList());
            }
            return this.assets;
        }

        public Active getActive() {
            return HttpDownloader.this.getActive();
        }

        public boolean isEnabled() {
            return HttpDownloader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(HttpDownloader.this.asMap(full));
        }

        public String getPrefix() {
            return HttpDownloader.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(HttpDownloader.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return HttpDownloader.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return HttpDownloader.this.getReadTimeout();
        }
    };

    public HttpDownloader() {
        super("http");
    }

    @Override
    public org.jreleaser.model.api.download.HttpDownloader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(HttpDownloader source) {
        super.merge(source);
        this.delegate.merge(source.delegate);
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    public Http.Authorization getAuthorization() {
        return this.delegate.getAuthorization();
    }

    @Override
    public void setAuthorization(Http.Authorization authorization) {
        this.delegate.setAuthorization(authorization);
    }

    @Override
    public void setAuthorization(String authorization) {
        this.delegate.setAuthorization(authorization);
    }

    public Map<String, String> getHeaders() {
        return this.delegate.getHeaders();
    }

    public void setHeaders(Map<String, String> headers) {
        this.delegate.setHeaders(headers);
    }

    public void asMap(Map<String, Object> props) {
        this.delegate.asMap(props);
    }

    @Override
    public Http.Authorization resolveAuthorization() {
        return this.delegate.resolveAuthorization();
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        this.delegate.asMap(props);
    }
}

