/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.telegram;

import java.util.LinkedHashMap;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Telegram;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.telegram.TelegramException;
import org.jreleaser.sdk.telegram.TelegramSdk;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class TelegramAnnouncer
implements Announcer {
    private final JReleaserContext context;

    TelegramAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "telegram";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getTelegram().isEnabled();
    }

    public void announce() throws AnnounceException {
        Telegram telegram = this.context.getModel().getAnnounce().getTelegram();
        String message = "";
        if (StringUtils.isNotBlank((String)telegram.getMessage())) {
            message = telegram.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = telegram.getResolvedMessageTemplate(this.context, props);
        }
        String chatId = telegram.getResolvedChatId();
        this.context.getLogger().info("message: {}", new Object[]{message});
        try {
            TelegramSdk sdk = TelegramSdk.builder(this.context.getLogger()).token(telegram.getResolvedToken()).connectTimeout(telegram.getConnectTimeout()).readTimeout(telegram.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.sendMessage(chatId, message);
        }
        catch (TelegramException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

