/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Active;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.Project;

abstract class AbstractDownloader<S extends AbstractDownloader<S>>
extends AbstractModelObject<S>
implements Downloader {
    @JsonIgnore
    protected final String type;
    protected final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    protected final List<Downloader.Asset> assets = new ArrayList<Downloader.Asset>();
    @JsonIgnore
    protected String name;
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    protected int connectTimeout;
    protected int readTimeout;

    protected AbstractDownloader(String type) {
        this.type = type;
    }

    @Override
    public void freeze() {
        super.freeze();
        this.assets.forEach(Downloader.Asset::freeze);
    }

    @Override
    public void merge(S downloader) {
        this.freezeCheck();
        this.name = this.merge(this.name, ((AbstractDownloader)downloader).name);
        this.active = this.merge(this.active, ((AbstractDownloader)downloader).active);
        this.enabled = this.merge(this.enabled, ((AbstractDownloader)downloader).enabled);
        this.connectTimeout = this.merge(this.connectTimeout, ((AbstractDownloader)downloader).connectTimeout);
        this.readTimeout = this.merge(this.readTimeout, ((AbstractDownloader)downloader).readTimeout);
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractDownloader)downloader).extraProperties));
        this.setAssets(this.merge(this.assets, ((AbstractDownloader)downloader).assets));
    }

    @Override
    public String getPrefix() {
        return this.type;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.ALWAYS;
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.freezeCheck();
        this.name = name;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.freezeCheck();
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.freezeCheck();
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.freezeWrap(this.extraProperties);
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.freezeCheck();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public List<Downloader.Asset> getAssets() {
        return this.freezeWrap(this.assets);
    }

    @Override
    public void setAssets(List<Downloader.Asset> assets) {
        this.freezeCheck();
        this.assets.clear();
        this.assets.addAll(assets);
    }

    @Override
    public void addAsset(Downloader.Asset asset) {
        this.freezeCheck();
        if (null != asset) {
            this.assets.add(asset);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", (Object)this.active);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        this.asMap(props, full);
        LinkedHashMap<String, Map<String, Object>> mappedAssets = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Downloader.Asset asset : this.getAssets()) {
            mappedAssets.put("asset " + i++, asset.asMap(full));
        }
        props.put("assets", mappedAssets);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(Map<String, Object> var1, boolean var2);
}

