/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

public class JavaModuleVersion
implements Version<JavaModuleVersion> {
    private final String version;
    private final String prerelease;
    private final String build;

    private JavaModuleVersion(String version, String prerelease, String build) {
        this.version = version;
        this.prerelease = StringUtils.isNotBlank(prerelease) ? prerelease.trim() : null;
        this.build = StringUtils.isNotBlank(build) ? build.trim() : null;
    }

    public boolean hasPrerelease() {
        return StringUtils.isNotBlank(this.prerelease);
    }

    public boolean hasBuild() {
        return StringUtils.isNotBlank(this.build);
    }

    public String getVersion() {
        return this.version;
    }

    public String getPrerelease() {
        return this.prerelease;
    }

    public String getBuild() {
        return this.build;
    }

    @Override
    public String toRpmVersion() {
        StringBuilder b = new StringBuilder();
        b.append(this.version);
        if (this.hasPrerelease()) {
            b.append("~").append(this.prerelease.replace("-", "_"));
        }
        if (this.hasBuild()) {
            b.append("_").append(this.build.replace("-", "_"));
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.version);
        if (this.hasPrerelease()) {
            b.append("-").append(this.prerelease);
        }
        if (this.hasBuild()) {
            b.append("+").append(this.build);
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaModuleVersion v = (JavaModuleVersion)o;
        return Objects.equals(this.version, v.version) && Objects.equals(this.prerelease, v.prerelease) && Objects.equals(this.build, v.build);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.prerelease, this.build);
    }

    @Override
    public int compareTo(JavaModuleVersion that) {
        int c = this.compareVersion(this.version, that.version);
        if (c != 0) {
            return c;
        }
        if (StringUtils.isBlank(this.prerelease)) {
            if (StringUtils.isNotBlank(that.prerelease)) {
                return 1;
            }
        } else if (StringUtils.isBlank(that.prerelease)) {
            return -1;
        }
        if ((c = this.comparePrerelease(this.prerelease, that.prerelease)) != 0) {
            return c;
        }
        return this.compareBuild(this.build, that.build);
    }

    @Override
    public boolean equalsSpec(JavaModuleVersion version) {
        return this.check(this.prerelease, version.prerelease) && this.check(this.build, version.build);
    }

    private boolean check(String s1, String s2) {
        if (StringUtils.isBlank(s1)) {
            return StringUtils.isBlank(s2);
        }
        return StringUtils.isNotBlank(s2);
    }

    private int compareVersion(String v1, String v2) {
        return this.compareTokens(v1.split("\\."), v2.split("\\."));
    }

    private int comparePrerelease(String p1, String p2) {
        List<Character> delims = CollectionUtils.newList(Character.valueOf('.'), Character.valueOf('-'));
        return this.compareTokens(this.split(p1, delims), this.split(p2, delims));
    }

    private int compareBuild(String b1, String b2) {
        List<Character> delims = CollectionUtils.newList(Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('+'));
        return this.compareTokens(this.split(b1, delims), this.split(b2, delims));
    }

    private String[] split(String s, List<Character> delims) {
        if (StringUtils.isBlank(s)) {
            return new String[0];
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder accumulator = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (delims.contains(Character.valueOf(c))) {
                tokens.add(accumulator.toString());
                accumulator = new StringBuilder();
                continue;
            }
            accumulator.append(c);
        }
        if (accumulator.length() > 0) {
            tokens.add(accumulator.toString());
        }
        return tokens.toArray(new String[0]);
    }

    private int compareTokens(String[] t1, String[] t2) {
        int n = Math.min(t1.length, t2.length);
        for (int i = 0; i < n; ++i) {
            String s1 = t1[i];
            String s2 = t2[i];
            try {
                int c = this.compareAsNumbers(s1, s2);
                if (0 == c) continue;
                return c;
            }
            catch (NumberFormatException e) {
                int c = s1.compareTo(s2);
                if (0 == c) continue;
                return c;
            }
        }
        String[] rest = t1.length > t2.length ? t1 : t2;
        int e = rest.length;
        for (int i = n; i < e; ++i) {
            String o = rest[i];
            if ("0".equals(o)) continue;
            return t1.length - t2.length;
        }
        return 0;
    }

    private int compareAsNumbers(String s1, String s2) {
        int i1 = Integer.parseInt(s1);
        int i2 = Integer.parseInt(s2);
        return Integer.compare(i1, i2);
    }

    public static JavaModuleVersion defaultOf() {
        return JavaModuleVersion.of("0.0.0");
    }

    public static JavaModuleVersion of(String version) {
        StringUtils.requireNonBlank(version, "Argument 'version' must not be blank");
        char c = version.charAt(0);
        if (c < '0' || c > '9') {
            throw new IllegalArgumentException("Version does not start with a digit: '" + version + "'");
        }
        String v = JavaModuleVersion.take(version, 0, CollectionUtils.newList(Character.valueOf('-'), Character.valueOf('+')));
        String p = null;
        String b = null;
        if (v.length() + 1 < version.length()) {
            if (version.charAt(v.length()) == '-') {
                p = JavaModuleVersion.take(version, v.length() + 1, CollectionUtils.newList(Character.valueOf('+')));
                if (v.length() + 1 + p.length() + 1 < version.length()) {
                    b = JavaModuleVersion.take(version, v.length() + 1 + p.length() + 1, Collections.emptyList());
                }
            } else {
                b = JavaModuleVersion.take(version, v.length() + 1, Collections.emptyList());
            }
        }
        return new JavaModuleVersion(v, p, b);
    }

    private static String take(String str, int index, List<Character> delims) {
        char c;
        StringBuilder b = new StringBuilder();
        for (int i = index; i < str.length() && !delims.contains(Character.valueOf(c = str.charAt(i))); ++i) {
            b.append(c);
        }
        return b.toString();
    }

    public static JavaModuleVersion of(String version, String tag, String build) {
        StringUtils.requireNonBlank(version, "Argument 'version' must not be blank");
        return new JavaModuleVersion(version, tag, build);
    }
}

