/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Mastodon
extends AbstractAnnouncer {
    public static final String NAME = "mastodon";
    public static final String MASTODON_ACCESS_TOKEN = "MASTODON_ACCESS_TOKEN";
    private String host;
    private String accessToken;
    private String status;

    public Mastodon() {
        super(NAME);
    }

    void setAll(Mastodon mastodon) {
        super.setAll(mastodon);
        this.host = mastodon.host;
        this.accessToken = mastodon.accessToken;
        this.status = mastodon.status;
    }

    public String getResolvedStatus(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        context.getModel().getRelease().getGitService().fillProps(props, context.getModel());
        return Templates.resolveTemplate((String)this.status, props);
    }

    public String getResolvedAccessToken() {
        return Env.resolve((String)MASTODON_ACCESS_TOKEN, (String)this.accessToken);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("host", this.host);
        props.put("accessToken", StringUtils.isNotBlank((String)this.getResolvedAccessToken()) ? "************" : "**unset**");
        props.put("status", this.status);
    }
}

