/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Mail
extends AbstractAnnouncer {
    public static final String NAME = "mail";
    public static final String MAIL_PASSWORD = "MAIL_PASSWORD";
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private Transport transport;
    private String host;
    private Integer port;
    private Boolean auth;
    private String username;
    private String password;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String subject;
    private String message;
    private String messageTemplate;
    private MimeType mimeType;

    public Mail() {
        super(NAME);
    }

    void setAll(Mail mail) {
        super.setAll(mail);
        this.transport = mail.transport;
        this.host = mail.host;
        this.port = mail.port;
        this.auth = mail.auth;
        this.username = mail.username;
        this.password = mail.password;
        this.from = mail.from;
        this.to = mail.to;
        this.cc = mail.cc;
        this.bcc = mail.bcc;
        this.subject = mail.subject;
        this.message = mail.message;
        this.messageTemplate = mail.messageTemplate;
        this.mimeType = mail.mimeType;
        this.setProperties(mail.properties);
    }

    public String getResolvedSubject(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getGitService().getEffectiveTagName(context.getModel()));
        return Templates.resolveTemplate((String)this.subject, props);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getGitService().getEffectiveTagName(context.getModel()));
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getGitService().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedPassword() {
        return Env.resolve((String)MAIL_PASSWORD, (String)this.password);
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = Transport.valueOf(transport.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase());
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean isAuth() {
        return this.auth != null && this.auth != false;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public boolean isAuthSet() {
        return this.auth != null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = MimeType.valueOf(mimeType.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase());
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("transport", (Object)this.transport);
        props.put("host", this.host);
        props.put("port", this.port);
        props.put("auth", this.isAuth());
        props.put("username", this.username);
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("from", this.from);
        props.put("to", this.to);
        props.put("cc", this.cc);
        props.put("bcc", this.bcc);
        props.put("subject", this.subject);
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
        props.put("mimeType", (Object)this.mimeType);
        props.put("properties", this.properties);
    }

    public static enum Transport {
        SMTP,
        SMTPS;

    }

    public static enum MimeType {
        TEXT("text/plain"),
        HTML("text/html");

        private final String code;

        private MimeType(String code) {
            this.code = code;
        }

        public String code() {
            return this.code;
        }
    }
}

