/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;

public class Jbang
extends AbstractRepositoryPackager {
    public static final String TYPE = "jbang";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final JbangCatalog catalog = new JbangCatalog();
    private String alias;

    public Jbang() {
        super(TYPE);
    }

    void setAll(Jbang jbang) {
        super.setAll(jbang);
        this.alias = jbang.alias;
        this.setCatalog(jbang.catalog);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public JbangCatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(JbangCatalog tap) {
        this.catalog.setAll(tap);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("alias", this.alias);
        props.put("catalog", this.catalog.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.catalog;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return true;
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet());
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return true;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    static {
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, Collections.emptySet());
        SUPPORTED.put(Distribution.DistributionType.JLINK, Collections.emptySet());
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, Collections.emptySet());
    }

    public static class JbangCatalog
    extends AbstractRepositoryTap {
        public JbangCatalog() {
            super(Jbang.TYPE, "jbang-catalog");
        }

        @Override
        public String getResolvedName() {
            return this.tapName;
        }
    }
}

