/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.config.yaml;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.github.sbaudoin.yamllint.Format;
import com.github.sbaudoin.yamllint.Linter;
import com.github.sbaudoin.yamllint.YamlLintConfig;
import com.github.sbaudoin.yamllint.YamlLintConfigException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.util.StringUtils;

public class YamlJReleaserConfigParser
implements JReleaserConfigParser {
    private static final String YAML_LINT_CONFIG = String.join((CharSequence)System.lineSeparator(), Arrays.asList("---", "rules:", "  indentation:", "    spaces: consistent", "    check-multi-line-strings: true", "    indent-sequences: true")) + System.lineSeparator();

    public String getPreferredFileExtension() {
        return "yml";
    }

    public boolean supports(Path configFile) {
        return this.supports(configFile.getFileName().toString());
    }

    public boolean supports(String resource) {
        return StringUtils.isNotBlank((String)resource) && (resource.endsWith(".yml") || resource.endsWith(".yaml"));
    }

    public void validate(Path configFile) throws IOException {
        YamlLintConfig config = null;
        try {
            config = new YamlLintConfig((CharSequence)YAML_LINT_CONFIG);
        }
        catch (YamlLintConfigException e) {
            return;
        }
        List problems = Linter.run((YamlLintConfig)config, (File)configFile.toFile());
        if (!problems.isEmpty()) {
            throw new IOException(Format.format((String)configFile.toAbsolutePath().toString(), (List)problems, (Format.OutputFormat)Format.OutputFormat.AUTO));
        }
    }

    public JReleaserModel parse(InputStream inputStream) throws IOException {
        YAMLMapper mapper = (YAMLMapper)YAMLMapper.builder().build();
        return (JReleaserModel)mapper.readValue(inputStream, JReleaserModel.class);
    }

    public <T> T load(Class<T> type, InputStream inputStream) throws IOException {
        YAMLMapper mapper = (YAMLMapper)YAMLMapper.builder().build();
        return (T)mapper.readValue(inputStream, type);
    }

    public Map<String, String> properties(InputStream inputStream) throws IOException {
        YAMLMapper mapper = (YAMLMapper)YAMLMapper.builder().build();
        return (Map)mapper.readValue(inputStream, Map.class);
    }
}

