/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.upload;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.upload.ProjectUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Upload;
import org.jreleaser.model.Uploader;
import org.jreleaser.model.uploader.spi.UploadException;

public class Uploaders {
    public static void upload(JReleaserContext context) {
        Upload upload = context.getModel().getUpload();
        if (!upload.isEnabled()) {
            context.getLogger().info(RB.$((String)"uploaders.not.enabled", (Object[])new Object[0]));
            return;
        }
        if (!context.getIncludedUploaderTypes().isEmpty()) {
            for (String uploaderType : context.getIncludedUploaderTypes()) {
                if (!Upload.supportedUploaders().contains(uploaderType)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_uploader", (Object[])new Object[]{uploaderType}));
                    continue;
                }
                Map uploaders = upload.findUploadersByType(uploaderType);
                if (uploaders.isEmpty()) {
                    context.getLogger().debug(RB.$((String)"uploaders.no.match", (Object[])new Object[0]), new Object[]{uploaderType});
                    return;
                }
                if (!context.getIncludedUploaderNames().isEmpty()) {
                    for (String uploaderName : context.getIncludedUploaderNames()) {
                        if (!uploaders.containsKey(uploaderName)) {
                            context.getLogger().warn(RB.$((String)"uploaders.uploader.not.configured", (Object[])new Object[0]), new Object[]{uploaderType, uploaderName});
                            continue;
                        }
                        Uploader uploader2 = (Uploader)uploaders.get(uploaderName);
                        if (!uploader2.isEnabled()) {
                            context.getLogger().info(RB.$((String)"uploaders.uploader.disabled", (Object[])new Object[0]), new Object[]{uploaderType, uploaderName});
                            continue;
                        }
                        context.getLogger().info(RB.$((String)"uploaders.upload.with", (Object[])new Object[0]), new Object[]{uploaderType, uploaderName});
                        Uploaders.upload(context, uploader2);
                    }
                    continue;
                }
                context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts.with", (Object[])new Object[0]), new Object[]{uploaderType});
                uploaders.values().forEach(uploader -> Uploaders.upload(context, uploader));
            }
        } else if (!context.getIncludedUploaderNames().isEmpty()) {
            for (String uploaderName : context.getIncludedUploaderNames()) {
                List<Uploader> filteredUploaders = upload.findAllActiveUploaders().stream().filter(a -> uploaderName.equals(a.getName())).collect(Collectors.toList());
                if (!filteredUploaders.isEmpty()) {
                    context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts.to", (Object[])new Object[0]), new Object[]{uploaderName});
                    filteredUploaders.forEach(uploader -> Uploaders.upload(context, uploader));
                    continue;
                }
                context.getLogger().warn(RB.$((String)"uploaders.uploader.not.configured2", (Object[])new Object[0]), new Object[]{uploaderName});
            }
        } else {
            context.getLogger().info(RB.$((String)"uploaders.upload.all.artifacts", (Object[])new Object[0]));
            for (Uploader uploader3 : upload.findAllActiveUploaders()) {
                String uploaderType = uploader3.getType();
                String uploaderName = uploader3.getName();
                if (context.getExcludedUploaderTypes().contains(uploaderType) || context.getExcludedUploaderNames().contains(uploaderName)) {
                    context.getLogger().info(RB.$((String)"uploaders.uploader.excluded", (Object[])new Object[0]), new Object[]{uploaderType, uploaderName});
                    continue;
                }
                Uploaders.upload(context, uploader3);
            }
        }
    }

    private static void upload(JReleaserContext context, Uploader uploader) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(uploader.getType());
            ProjectUploader projectUploader = Uploaders.createProjectUploader(context, uploader);
            projectUploader.upload();
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
        catch (UploadException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static ProjectUploader createProjectUploader(JReleaserContext context, Uploader uploader) {
        return ProjectUploader.builder().context(context).uploader(uploader).build();
    }
}

