/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Mastodon;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class MastodonValidator
extends Validator {
    public static void validateMastodon(JReleaserContext context, Mastodon mastodon, Errors errors) {
        if (!mastodon.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.mastodon");
        if (StringUtils.isBlank((String)mastodon.getHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"mastodon.host"}));
        }
        mastodon.setAccessToken(MastodonValidator.checkProperty(context, "MASTODON_ACCESS_TOKEN", "mastodon.accessToken", mastodon.getAccessToken(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)mastodon.getStatus())) {
            mastodon.setStatus(RB.$((String)"default_release_message", (Object[])new Object[0]));
        }
        MastodonValidator.validateTimeout(mastodon);
    }
}

