/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.sign;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Signing;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.command.CommandException;
import org.jreleaser.util.signing.GpgCommandSigner;
import org.jreleaser.util.signing.Keyring;
import org.jreleaser.util.signing.SigningException;

public class Signer {
    public static void sign(JReleaserContext context) throws SigningException {
        context.getLogger().info(RB.$((String)"signing.header", (Object[])new Object[0]));
        if (!context.getModel().getSigning().isEnabled()) {
            context.getLogger().info(RB.$((String)"signing.not.enabled", (Object[])new Object[0]));
            return;
        }
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("sign");
        if (context.getModel().getSigning().getMode() == Signing.Mode.COMMAND) {
            Signer.cmdSign(context);
        } else {
            Signer.bcSign(context);
        }
        context.getLogger().restorePrefix();
        context.getLogger().decreaseIndent();
    }

    private static void cmdSign(JReleaserContext context) throws SigningException {
        List<FilePair> files = Signer.collectArtifacts(context);
        if (files.isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
            return;
        }
        if ((files = files.stream().filter(FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
            return;
        }
        Signer.sign(context, files);
        Signer.verify(context, files);
    }

    private static void bcSign(JReleaserContext context) throws SigningException {
        Keyring keyring = context.createKeyring();
        List<FilePair> files = Signer.collectArtifacts(context, keyring);
        if (files.isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.no.match", (Object[])new Object[0]));
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
            return;
        }
        if ((files = files.stream().filter(FilePair::isInvalid).collect(Collectors.toList())).isEmpty()) {
            context.getLogger().info(RB.$((String)"signing.up.to.date", (Object[])new Object[0]));
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
            return;
        }
        Signer.sign(context, keyring, files);
        Signer.verify(context, keyring, files);
    }

    private static void verify(JReleaserContext context, Keyring keyring, List<FilePair> files) throws SigningException {
        if (null == keyring) {
            Signer.verify(context, files);
            return;
        }
        context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        for (FilePair pair : files) {
            pair.setValid(Signer.verify(context, keyring, pair));
            if (pair.isValid()) continue;
            throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{context.relativizeToBasedir(pair.inputFile), context.relativizeToBasedir(pair.signatureFile)}));
        }
    }

    private static void verify(JReleaserContext context, List<FilePair> files) throws SigningException {
        context.getLogger().debug(RB.$((String)"signing.verify.signatures", (Object[])new Object[0]), new Object[]{files.size()});
        for (FilePair pair : files) {
            pair.setValid(Signer.verify(context, pair));
            if (pair.isValid()) continue;
            throw new SigningException(RB.$((String)"ERROR_signing_verify_file", (Object[])new Object[]{context.relativizeToBasedir(pair.inputFile), context.relativizeToBasedir(pair.signatureFile)}));
        }
    }

    private static boolean verify(JReleaserContext context, Keyring keyring, FilePair filePair) throws SigningException {
        context.getLogger().setPrefix("verify");
        try {
            int ch;
            context.getLogger().debug("{}", new Object[]{context.relativizeToBasedir(filePair.signatureFile)});
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)new BufferedInputStream(new FileInputStream(filePair.signatureFile.toFile())));
            PGPObjectFactory pgpObjFactory = new PGPObjectFactory(sigInputStream, keyring.getKeyFingerPrintCalculator());
            Iterable pgpSigList = null;
            Object obj = pgpObjFactory.nextObject();
            if (obj instanceof PGPCompressedData) {
                PGPCompressedData c1 = (PGPCompressedData)obj;
                pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), keyring.getKeyFingerPrintCalculator());
                pgpSigList = (Iterable)pgpObjFactory.nextObject();
            } else {
                pgpSigList = (Iterable)obj;
            }
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(filePair.inputFile.toFile()));
            PGPSignature sig = (PGPSignature)pgpSigList.iterator().next();
            PGPPublicKey pubKey = keyring.readPublicKey();
            sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pubKey);
            while ((ch = ((InputStream)fileInputStream).read()) >= 0) {
                sig.update((byte)ch);
            }
            ((InputStream)fileInputStream).close();
            sigInputStream.close();
            boolean bl = sig.verify();
            return bl;
        }
        catch (IOException | PGPException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{context.relativizeToBasedir(filePair.inputFile)}), e);
        }
        finally {
            context.getLogger().restorePrefix();
        }
    }

    private static boolean verify(JReleaserContext context, FilePair filePair) throws SigningException {
        context.getLogger().setPrefix("verify");
        try {
            context.getLogger().debug("{}", new Object[]{context.relativizeToBasedir(filePair.signatureFile)});
            GpgCommandSigner commandSigner = Signer.initCommandSigner(context);
            boolean bl = commandSigner.verify(filePair.signatureFile, filePair.inputFile);
            return bl;
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{context.relativizeToBasedir(filePair.inputFile)}), (Throwable)e);
        }
        finally {
            context.getLogger().restorePrefix();
        }
    }

    private static void sign(JReleaserContext context, List<FilePair> files) throws SigningException {
        Path signaturesDirectory = context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), context.relativizeToBasedir(signaturesDirectory)});
        GpgCommandSigner commandSigner = Signer.initCommandSigner(context);
        for (FilePair pair : files) {
            Signer.sign(context, commandSigner, pair.inputFile, pair.signatureFile);
        }
    }

    private static GpgCommandSigner initCommandSigner(JReleaserContext context) {
        GpgCommandSigner cmd = new GpgCommandSigner(context.getLogger());
        Signing signing = context.getModel().getSigning();
        cmd.setExecutable(signing.getExecutable());
        cmd.setPassphrase(signing.getResolvedPassphrase());
        cmd.setHomeDir(signing.getHomeDir());
        cmd.setKeyName(signing.getKeyName());
        cmd.setPublicKeyring(signing.getPublicKeyring());
        cmd.setDefaultKeyring(signing.isDefaultKeyring().booleanValue());
        cmd.setArgs(signing.getArgs());
        return cmd;
    }

    private static void sign(JReleaserContext context, GpgCommandSigner commandSigner, Path input, Path output) throws SigningException {
        try {
            context.getLogger().info("{}", new Object[]{context.relativizeToBasedir(input)});
            commandSigner.sign(input, output);
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input.toAbsolutePath()}), (Throwable)e);
        }
    }

    private static void sign(JReleaserContext context, Keyring keyring, List<FilePair> files) throws SigningException {
        Path signaturesDirectory = context.getSignaturesDirectory();
        try {
            Files.createDirectories(signaturesDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_create_signature_dir", (Object[])new Object[0]), (Throwable)e);
        }
        context.getLogger().debug(RB.$((String)"signing.signing.files", (Object[])new Object[0]), new Object[]{files.size(), context.relativizeToBasedir(signaturesDirectory)});
        PGPSignatureGenerator signatureGenerator = Signer.initSignatureGenerator(context.getModel().getSigning(), keyring);
        for (FilePair pair : files) {
            Signer.sign(context, signatureGenerator, pair.inputFile, pair.signatureFile);
        }
    }

    private static PGPSignatureGenerator initSignatureGenerator(Signing signing, Keyring keyring) throws SigningException {
        try {
            PGPSecretKey pgpSecretKey = keyring.getSecretKey();
            PGPPrivateKey pgpPrivKey = pgpSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(signing.getResolvedPassphrase().toCharArray()));
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(pgpSecretKey.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
            signatureGenerator.init(0, pgpPrivKey);
            return signatureGenerator;
        }
        catch (PGPException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signature_gen", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static void sign(JReleaserContext context, PGPSignatureGenerator signatureGenerator, Path input, Path output) throws SigningException {
        try {
            int ch;
            context.getLogger().info("{}", new Object[]{context.relativizeToBasedir(input)});
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output.toFile()));
            if (context.getModel().getSigning().isArmored().booleanValue()) {
                out = new ArmoredOutputStream((OutputStream)out);
            }
            PGPCompressedDataGenerator compressionStreamGenerator = new PGPCompressedDataGenerator(0);
            BCPGOutputStream bOut = new BCPGOutputStream(compressionStreamGenerator.open((OutputStream)out));
            FileInputStream in = new FileInputStream(input.toFile());
            while ((ch = in.read()) >= 0) {
                signatureGenerator.update((byte)ch);
            }
            signatureGenerator.generate().encode((OutputStream)bOut);
            compressionStreamGenerator.close();
            in.close();
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (IOException | PGPException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input.toAbsolutePath()}), e);
        }
    }

    private static List<FilePair> collectArtifacts(JReleaserContext context, Keyring keyring) {
        FilePair pair;
        Path output;
        String extension;
        ArrayList<FilePair> files = new ArrayList<FilePair>();
        Path signaturesDirectory = context.getSignaturesDirectory();
        String string = extension = context.getModel().getSigning().isArmored() != false ? ".asc" : ".sig";
        if (context.getModel().getSigning().isFiles().booleanValue()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)context)) {
                if (!artifact.isActive() || artifact.extraPropertyIsTrue("skipSigning")) continue;
                Path input = artifact.getEffectivePath(context);
                output = signaturesDirectory.resolve(input.getFileName().toString().concat(extension));
                pair = new FilePair(input, output);
                pair.setValid(Signer.isValid(context, keyring, pair));
                files.add(pair);
            }
        }
        if (context.getModel().getSigning().isArtifacts().booleanValue()) {
            for (Distribution distribution : context.getModel().getActiveDistributions()) {
                if (!context.isDistributionIncluded(distribution) || distribution.extraPropertyIsTrue("skipSigning")) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActive() || artifact.extraPropertyIsTrue("skipSigning")) continue;
                    Path input = artifact.getEffectivePath(context, distribution);
                    Path output2 = signaturesDirectory.resolve(input.getFileName().toString().concat(extension));
                    FilePair pair2 = new FilePair(input, output2);
                    pair2.setValid(Signer.isValid(context, keyring, pair2));
                    files.add(pair2);
                }
            }
        }
        if (context.getModel().getSigning().isChecksums().booleanValue()) {
            for (Algorithm algorithm : context.getModel().getChecksum().getAlgorithms()) {
                Path checksums = context.getChecksumsDirectory().resolve(context.getModel().getChecksum().getResolvedName(context, algorithm));
                if (!Files.exists(checksums, new LinkOption[0])) continue;
                output = signaturesDirectory.resolve(checksums.getFileName().toString().concat(extension));
                pair = new FilePair(checksums, output);
                pair.setValid(Signer.isValid(context, keyring, pair));
                files.add(pair);
            }
        }
        return files;
    }

    private static List<FilePair> collectArtifacts(JReleaserContext context) {
        return Signer.collectArtifacts(context, null);
    }

    private static boolean isValid(JReleaserContext context, Keyring keyring, FilePair pair) {
        if (null == keyring) {
            return Signer.isValid(context, pair);
        }
        if (Files.notExists(pair.getSignatureFile(), new LinkOption[0])) {
            context.getLogger().debug(RB.$((String)"signing.signature.not.exist", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        if (pair.inputFile.toFile().lastModified() > pair.signatureFile.toFile().lastModified()) {
            context.getLogger().debug(RB.$((String)"signing.file.newer", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.inputFile), context.relativizeToBasedir(pair.signatureFile)});
            return false;
        }
        try {
            return Signer.verify(context, keyring, pair);
        }
        catch (SigningException e) {
            return false;
        }
    }

    private static boolean isValid(JReleaserContext context, FilePair pair) {
        if (Files.notExists(pair.getSignatureFile(), new LinkOption[0])) {
            context.getLogger().debug(RB.$((String)"signing.signature.not.exist", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.getSignatureFile())});
            return false;
        }
        if (pair.inputFile.toFile().lastModified() > pair.signatureFile.toFile().lastModified()) {
            context.getLogger().debug(RB.$((String)"signing.file.newer", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(pair.inputFile), context.relativizeToBasedir(pair.signatureFile)});
            return false;
        }
        try {
            return Signer.verify(context, pair);
        }
        catch (SigningException e) {
            return false;
        }
    }

    static {
        Security.removeProvider("BC");
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static class FilePair {
        private final Path inputFile;
        private final Path signatureFile;
        private boolean valid;

        private FilePair(Path inputFile, Path signatureFile) {
            this.inputFile = inputFile;
            this.signatureFile = signatureFile;
        }

        public Path getInputFile() {
            return this.inputFile;
        }

        public Path getSignatureFile() {
            return this.signatureFile;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public boolean isInvalid() {
            return !this.valid;
        }
    }
}

