/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.release;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Releaser;
import org.jreleaser.model.releaser.spi.ReleaserBuilder;
import org.jreleaser.model.releaser.spi.ReleaserBuilderFactory;

public class Releasers {
    public static void release(JReleaserContext context) throws ReleaseException {
        Releasers.releaserFor(context).release();
    }

    public static Releaser releaserFor(JReleaserContext context) {
        return Releasers.findReleaser(context).configureWith(context).build();
    }

    private static <T extends ReleaserBuilder> T findReleaser(JReleaserContext context) {
        Map<String, ReleaserBuilder> builders = StreamSupport.stream(ServiceLoader.load(ReleaserBuilderFactory.class, Releasers.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(ReleaserBuilderFactory::getName, ReleaserBuilderFactory::getBuilder));
        if (null != context.getModel().getRelease().getGithub()) {
            return (T)builders.get("github");
        }
        if (null != context.getModel().getRelease().getGitlab()) {
            return (T)builders.get("gitlab");
        }
        if (null != context.getModel().getRelease().getGitea()) {
            return (T)builders.get("gitea");
        }
        if (null != context.getModel().getRelease().getCodeberg()) {
            return (T)builders.get("codeberg");
        }
        if (null != context.getModel().getRelease().getGeneric()) {
            return (T)builders.get("generic");
        }
        throw new JReleaserException(RB.$((String)"ERROR_releaser_no_match", (Object[])new Object[0]));
    }
}

