/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.RepositoryTool;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.sdk.git.JReleaserGpgSigner;
import org.jreleaser.tools.AbstractTemplateToolProcessor;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

abstract class AbstractRepositoryToolProcessor<T extends RepositoryTool>
extends AbstractTemplateToolProcessor<T> {
    protected AbstractRepositoryToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        this.context.getLogger().info(RB.$((String)"repository.setup", (Object[])new Object[0]), new Object[]{((RepositoryTool)this.tool).getRepositoryTap().getCanonicalRepoName()});
        if (this.context.isDryrun()) {
            return;
        }
        GitService gitService = this.context.getModel().getRelease().getGitService();
        try {
            this.context.getLogger().debug(RB.$((String)"repository.locate", (Object[])new Object[0]), new Object[]{((RepositoryTool)this.tool).getRepositoryTap().getCanonicalRepoName()});
            Repository repository = this.context.getReleaser().maybeCreateRepository(((RepositoryTool)this.tool).getRepositoryTap().getOwner(), ((RepositoryTool)this.tool).getRepositoryTap().getResolvedName(), this.resolveGitToken(gitService));
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(this.resolveGitUsername(gitService), this.resolveGitToken(gitService));
            this.context.getLogger().debug(RB.$((String)"repository.clone", (Object[])new Object[0]), new Object[]{repository.getHttpUrl()});
            Path directory = Files.createTempDirectory("jreleaser-" + ((RepositoryTool)this.tool).getRepositoryTap().getResolvedName(), new FileAttribute[0]);
            Git git = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setBranch(((RepositoryTool)this.tool).getRepositoryTap().getBranch()).setDirectory(directory.toFile()).setURI(repository.getHttpUrl()).call();
            this.prepareWorkingCopy(props, directory, distribution);
            git.add().addFilepattern(".").call();
            this.context.getLogger().debug(RB.$((String)"repository.commit.setup", (Object[])new Object[0]));
            CommitCommand commitCommand = git.commit().setAll(true).setMessage(distribution.getExecutable() + " " + gitService.getResolvedTagName(this.context.getModel())).setAuthor(((RepositoryTool)this.tool).getCommitAuthor().getName(), ((RepositoryTool)this.tool).getCommitAuthor().getEmail());
            commitCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            commitCommand = commitCommand.setSign(Boolean.valueOf(gitService.isSign())).setSigningKey("**********").setGpgSigner((GpgSigner)new JReleaserGpgSigner(this.context, gitService.isSign()));
            commitCommand.call();
            this.context.getLogger().info(RB.$((String)"repository.push", (Object[])new Object[0]), new Object[]{((RepositoryTool)this.tool).getRepositoryTap().getCanonicalRepoName()});
            this.context.getLogger().debug(RB.$((String)"repository.commit.push", (Object[])new Object[0]));
            ((PushCommand)git.push().setDryRun(false).setPushAll().setCredentialsProvider((CredentialsProvider)credentialsProvider)).call();
        }
        catch (Exception e) {
            throw new ToolProcessingException(RB.$((String)"ERROR_unexpected_repository_update", (Object[])new Object[]{((RepositoryTool)this.tool).getRepositoryTap().getCanonicalRepoName()}), (Throwable)e);
        }
    }

    protected void prepareWorkingCopy(Map<String, Object> props, Path directory, Distribution distribution) throws ToolProcessingException, IOException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        this.prepareWorkingCopy(packageDirectory, directory);
    }

    protected void prepareWorkingCopy(Path source, Path destination) throws IOException {
        this.context.getLogger().debug(RB.$((String)"repository.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(source)});
        if (!FileUtils.copyFilesRecursive((JReleaserLogger)this.context.getLogger(), (Path)source, (Path)destination)) {
            throw new IOException(RB.$((String)"ERROR_repository_copy_files", (Object[])new Object[]{this.context.relativizeToBasedir(source)}));
        }
    }

    protected String resolveGitUsername(GitService gitService) {
        String username = ((RepositoryTool)this.tool).getRepositoryTap().getResolvedUsername(gitService);
        return StringUtils.isNotBlank((String)username) ? username : gitService.getResolvedUsername();
    }

    protected String resolveGitToken(GitService gitService) {
        String token = ((RepositoryTool)this.tool).getRepositoryTap().getResolvedToken(gitService);
        return StringUtils.isNotBlank((String)token) ? token : gitService.getResolvedToken();
    }
}

