/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.workflow;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.util.TimeUtils;
import org.jreleaser.workflow.Workflow;
import org.jreleaser.workflow.WorkflowItem;

class WorkflowImpl
implements Workflow {
    private final JReleaserContext context;
    private final List<WorkflowItem> items = new ArrayList<WorkflowItem>();

    public WorkflowImpl(JReleaserContext context, List<WorkflowItem> items) {
        this.context = context;
        this.items.addAll(items);
    }

    @Override
    public void execute() {
        JReleaserException exception = null;
        Instant start = Instant.now();
        this.context.getLogger().info(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{this.context.isDryrun()});
        for (WorkflowItem item : this.items) {
            try {
                item.invoke(this.context);
            }
            catch (JReleaserException e) {
                exception = e;
                break;
            }
        }
        Instant end = Instant.now();
        double duration = (double)Duration.between(start, end).toMillis() / 1000.0;
        this.context.getLogger().reset();
        this.context.report();
        if (null != exception) {
            this.context.getLogger().error(RB.$((String)"workflow.failure", (Object[])new Object[0]), new Object[]{TimeUtils.formatDuration((double)duration)});
            this.context.getLogger().trace((Throwable)exception);
            throw exception;
        }
        this.context.getLogger().info(RB.$((String)"workflow.success", (Object[])new Object[0]), new Object[]{TimeUtils.formatDuration((double)duration)});
    }
}

