/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifactory;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ArtifactoryValidator
extends Validator {
    public static void validateArtifactory(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("artifactory");
        Map<String, Artifactory> artifactory = context.getModel().getUpload().getArtifactory();
        for (Map.Entry<String, Artifactory> e : artifactory.entrySet()) {
            e.getValue().setName(e.getKey());
            ArtifactoryValidator.validateArtifactory(context, mode, e.getValue(), errors);
        }
    }

    private static void validateArtifactory(JReleaserContext context, JReleaserContext.Mode mode, Artifactory artifactory, Errors errors) {
        context.getLogger().debug("artifactory.{}", new Object[]{artifactory.getName()});
        if (!artifactory.isActiveSet()) {
            artifactory.setActive(Active.NEVER);
        }
        if (!artifactory.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!(artifactory.isArtifacts().booleanValue() || artifactory.isFiles().booleanValue() || artifactory.isSignatures().booleanValue())) {
            artifactory.disable();
            return;
        }
        if (StringUtils.isBlank((String)artifactory.getUploadUrl())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"artifactory." + artifactory.getName() + ".uploadUrl"}));
        }
        if (StringUtils.isBlank((String)artifactory.getDownloadUrl())) {
            artifactory.setDownloadUrl(artifactory.getUploadUrl());
        }
        switch (artifactory.resolveAuthorization()) {
            case BEARER: {
                artifactory.setPassword(ArtifactoryValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_PASSWORD", "artifactory.password", artifactory.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                artifactory.setUsername(ArtifactoryValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_USERNAME", "artifactory.username", artifactory.getUsername(), errors, context.isDryrun()));
                artifactory.setPassword(ArtifactoryValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_PASSWORD", "artifactory.password", artifactory.getPassword(), errors, context.isDryrun()));
                break;
            }
            case NONE: {
                errors.configuration(RB.$((String)"validation_value_cannot_be", (Object[])new Object[]{"artifactory." + artifactory.getName() + ".authorization", "NONE"}));
            }
        }
        ArtifactoryValidator.validateTimeout(artifactory);
    }
}

