/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.templates.TemplateGenerationException;
import org.jreleaser.templates.TemplateGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="template")
public class Template
extends AbstractCommand {
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    Composite composite;
    @CommandLine.Option(names={"-o", "--overwrite"})
    boolean overwrite;
    @CommandLine.Option(names={"-s", "--snapshot"})
    boolean snapshot;
    @CommandLine.ParentCommand
    Main parent;

    @Override
    protected Main parent() {
        return this.parent;
    }

    @Override
    protected void execute() {
        try {
            this.basedir = null != this.basedir ? this.basedir : Paths.get(".", new String[0]).normalize();
            this.initLogger();
            Path outputDirectory = this.basedir.resolve("src").resolve("jreleaser");
            Path output = TemplateGenerator.builder().logger(this.logger).distributionName(this.composite.distributionName()).distributionType(this.composite.distributionType()).toolName(this.composite.toolName()).announcerName(this.composite.announcerName()).outputDirectory(outputDirectory).overwrite(this.overwrite).snapshot(this.snapshot).build().generate();
            if (null != output && !this.quiet) {
                this.logger.info(this.bundle.getString("jreleaser.template.TEXT_success"), new Object[]{output.toAbsolutePath()});
            }
        }
        catch (TemplateGenerationException e) {
            throw new JReleaserException(this.bundle.getString("ERROR_unexpected_error"), (Throwable)e);
        }
    }

    @Override
    protected Path getOutputDirectory() {
        if (null != this.outputdir) {
            return this.outputdir.resolve("jreleaser");
        }
        return this.basedir.resolve("out").resolve("jreleaser");
    }

    static class Tools {
        @CommandLine.Option(names={"-dn", "--distribution-name"}, required=true)
        String distributionName;
        @CommandLine.Option(names={"-tn", "--tool-name"}, required=true)
        String toolName;
        @CommandLine.Option(names={"-dt", "--distribution-type"}, required=true, defaultValue="JAVA_BINARY")
        Distribution.DistributionType distributionType;

        Tools() {
        }
    }

    static class Announcers {
        @CommandLine.Option(names={"-an", "--announcer-name"}, descriptionKey="announcer.name", required=true)
        String announcerName;

        Announcers() {
        }
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, multiplicity="0..1", order=1, headingKey="announcer.header")
        Announcers announcers;
        @CommandLine.ArgGroup(exclusive=false, multiplicity="0..1", order=2, headingKey="tool.header")
        Tools tools;

        Composite() {
        }

        String announcerName() {
            return this.announcers != null ? this.announcers.announcerName : null;
        }

        String toolName() {
            return this.tools != null ? this.tools.toolName : null;
        }

        String distributionName() {
            return this.tools != null ? this.tools.distributionName : null;
        }

        Distribution.DistributionType distributionType() {
            return this.tools != null ? this.tools.distributionType : null;
        }
    }
}

