/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.assemble;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.assemble.DistributionAssembler;
import org.jreleaser.model.Assemble;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;

public class Assemblers {
    public static void assemble(JReleaserContext context) {
        Assemble assemble = context.getModel().getAssemble();
        if (!assemble.isEnabled()) {
            context.getLogger().info(RB.$((String)"assemblers.not.enabled", (Object[])new Object[0]));
            return;
        }
        if (context.hasAssemblerName()) {
            Map assemblers = assemble.findAssemblersByType(context.getAssemblerName());
            if (assemblers.isEmpty()) {
                context.getLogger().debug(RB.$((String)"assemblers.no.match", (Object[])new Object[0]), new Object[]{context.getAssemblerName()});
                return;
            }
            if (context.hasDistributionName()) {
                if (!assemblers.containsKey(context.getDistributionName())) {
                    context.getLogger().error(RB.$((String)"assemblers.distribution.not.configured", (Object[])new Object[0]), new Object[]{context.getDistributionName(), context.getAssemblerName()});
                    return;
                }
                context.getLogger().info(RB.$((String)"assemblers.assemble.distribution.with", (Object[])new Object[0]), new Object[]{context.getDistributionName(), context.getAssemblerName()});
                Assemblers.assemble(context, (Assembler)assemblers.get(context.getDistributionName()));
            } else {
                context.getLogger().info(RB.$((String)"assemblers.assemble.all.distributions.with", (Object[])new Object[0]), new Object[]{context.getAssemblerName()});
                assemblers.values().forEach(assembler -> Assemblers.assemble(context, assembler));
            }
        } else if (context.hasDistributionName()) {
            context.getLogger().info(RB.$((String)"assemblers.assemble.distribution.with.all", (Object[])new Object[0]), new Object[]{context.getDistributionName()});
            assemble.findAllAssemblers().stream().filter(a -> context.getDistributionName().equals(a.getName())).forEach(assembler -> Assemblers.assemble(context, assembler));
        } else {
            context.getLogger().info(RB.$((String)"assemblers.assemble.all.distributions", (Object[])new Object[0]));
            assemble.findAllAssemblers().forEach(assembler -> Assemblers.assemble(context, assembler));
        }
    }

    private static void assemble(JReleaserContext context, Assembler assembler) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(assembler.getType());
            DistributionAssembler processor = Assemblers.createDistributionAssembler(context, assembler);
            processor.assemble();
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
        catch (AssemblerProcessingException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static DistributionAssembler createDistributionAssembler(JReleaserContext context, Assembler assembler) {
        return DistributionAssembler.builder().context(context).assembler(assembler).build();
    }
}

