/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.assemblers.AbstractJavaAssemblerProcessor;
import org.jreleaser.assemblers.AssemblerUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.model.NativeImage;
import org.jreleaser.model.Project;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;
import org.jreleaser.util.command.Command;

public class NativeImageAssemblerProcessor
extends AbstractJavaAssemblerProcessor<NativeImage> {
    private static final String KEY_GRAALVM_VERSION = "GRAALVM_VERSION";

    public NativeImageAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Path graalPath = ((NativeImage)this.assembler).getGraal().getEffectivePath(this.context, this.assembler);
        Version javaVersion = Version.of((String)AssemblerUtils.readJavaVersion(graalPath));
        Version graalVersion = Version.of((String)this.readGraalVersion(graalPath));
        this.context.getLogger().debug(RB.$((String)"assembler.graal.java", (Object[])new Object[0]), new Object[]{javaVersion, graalPath.toAbsolutePath().toString()});
        this.context.getLogger().debug(RB.$((String)"assembler.graal.graal", (Object[])new Object[0]), new Object[]{graalVersion, graalPath.toAbsolutePath().toString()});
        String platform = ((NativeImage)this.assembler).getGraal().getPlatform();
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path jarsDirectory = assembleDirectory.resolve("jars");
        Path universalJarsDirectory = jarsDirectory.resolve("universal");
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(universalJarsDirectory)});
        Set<Path> jars = AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, universalJarsDirectory, "");
        Path platformJarsDirectory = jarsDirectory.resolve(platform);
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(platformJarsDirectory)});
        jars.addAll(AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, platformJarsDirectory, platform));
        this.installNativeImage(graalPath);
        String imageName = ((NativeImage)this.assembler).getResolvedImageName(this.context);
        if (StringUtils.isNotBlank((String)((NativeImage)this.assembler).getImageNameTransform())) {
            imageName = ((NativeImage)this.assembler).getResolvedImageNameTransform(this.context);
        }
        this.nativeImage(assembleDirectory, graalPath, jars, imageName);
    }

    private void installNativeImage(Path graalPath) throws AssemblerProcessingException {
        Path nativeImageExecutable = graalPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "native-image.exe" : "native-image").toAbsolutePath();
        if (!Files.exists(nativeImageExecutable, new LinkOption[0])) {
            this.context.getLogger().debug(RB.$((String)"assembler.graal.install.native.exec", (Object[])new Object[0]));
            Command cmd = new Command(graalPath.resolve("bin").resolve("gu").toAbsolutePath().toString()).arg("install").arg("native-image");
            this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
            this.executeCommand(cmd);
        }
    }

    private Artifact nativeImage(Path assembleDirectory, Path graalPath, Set<Path> jars, String imageName) throws AssemblerProcessingException {
        String platform = ((NativeImage)this.assembler).getGraal().getPlatform();
        String platformReplaced = ((NativeImage)this.assembler).getPlatform().applyReplacements(platform);
        String finalImageName = imageName + "-" + platformReplaced;
        String executable = ((NativeImage)this.assembler).getExecutable();
        this.context.getLogger().info("- {}", new Object[]{finalImageName});
        Path image = assembleDirectory.resolve(executable).toAbsolutePath();
        try {
            if (Files.exists(image, new LinkOption[0])) {
                Files.deleteIfExists(image);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_image", (Object[])new Object[]{executable}), (Throwable)e);
        }
        ((NativeImage)this.assembler).getArgs().stream().filter(arg -> arg.startsWith("-H:Name")).findFirst().ifPresent(((NativeImage)this.assembler).getArgs()::remove);
        Command cmd = new Command(graalPath.resolve("bin").resolve("native-image").toAbsolutePath().toString()).args((Collection)((NativeImage)this.assembler).getArgs()).arg("-jar").arg(((NativeImage)this.assembler).getMainJar().getEffectivePath(this.context, this.assembler).toAbsolutePath().toString());
        if (!jars.isEmpty()) {
            cmd.arg("-cp").arg(jars.stream().map(path -> this.context.relativize(image.getParent(), path)).map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        }
        cmd.arg("-H:Name=" + image.getFileName().toString());
        this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        this.executeCommand(image.getParent(), cmd);
        try {
            Path tempDirectory = Files.createTempDirectory("jreleaser", new FileAttribute[0]);
            Path distDirectory = tempDirectory.resolve(finalImageName);
            Files.createDirectories(distDirectory, new FileAttribute[0]);
            Path binDirectory = distDirectory.resolve("bin");
            Files.createDirectories(binDirectory, new FileAttribute[0]);
            Files.copy(image, binDirectory.resolve(image.getFileName()), new CopyOption[0]);
            this.copyFiles(this.context, distDirectory);
            this.copyFileSets(this.context, distDirectory);
            Path imageArchive = assembleDirectory.resolve(finalImageName + "." + ((NativeImage)this.assembler).getArchiveFormat().extension());
            switch (((NativeImage)this.assembler).getArchiveFormat()) {
                case ZIP: {
                    FileUtils.zip((Path)tempDirectory, (Path)imageArchive);
                    break;
                }
                case TAR: {
                    FileUtils.tar((Path)tempDirectory, (Path)imageArchive);
                    break;
                }
                case TGZ: 
                case TAR_GZ: {
                    FileUtils.tgz((Path)tempDirectory, (Path)imageArchive);
                    break;
                }
                case TXZ: 
                case TAR_XZ: {
                    FileUtils.xz((Path)tempDirectory, (Path)imageArchive);
                    break;
                }
                case TBZ2: 
                case TAR_BZ2: {
                    FileUtils.bz2((Path)tempDirectory, (Path)imageArchive);
                }
            }
            this.context.getLogger().debug("- {}", new Object[]{imageArchive.getFileName()});
            return Artifact.of((Path)imageArchive, (String)platform);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private String readGraalVersion(Path path) throws AssemblerProcessingException {
        Path release = path.resolve("release");
        if (!Files.exists(release, new LinkOption[0])) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_graal_release", (Object[])new Object[]{path.toAbsolutePath()}));
        }
        try {
            Properties props = new Properties();
            props.load(Files.newInputStream(release, new OpenOption[0]));
            if (props.containsKey(KEY_GRAALVM_VERSION)) {
                String version = props.getProperty(KEY_GRAALVM_VERSION);
                if (version.startsWith("\"") && version.endsWith("\"")) {
                    return version.substring(1, version.length() - 1);
                }
                return version;
            }
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_graal_release_file", (Object[])new Object[]{release.toAbsolutePath()}));
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_graal_release_file", (Object[])new Object[]{release.toAbsolutePath()}), (Throwable)e);
        }
    }

    @Override
    protected void writeFile(Project project, String content, Map<String, Object> props, String fileName) throws AssemblerProcessingException {
    }
}

