/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifactory;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;

public abstract class ArtifactoryValidator
extends Validator {
    public static void validateArtifactory(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("artifactory");
        Map<String, Artifactory> artifactory = context.getModel().getUpload().getArtifactory();
        for (Map.Entry<String, Artifactory> e : artifactory.entrySet()) {
            e.getValue().setName(e.getKey());
            ArtifactoryValidator.validateArtifactory(context, mode, e.getValue(), errors);
        }
    }

    private static void validateArtifactory(JReleaserContext context, JReleaserContext.Mode mode, Artifactory artifactory, Errors errors) {
        context.getLogger().debug("artifactory.{}", new Object[]{artifactory.getName()});
        if (!artifactory.isActiveSet()) {
            artifactory.setActive(Active.NEVER);
        }
        if (!artifactory.resolveEnabled(context.getModel().getProject()) || mode != JReleaserContext.Mode.FULL) {
            return;
        }
        if (!(artifactory.isArtifacts().booleanValue() || artifactory.isFiles().booleanValue() || artifactory.isSignatures().booleanValue())) {
            artifactory.disable();
            return;
        }
        if (artifactory.getRepositories().isEmpty()) {
            errors.configuration(RB.$((String)"validation_artifactory_no_repositories", (Object[])new Object[]{"artifactory." + artifactory.getName()}));
            return;
        }
        artifactory.setHost(ArtifactoryValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_HOST", "artifactory.host", artifactory.getHost(), errors));
        switch (artifactory.resolveAuthorization()) {
            case BEARER: {
                artifactory.setPassword(ArtifactoryValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_PASSWORD", "artifactory.password", artifactory.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                artifactory.setUsername(ArtifactoryValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_USERNAME", "artifactory.username", artifactory.getUsername(), errors, context.isDryrun()));
                artifactory.setPassword(ArtifactoryValidator.checkProperty(context, "ARTIFACTORY_" + Env.toVar((String)artifactory.getName()) + "_PASSWORD", "artifactory.password", artifactory.getPassword(), errors, context.isDryrun()));
                break;
            }
            case NONE: {
                errors.configuration(RB.$((String)"validation_value_cannot_be", (Object[])new Object[]{"artifactory." + artifactory.getName() + ".authorization", "NONE"}));
            }
        }
        ArtifactoryValidator.validateTimeout(artifactory);
        for (Artifactory.ArtifactoryRepository repository : artifactory.getRepositories()) {
            if (!repository.isActiveSet()) {
                repository.setActive(artifactory.getActive());
            }
            repository.resolveEnabled(context.getModel().getProject());
        }
        if (artifactory.getRepositories().stream().noneMatch(Artifactory.ArtifactoryRepository::isEnabled)) {
            errors.warning(RB.$((String)"validation_artifactory_disabled_repositories", (Object[])new Object[]{"artifactory." + artifactory.getName()}));
            artifactory.disable();
        }
    }
}

