/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.Announcer;
import org.jreleaser.model.Project;

abstract class AbstractAnnouncer
implements Announcer {
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    protected String name;
    @JsonIgnore
    protected boolean enabled;
    protected Active active;
    private int connectTimeout;
    private int readTimeout;

    protected AbstractAnnouncer(String name) {
        this.name = name;
    }

    void setAll(AbstractAnnouncer announcer) {
        this.active = announcer.active;
        this.enabled = announcer.enabled;
        this.connectTimeout = announcer.connectTimeout;
        this.readTimeout = announcer.readTimeout;
        this.setExtraProperties(announcer.extraProperties);
    }

    @Override
    public String getPrefix() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check(project);
        if (project.isSnapshot() && !this.isSnapshotSupported()) {
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.active = Active.of(str);
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", (Object)this.active);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        this.asMap(props, full);
        props.put("extraProperties", this.getResolvedExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(Map<String, Object> var1, boolean var2);
}

