/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.Token;

public class Brackets
extends TokenRule {
    public static final String OPTION_FORBID = "forbid";
    public static final String OPTION_MIN_SPACES_INSIDE = "min-spaces-inside";
    public static final String OPTION_MAX_SPACES_INSIDE = "max-spaces-inside";
    public static final String OPTION_MIN_SPACES_INSIDE_EMPTY = "min-spaces-inside-empty";
    public static final String OPTION_MAX_SPACES_INSIDE_EMPTY = "max-spaces-inside-empty";

    public Brackets() {
        this.registerOption(OPTION_FORBID, false);
        this.registerOption(OPTION_MIN_SPACES_INSIDE, 0);
        this.registerOption(OPTION_MAX_SPACES_INSIDE, 0);
        this.registerOption(OPTION_MIN_SPACES_INSIDE_EMPTY, -1);
        this.registerOption(OPTION_MAX_SPACES_INSIDE_EMPTY, -1);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        if (((Boolean)conf.get(OPTION_FORBID)).booleanValue() && token instanceof FlowSequenceStartToken) {
            return Collections.singletonList(new LintProblem(token.getStartMark().getLine() + 1, token.getEndMark().getColumn() + 1, "forbidden flow sequence"));
        }
        LintProblem problem = null;
        if (token instanceof FlowSequenceStartToken && next instanceof FlowSequenceEndToken) {
            problem = this.spacesAfter(token, next, (int)((Integer)(conf.get(OPTION_MIN_SPACES_INSIDE_EMPTY).equals(-1) ? conf.get(OPTION_MIN_SPACES_INSIDE) : conf.get(OPTION_MIN_SPACES_INSIDE_EMPTY))), (int)((Integer)(conf.get(OPTION_MAX_SPACES_INSIDE_EMPTY).equals(-1) ? conf.get(OPTION_MAX_SPACES_INSIDE) : conf.get(OPTION_MAX_SPACES_INSIDE_EMPTY))), "too few spaces inside empty brackets", "too many spaces inside empty brackets");
        } else if (token instanceof FlowSequenceStartToken) {
            problem = this.spacesAfter(token, next, (int)((Integer)conf.get(OPTION_MIN_SPACES_INSIDE)), (int)((Integer)conf.get(OPTION_MAX_SPACES_INSIDE)), "too few spaces inside brackets", "too many spaces inside brackets");
        } else if (token instanceof FlowSequenceEndToken && !(prev instanceof FlowSequenceStartToken)) {
            problem = this.spacesBefore(token, prev, (int)((Integer)conf.get(OPTION_MIN_SPACES_INSIDE)), (int)((Integer)conf.get(OPTION_MAX_SPACES_INSIDE)), "too few spaces inside brackets", "too many spaces inside brackets");
        }
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (problem != null) {
            problems.add(problem);
        }
        return problems;
    }
}

