/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.config.yaml.lint;

import com.github.sbaudoin.yamllint.YamlLintConfig;
import com.github.sbaudoin.yamllint.YamlLintConfigException;
import com.github.sbaudoin.yamllint.rules.Rule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jreleaser.config.yaml.lint.RuleFactory;

public class YamlLintConfig2
extends YamlLintConfig {
    public YamlLintConfig2(CharSequence content) throws YamlLintConfigException {
        super(content);
    }

    public YamlLintConfig2(URL file) throws IOException, YamlLintConfigException {
        super(file);
    }

    public YamlLintConfig2(InputStream in) throws YamlLintConfigException {
        super(in);
    }

    public List<Rule> getEnabledRules(File file) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Map.Entry entry : this.ruleConf.entrySet()) {
            Rule rule = RuleFactory.instance.getRule((String)entry.getKey());
            if (rule == null || entry.getValue() == null || file != null && rule.ignores(file)) continue;
            rules.add(rule);
        }
        return rules;
    }

    protected void validate() throws YamlLintConfigException {
        for (Map.Entry entry : this.ruleConf.entrySet()) {
            String id = (String)entry.getKey();
            Rule rule = RuleFactory.instance.getRule(id);
            if (rule == null) {
                throw YamlLintConfig2.getInvalidConfigException(String.format("no such rule: \"%s\"", id));
            }
            Map newConf = YamlLintConfig2.validateRuleConf((Rule)rule, entry.getValue());
            this.ruleConf.put(id, newConf);
        }
    }

    private static YamlLintConfigException getInvalidConfigException(String message) {
        return YamlLintConfig2.getInvalidConfigException(null, message, null);
    }

    private static YamlLintConfigException getInvalidConfigException(String specifier, String message, Throwable e) {
        String m = String.format("invalid%s config: %s", specifier == null ? "" : " " + specifier, message);
        if (e == null) {
            return new YamlLintConfigException(m);
        }
        return new YamlLintConfigException(m, e);
    }
}

