/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.FFParam;

class UFFTorsionCalc
extends Calculation {
    UFFTorsionCalc() {
    }

    void setData(Lst<Object[]> calc, int[] t) {
        double cosNPhi0 = -1.0;
        int n = 0;
        double V = 0.0;
        this.ia = t[0];
        this.a = this.calcs.minAtoms[this.ia];
        this.ib = t[1];
        this.b = this.calcs.minAtoms[this.ib];
        this.ic = t[2];
        this.c = this.calcs.minAtoms[this.ic];
        this.id = t[3];
        this.d = this.calcs.minAtoms[this.id];
        MinBond bc = this.c.getBondTo(this.ib);
        double bondOrder = bc.order;
        if (bc.isAromatic) {
            bondOrder = 1.5;
        }
        if (bc.isAmide) {
            bondOrder = 1.41;
        }
        this.calcs.parB = (FFParam)this.calcs.getParameter(this.b.sType);
        this.calcs.parC = (FFParam)this.calcs.getParameter(this.c.sType);
        switch (this.calcs.parB.iVal[0] * this.calcs.parC.iVal[0]) {
            case 9: {
                n = 3;
                double vi = this.calcs.parB.dVal[6];
                double vj = this.calcs.parC.dVal[6];
                double viNew = 0.0;
                switch (this.b.atom.getElementNumber()) {
                    case 8: {
                        viNew = 2.0;
                        break;
                    }
                    case 16: 
                    case 34: 
                    case 52: 
                    case 84: {
                        viNew = 6.8;
                    }
                }
                if (viNew != 0.0) {
                    switch (this.c.atom.getElementNumber()) {
                        case 8: {
                            vi = viNew;
                            vj = 2.0;
                            n = 2;
                            break;
                        }
                        case 16: 
                        case 34: 
                        case 52: 
                        case 84: {
                            vi = viNew;
                            vj = 6.8;
                            n = 2;
                        }
                    }
                }
                V = 2.0934 * Math.sqrt(vi * vj);
                break;
            }
            case 4: {
                cosNPhi0 = 1.0;
                n = 2;
                V = 10.466999999999999 * Math.sqrt(this.calcs.parB.dVal[7] * this.calcs.parC.dVal[7]) * (1.0 + 4.18 * Math.log(bondOrder));
                break;
            }
            case 6: {
                cosNPhi0 = 1.0;
                n = 6;
                boolean sp3C = this.calcs.parC.iVal[0] == 3;
                block13 : switch ((sp3C ? this.c : this.b).atom.getElementNumber()) {
                    case 8: 
                    case 16: 
                    case 34: 
                    case 52: 
                    case 84: {
                        switch ((sp3C ? this.b : this.c).atom.getElementNumber()) {
                            case 8: 
                            case 16: 
                            case 34: 
                            case 52: 
                            case 84: {
                                break block13;
                            }
                        }
                        n = 2;
                        cosNPhi0 = -1.0;
                    }
                }
                V = 2.0934;
            }
        }
        if (Util.isNearZero(V)) {
            return;
        }
        calc.addLast((Object)new Object[]{new int[]{this.ia, this.ib, this.ic, this.id, n}, new double[]{V, cosNPhi0}});
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        int n = this.iData[4];
        double V = this.dData[0];
        double cosNPhi0 = this.dData[1];
        this.calcs.setTorsionVariables(this);
        this.energy = V * (1.0 - cosNPhi0 * Math.cos(this.theta * (double)n));
        if (this.calcs.gradients) {
            this.dE = V * (double)n * cosNPhi0 * Math.sin((double)n * this.theta);
            this.calcs.addForces(this, 4);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(2, this));
        }
        return this.energy;
    }
}

