/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAromatic;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMeasure;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesRing;
import org.jmol.smiles.SmilesStereo;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleNode;

public class SmilesSearch
extends JmolMolecule {
    boolean isSmarts;
    SmilesSearch top;
    String pattern;
    SmilesAtom[] patternAtoms = new SmilesAtom[16];
    Node[] targetAtoms;
    int targetAtomCount;
    private BS bsSelected;
    VTemp v;
    boolean aromaticOpen;
    boolean aromaticStrict;
    boolean aromaticPlanar;
    boolean aromaticDouble;
    boolean aromaticMMFF94;
    boolean aromaticDefined;
    boolean aromaticUnknown;
    boolean noAromatic;
    boolean ignoreAtomClass;
    boolean ignoreStereochemistry;
    boolean invertStereochemistry;
    boolean exitFirstMatch;
    boolean groupByModel;
    boolean setAtropicity;
    boolean patternAromatic;
    boolean haveTopo;
    boolean isTopology;
    boolean patternBioSequence;
    SmilesSearch[] subSearches;
    boolean haveSelected;
    boolean haveBondStereochemistry;
    SmilesStereo stereo;
    boolean needRingData;
    boolean needAromatic = true;
    boolean needRingMemberships;
    int nDouble;
    int ringDataMax = Integer.MIN_VALUE;
    Lst<BS> ringSets;
    int ringCount;
    Lst<SmilesMeasure> measures = new Lst();
    int flags;
    BS bsAromatic = new BS();
    BS bsAromatic5 = new BS();
    BS bsAromatic6 = new BS();
    String atropKeys;
    SmilesAtom lastChainAtom;
    boolean asVector;
    boolean getMaps;
    boolean isNormalized;
    boolean haveComponents;
    private boolean isSilent;
    private boolean isRingCheck;
    private int selectedAtomCount;
    private BS[] ringData;
    private int[] ringCounts;
    private int[] ringConnections;
    private BS bsFound = new BS();
    private Map<String, Object> htNested;
    private int nNested;
    private SmilesBond nestedBond;
    private Lst<Object> vReturn;
    private Lst<BS> uniqueList;
    private BS bsReturn = new BS();
    private BS bsCheck;
    public boolean mapUnique;
    private BS bsAromaticRings;
    private static final int SUBMODE_NESTED = 1;
    private static final int SUBMODE_RINGCHECK = 2;
    private static final int SUBMODE_OR = 3;

    public SmilesSearch() {
        this.top = this;
        this.v = new VTemp();
    }

    void setTop(SmilesSearch parent) {
        while (parent.top != parent) {
            parent = parent.top;
        }
        this.top = parent;
    }

    static final int addFlags(int flags, String strFlags) {
        if (strFlags.indexOf("OPEN") >= 0) {
            flags |= 5;
        }
        if (strFlags.indexOf("BIO") >= 0) {
            flags |= 0x100000;
        }
        if (strFlags.indexOf("HYDROGEN") >= 0) {
            flags |= 0x1000;
        }
        if (strFlags.indexOf("FIRSTMATCHONLY") >= 0) {
            flags |= 8;
        }
        if (strFlags.indexOf("STRICT") >= 0) {
            flags |= 0x100;
        }
        if (strFlags.indexOf("PLANAR") >= 0) {
            flags |= 0x400;
        }
        if (strFlags.indexOf("NOAROMATIC") >= 0 || strFlags.indexOf("NONAROMATIC") >= 0) {
            flags |= 0x10;
        }
        if (strFlags.indexOf("AROMATICDOUBLE") >= 0) {
            flags |= 0x200;
        }
        if (strFlags.indexOf("AROMATICDEFINED") >= 0) {
            flags |= 0x80;
        }
        if (strFlags.indexOf("MMFF94") >= 0) {
            flags |= 0x300;
        }
        if (strFlags.indexOf("TOPOLOGY") >= 0) {
            flags |= 0x2000;
        }
        if (strFlags.indexOf("NOATOMCLASS") >= 0) {
            flags |= 0x800;
        }
        if (strFlags.indexOf("NOSTEREO") >= 0) {
            flags |= 0x20;
        } else if (strFlags.indexOf("INVERTSTEREO") >= 0) {
            flags = (flags & 0x40) != 0 ? (flags &= 0xFFFFFFBF) : (flags |= 0x40);
        }
        if (strFlags.indexOf("ATOMCOMMENT") >= 0) {
            flags |= 0x20000;
        }
        if (strFlags.indexOf("GROUPBYMODEL") >= 0) {
            flags |= 0x4000000;
        }
        if ((flags & 0x100000) == 0x100000) {
            if (strFlags.indexOf("NOCOMMENT") >= 0) {
                flags |= 0x2100000;
            }
            if (strFlags.indexOf("UNMATCHED") >= 0) {
                flags |= 0x300000;
            }
            if (strFlags.indexOf("COVALENT") >= 0) {
                flags |= 0x500000;
            }
            if (strFlags.indexOf("HBOND") >= 0) {
                flags |= 0x900000;
            }
        }
        return flags;
    }

    void setFlags(int flags) {
        this.flags = flags;
        this.exitFirstMatch |= (flags & 8) == 8;
        this.aromaticOpen = (flags & 5) == 5;
        this.aromaticDouble = (flags & 0x200) == 512;
        this.aromaticStrict = (flags & 0x100) == 256;
        this.aromaticPlanar = (flags & 0x400) == 1024;
        this.aromaticMMFF94 = (flags & 0x300) == 768;
        this.aromaticDefined = (flags & 0x80) == 128;
        this.noAromatic = (flags & 0x10) == 16;
        this.aromaticUnknown = !this.noAromatic && !this.aromaticOpen && !this.aromaticDouble && !this.aromaticStrict && !this.aromaticPlanar && !this.aromaticMMFF94 && !this.aromaticDefined;
        this.groupByModel = (flags & 0x4000000) == 0x4000000;
        this.ignoreAtomClass = (flags & 0x800) == 2048;
        this.ignoreStereochemistry = (flags & 0x20) == 32;
        this.invertStereochemistry = !this.ignoreStereochemistry && (flags & 0x40) == 64;
    }

    void set() throws InvalidSmilesException {
        if (this.patternAtoms.length > this.ac) {
            this.patternAtoms = (SmilesAtom[])AU.arrayCopyObject((Object)this.patternAtoms, (int)this.ac);
        }
        this.nodes = this.patternAtoms;
        this.isTopology = true;
        this.patternAromatic = false;
        this.patternBioSequence = true;
        int i = this.ac;
        while (--i >= 0) {
            SmilesAtom atom = this.patternAtoms[i];
            if (this.isTopology && atom.isDefined()) {
                this.isTopology = false;
            }
            if (!atom.isBioResidue) {
                this.patternBioSequence = false;
            }
            if (atom.isAromatic) {
                this.patternAromatic = true;
            }
            atom.setBondArray();
            if (this.isSmarts || atom.bioType != '\u0000' || atom.setHydrogenCount()) continue;
            throw new InvalidSmilesException("unbracketed atoms must be one of: B, C, N, O, P, S, F, Cl, Br, I, *,");
        }
        if (this.haveComponents) {
            i = this.ac;
            while (--i >= 0) {
                SmilesAtom a = this.patternAtoms[i];
                SmilesBond[] bonds = a.bonds;
                int ia = a.component;
                int j = a.bondCount;
                while (--j >= 0) {
                    int ib;
                    SmilesBond b = bonds[j];
                    if (!b.isConnection || b.atom2 != a || (ib = b.atom1.component) == ia) continue;
                    int k = this.ac;
                    while (--k >= 0) {
                        if (this.patternAtoms[k].component != ia) continue;
                        this.patternAtoms[k].component = ib;
                    }
                }
            }
        }
    }

    void setSelected(BS bs) {
        if (bs == null) {
            bs = BS.newN((int)this.targetAtomCount);
            bs.setBits(0, this.targetAtomCount);
        }
        this.bsSelected = bs;
    }

    SmilesAtom addAtom() {
        return this.appendAtom(new SmilesAtom());
    }

    SmilesAtom appendAtom(SmilesAtom sAtom) {
        if (this.ac >= this.patternAtoms.length) {
            this.patternAtoms = (SmilesAtom[])AU.doubleLength((Object)this.patternAtoms);
        }
        this.patternAtoms[this.ac] = sAtom.setIndex(this.ac++);
        return this.patternAtoms[this.ac];
    }

    int addNested(String pattern) {
        if (this.htNested == null) {
            this.htNested = new Hashtable<String, Object>();
        }
        this.setNested(++this.nNested, pattern);
        return this.nNested;
    }

    void clear() {
        this.bsReturn.clearAll();
        this.nNested = 0;
        this.htNested = null;
        this.nestedBond = null;
        this.clearBsFound(-1);
    }

    private void clearBsFound(int iAtom) {
        if (iAtom < 0) {
            if (this.bsCheck == null) {
                this.bsFound.clearAll();
            }
        } else {
            this.bsFound.clear(iAtom);
        }
    }

    void setNested(int iNested, Object o) {
        this.top.htNested.put("_" + iNested, o);
    }

    Object getNested(int iNested) {
        return this.top.htNested.get("_" + iNested);
    }

    int getMissingHydrogenCount() {
        int n = 0;
        for (int i = 0; i < this.ac; ++i) {
            int nH = this.patternAtoms[i].explicitHydrogenCount;
            if (nH < 0) continue;
            n += nH;
        }
        return n;
    }

    void setRingData(BS bsA, Lst<BS>[] vRings, boolean doProcessAromatic) throws InvalidSmilesException {
        if (this.isTopology || this.patternBioSequence) {
            this.needAromatic = false;
        }
        if (this.needAromatic) {
            this.needRingData = true;
        }
        this.needAromatic &= bsA == null & !this.noAromatic;
        if (!this.needAromatic) {
            this.bsAromatic.clearAll();
            if (bsA != null) {
                this.bsAromatic.or(bsA);
            }
            if (!this.needRingMemberships && !this.needRingData) {
                return;
            }
        }
        this.getRingData(vRings, this.needRingData, doProcessAromatic);
    }

    void getRingData(Lst<BS>[] vRings, boolean needRingData, boolean doTestAromatic) throws InvalidSmilesException {
        int i;
        int strictness;
        Lst lstSP2;
        boolean isStrict;
        boolean bl = isStrict = this.needAromatic && (this.aromaticStrict || !this.aromaticOpen && !this.aromaticPlanar);
        if (isStrict && this.aromaticUnknown && this.targetAtomCount > 0 && this.targetAtoms[this.bsSelected.nextSetBit(0)].modelIsRawPDB()) {
            isStrict = false;
        }
        boolean isOpenNotStrict = this.needAromatic && this.aromaticOpen && !this.aromaticStrict;
        boolean checkExplicit = this.needAromatic && !isStrict;
        boolean doFinalize = this.needAromatic && doTestAromatic && (isStrict || isOpenNotStrict);
        boolean setAromatic = this.needAromatic && !this.aromaticDefined;
        int aromaticMax = 7;
        Lst lstAromatic = vRings == null ? new Lst() : new Lst();
        Lst lst = lstSP2 = doFinalize ? new Lst() : null;
        int n = !isStrict ? 0 : (strictness = this.aromaticMMFF94 ? 2 : 1);
        if (this.needAromatic && this.aromaticDefined) {
            SmilesAromatic.checkAromaticDefined(this.targetAtoms, this.bsSelected, this.bsAromatic);
            strictness = 0;
        }
        if (this.ringDataMax < 0) {
            this.ringDataMax = 8;
        }
        if (strictness > 0 && this.ringDataMax < 6) {
            this.ringDataMax = 6;
        }
        if (needRingData) {
            this.ringCounts = new int[this.targetAtomCount];
            this.ringConnections = new int[this.targetAtomCount];
            this.ringData = new BS[this.ringDataMax + 1];
        }
        this.ringSets = new Lst();
        if (this.targetAtomCount < 3) {
            return;
        }
        String s = "****";
        int max = this.ringDataMax;
        while (s.length() < max) {
            s = s + s;
        }
        int[] eCounts = doFinalize && setAromatic ? new int[this.targetAtomCount] : null;
        boolean justCheckBonding = setAromatic && this.targetAtoms[0] instanceof SmilesAtom;
        for (i = 3; i <= max && i <= this.targetAtomCount; ++i) {
            String smarts = "*1" + s.substring(0, i - 2) + "*1";
            SmilesSearch search = SmilesParser.newSearch(smarts, true, true);
            Lst vR = (Lst)this.subsearch(search, 2);
            if (vRings != null && i <= 5) {
                Lst v = new Lst();
                int j = vR.size();
                while (--j >= 0) {
                    v.addLast((Object)((BS)vR.get(j)));
                }
                vRings[i - 3] = v;
            }
            if (vR.size() == 0) continue;
            if (setAromatic && i >= 4 && i <= aromaticMax) {
                SmilesAromatic.setAromatic(i, this.targetAtoms, this.bsSelected, (Lst<Object>)vR, this.bsAromatic, strictness, isOpenNotStrict, justCheckBonding, checkExplicit, this.v, (Lst<BS>)lstAromatic, (Lst<SmilesRing>)lstSP2, eCounts, doTestAromatic);
            }
            if (!needRingData) continue;
            this.ringData[i] = new BS();
            int k = vR.size();
            while (--k >= 0) {
                BS r = (BS)vR.get(k);
                this.ringData[i].or(r);
                int j = r.nextSetBit(0);
                while (j >= 0) {
                    int n2 = j;
                    this.ringCounts[n2] = this.ringCounts[n2] + 1;
                    j = r.nextSetBit(j + 1);
                }
            }
        }
        if (this.needAromatic) {
            if (doFinalize) {
                SmilesAromatic.finalizeAromatic(this.targetAtoms, this.bsAromatic, (Lst<BS>)lstAromatic, (Lst<SmilesRing>)lstSP2, eCounts, isOpenNotStrict, isStrict);
            }
            this.bsAromatic5.clearAll();
            this.bsAromatic6.clearAll();
            i = lstAromatic.size();
            while (--i >= 0) {
                BS bs = (BS)lstAromatic.get(i);
                bs.and(this.bsAromatic);
                switch (bs.cardinality()) {
                    case 5: {
                        this.bsAromatic5.or(bs);
                        break;
                    }
                    case 6: {
                        this.bsAromatic6.or(bs);
                    }
                }
            }
        }
        if (needRingData) {
            i = this.bsSelected.nextSetBit(0);
            while (i >= 0) {
                Node atom = this.targetAtoms[i];
                Edge[] bonds = atom.getEdges();
                if (bonds != null) {
                    int k = bonds.length;
                    while (--k >= 0) {
                        if (this.ringCounts[atom.getBondedAtomIndex(k)] <= 0) continue;
                        int n3 = i;
                        this.ringConnections[n3] = this.ringConnections[n3] + 1;
                    }
                }
                i = this.bsSelected.nextSetBit(i + 1);
            }
        }
    }

    Object subsearch(SmilesSearch search, int submode) throws InvalidSmilesException {
        search.ringSets = this.ringSets;
        search.mapUnique = this.mapUnique;
        search.targetAtoms = this.targetAtoms;
        search.targetAtomCount = this.targetAtomCount;
        search.bsSelected = this.bsSelected;
        search.htNested = this.htNested;
        search.haveTopo = this.haveTopo;
        search.bsCheck = this.bsCheck;
        search.isSmarts = true;
        search.bsAromatic = this.bsAromatic;
        search.bsAromatic5 = this.bsAromatic5;
        search.bsAromatic6 = this.bsAromatic6;
        search.ringData = this.ringData;
        search.ringCounts = this.ringCounts;
        search.ringConnections = this.ringConnections;
        switch (submode) {
            case 1: {
                search.exitFirstMatch = false;
                break;
            }
            case 2: {
                search.isRingCheck = true;
                search.isSilent = true;
                search.asVector = true;
                break;
            }
            case 3: {
                search.ignoreAtomClass = this.ignoreAtomClass;
                search.aromaticDouble = this.aromaticDouble;
                search.haveSelected = this.haveSelected;
                search.exitFirstMatch = this.exitFirstMatch;
                search.getMaps = this.getMaps;
                search.asVector = this.asVector;
                search.vReturn = this.vReturn;
                search.bsReturn = this.bsReturn;
                search.haveBondStereochemistry = this.haveBondStereochemistry;
            }
        }
        return search.search2(submode == 1);
    }

    Object search() throws InvalidSmilesException {
        return this.search2(false);
    }

    private Object search2(boolean firstAtomOnly) throws InvalidSmilesException {
        this.setFlags(this.flags);
        if (!this.isRingCheck && Logger.debugging && !this.isSilent) {
            Logger.debug((String)("SmilesSearch processing " + this.pattern));
        }
        if (this.vReturn == null && (this.asVector || this.getMaps)) {
            this.vReturn = new Lst();
        }
        if (this.bsSelected == null) {
            this.bsSelected = BS.newN((int)this.targetAtomCount);
            this.bsSelected.setBits(0, this.targetAtomCount);
        }
        this.selectedAtomCount = this.bsSelected.cardinality();
        if (this.subSearches != null) {
            for (int i = 0; i < this.subSearches.length; ++i) {
                if (this.subSearches[i] == null) continue;
                this.subsearch(this.subSearches[i], 3);
                if (!this.exitFirstMatch || !(this.vReturn == null ? this.bsReturn.nextSetBit(0) >= 0 : this.vReturn.size() > 0)) {
                    continue;
                }
                break;
            }
        } else if (this.ac > 0) {
            if (this.nestedBond == null) {
                this.clearBsFound(-1);
            } else {
                this.bsReturn.clearAll();
            }
            this.nextPatternAtom(-1, -1, firstAtomOnly, -1);
        }
        return this.asVector || this.getMaps ? this.vReturn : this.bsReturn;
    }

    /*
     * Unable to fully structure code
     */
    private boolean nextPatternAtom(int atomNum, int iAtom, boolean firstAtomOnly, int c) throws InvalidSmilesException {
        if (++atomNum < this.ac) {
            newPatternAtom = this.patternAtoms[atomNum];
            v0 = iAtom >= 0 ? newPatternAtom.getBondTo(null) : (newPatternBond = atomNum == 0 ? this.nestedBond : null);
            if (newPatternBond == null) {
                bs = BSUtil.copy((BS)this.bsFound);
                bs0 = BSUtil.copy((BS)this.bsFound);
                if (newPatternAtom.notBondedIndex >= 0) {
                    pa = this.patternAtoms[newPatternAtom.notBondedIndex];
                    a = pa.getMatchingAtom();
                    if (pa.isBioAtom) {
                        ii = a.getOffsetResidueAtom("\u0000", 1);
                        if (ii >= 0) {
                            bs.set(ii);
                        }
                        if ((ii = a.getOffsetResidueAtom("\u0000", -1)) >= 0) {
                            bs.set(ii);
                        }
                    } else {
                        jmolBonds = a.getEdges();
                        for (k = 0; k < jmolBonds.length; ++k) {
                            bs.set(jmolBonds[k].getOtherNode((SimpleNode)a).getIndex());
                        }
                    }
                }
                skipGroup = newPatternAtom.isBioAtomWild;
                j1 = this.bsSelected.nextSetBit(0);
                j1 = skipGroup != false && j1 >= 0 ? this.targetAtoms[j1].getOffsetResidueAtom("\u0000", j1) : j1;
                oldPatternComponent = (atomNum > 0 ? this.patternAtoms[atomNum - 1] : newPatternAtom).component;
                thisPatternComponent = newPatternAtom.component;
                checkComponents = this.haveComponents != false && thisPatternComponent != -2147483648;
                j = j1;
                while (j >= 0) {
                    if (!bs.get(j) && !this.bsFound.get(j)) {
                        jmolAtom = this.targetAtoms[j];
                        if (!checkComponents || this.isRingCheck || oldPatternComponent == thisPatternComponent == ((oldJmolComponent = atomNum > 0 ? this.patternAtoms[atomNum - 1].matchingComponent : c) == (c = this.groupByModel != false ? jmolAtom.getModelIndex() : jmolAtom.getMoleculeNumber(false)))) {
                            if (!this.nextTargetAtom(newPatternAtom, jmolAtom, atomNum, j, firstAtomOnly, c)) {
                                return false;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else if (skipGroup && (j1 = this.targetAtoms[j].getOffsetResidueAtom(newPatternAtom.bioAtomName, 1)) >= 0) {
                        j = j1 - 1;
                    }
                    j = this.bsSelected.nextSetBit(j + 1);
                }
                this.bsFound = bs0;
                return true;
            }
            jmolAtom = newPatternBond.atom1.getMatchingAtom();
            switch (newPatternBond.order) {
                case 96: {
                    nextGroupAtom = jmolAtom.getOffsetResidueAtom(newPatternAtom.bioAtomName, 1);
                    if (nextGroupAtom >= 0) {
                        bs = BSUtil.copy((BS)this.bsFound);
                        jmolAtom.getGroupBits(this.bsFound);
                        if (this.doCheckAtom(nextGroupAtom) && !this.nextTargetAtom(newPatternAtom, this.targetAtoms[nextGroupAtom], atomNum, nextGroupAtom, firstAtomOnly, c)) {
                            return false;
                        }
                        this.bsFound = bs;
                    }
                    return true;
                }
                case 112: {
                    vLinks = new Lst();
                    jmolAtom.getCrossLinkVector(vLinks, true, true);
                    bs = BSUtil.copy((BS)this.bsFound);
                    jmolAtom.getGroupBits(this.bsFound);
                    for (j = 2; j < vLinks.size(); j += 3) {
                        ia = (Integer)vLinks.get(j);
                        if (!this.doCheckAtom(ia) || this.nextTargetAtom(newPatternAtom, this.targetAtoms[ia], atomNum, ia, firstAtomOnly, c)) continue;
                        return false;
                    }
                    this.bsFound = bs;
                    return true;
                }
            }
            jmolBonds = jmolAtom.getEdges();
            if (jmolBonds != null) {
                for (j = 0; j < jmolBonds.length; ++j) {
                    ia = jmolAtom.getBondedAtomIndex(j);
                    if (!this.doCheckAtom(ia) || this.nextTargetAtom(newPatternAtom, this.targetAtoms[ia], atomNum, ia, firstAtomOnly, c)) continue;
                    return false;
                }
            }
            this.clearBsFound(iAtom);
            return true;
        }
        if (!(this.ignoreStereochemistry || this.isRingCheck || this.checkStereochemistry())) {
            return true;
        }
        bs = new BS();
        nMatch = 0;
        for (j = 0; j < this.ac; ++j) {
            i = this.patternAtoms[j].getMatchingAtomIndex();
            if (!firstAtomOnly && this.top.haveSelected && !this.patternAtoms[j].selected) continue;
            ++nMatch;
            bs.set(i);
            if (this.patternAtoms[j].isBioAtomWild) {
                this.targetAtoms[i].getGroupBits(bs);
            }
            if (firstAtomOnly) break;
            if (this.isSmarts || this.setAtropicity || this.patternAtoms[j].explicitHydrogenCount <= 0) continue;
            atom = this.targetAtoms[i];
            n = atom.getEdges().length;
            for (k = 0; k < n; ++k) {
                ia = atom.getBondedAtomIndex(k);
                if (this.targetAtoms[ia].getElementNumber() != 1) continue;
                bs.set(ia);
            }
        }
        if (!this.isSmarts && bs.cardinality() != this.selectedAtomCount) {
            return true;
        }
        if (this.bsCheck != null) {
            if (firstAtomOnly) {
                this.bsCheck.clearAll();
                for (j = 0; j < this.ac; ++j) {
                    this.bsCheck.set(this.patternAtoms[j].getMatchingAtomIndex());
                }
                if (this.bsCheck.cardinality() != this.ac) {
                    return true;
                }
            } else if (bs.cardinality() != this.ac) {
                return true;
            }
        }
        this.bsReturn.or(bs);
        if (this.getMaps) {
            if (this.mapUnique) {
                if (this.uniqueList == null) {
                    this.uniqueList = new Lst();
                }
                j = this.uniqueList.size();
                while (--j >= 0) {
                    if (!((BS)this.uniqueList.get(j)).equals((Object)bs)) continue;
                    return true;
                }
                this.uniqueList.addLast((Object)bs);
            }
            map = new int[nMatch];
            nn = 0;
            for (j = 0; j < this.ac; ++j) {
                if (!firstAtomOnly && this.top.haveSelected && !this.patternAtoms[j].selected) continue;
                map[nn++] = this.patternAtoms[j].getMatchingAtomIndex();
            }
            this.vReturn.addLast((Object)map);
            return this.exitFirstMatch == false;
        }
        if (this.asVector) {
            isOK = true;
            j = this.vReturn.size();
            while (--j >= 0 && isOK) {
                isOK = ((BS)this.vReturn.get(j)).equals((Object)bs) == false;
            }
            if (!isOK) {
                return true;
            }
            this.vReturn.addLast((Object)bs);
        }
        if (this.isRingCheck) {
            bsRing = new BS();
            k = atomNum * 3 + 2;
            while (--k > atomNum) {
                bsRing.set(this.patternAtoms[(k <= atomNum * 2 ? atomNum * 2 - k + 1 : k - 1) % atomNum].getMatchingAtomIndex());
            }
            this.ringSets.addLast((Object)bsRing);
            return true;
        }
        if (this.exitFirstMatch) {
            return false;
        }
        return bs.cardinality() != this.selectedAtomCount;
    }

    private boolean doCheckAtom(int j) {
        return this.bsSelected.get(j) && !this.bsFound.get(j);
    }

    private final boolean nextTargetAtom(SmilesAtom patternAtom, Node jmolAtom, int atomNum, int iAtom, boolean firstAtomOnly, int c) throws InvalidSmilesException {
        int i;
        if (!this.isRingCheck && !this.isTopology) {
            if (patternAtom.subAtoms == null) {
                if (!this.checkPrimitiveAtom(patternAtom, iAtom)) {
                    return true;
                }
            } else if (patternAtom.isAND) {
                for (i = 0; i < patternAtom.nSubAtoms; ++i) {
                    if (this.checkPrimitiveAtom(patternAtom.subAtoms[i], iAtom)) continue;
                    return true;
                }
            } else {
                for (int i2 = 0; i2 < patternAtom.nSubAtoms; ++i2) {
                    if (this.nextTargetAtom(patternAtom.subAtoms[i2], jmolAtom, atomNum, iAtom, firstAtomOnly, c)) continue;
                    return false;
                }
                return true;
            }
        }
        Edge[] jmolBonds = jmolAtom.getEdges();
        i = patternAtom.getBondCount();
        block5: while (--i >= 0) {
            int k;
            SmilesBond patternBond = patternAtom.getBond(i);
            if (patternBond.getAtomIndex2() != patternAtom.index) continue;
            SmilesAtom atom1 = patternBond.atom1;
            int matchingAtom = atom1.getMatchingAtomIndex();
            switch (patternBond.order) {
                case 96: 
                case 112: {
                    if (this.checkMatchBond(patternAtom, atom1, patternBond, iAtom, matchingAtom, null)) continue block5;
                    return true;
                }
            }
            Edge jmolBond = null;
            for (k = 0; k < jmolBonds.length && (!(jmolBond = jmolBonds[k]).isCovalent() || jmolBond.getAtomIndex1() != matchingAtom && jmolBond.getAtomIndex2() != matchingAtom); ++k) {
            }
            if (k == jmolBonds.length) {
                return true;
            }
            if (this.checkMatchBond(patternAtom, atom1, patternBond, iAtom, matchingAtom, jmolBond)) continue;
            return true;
        }
        patternAtom = this.patternAtoms[patternAtom.index];
        patternAtom.setMatchingAtom(this.targetAtoms[iAtom], iAtom);
        patternAtom.matchingComponent = c;
        if (Logger.debuggingHigh && !this.isRingCheck) {
            for (i = 0; i <= atomNum; ++i) {
                Logger.debug((String)("pattern atoms " + (Object)((Object)this.patternAtoms[i]) + " " + this.patternAtoms[i].matchingComponent));
            }
            Logger.debug((String)"--ss--");
        }
        this.bsFound.set(iAtom);
        if (!this.nextPatternAtom(atomNum, iAtom, firstAtomOnly, c)) {
            return false;
        }
        if (iAtom >= 0) {
            this.clearBsFound(iAtom);
        }
        return true;
    }

    private boolean checkPrimitiveAtom(SmilesAtom patternAtom, int iTarget) throws InvalidSmilesException {
        boolean foundAtom;
        block18: {
            block21: {
                int n;
                block23: {
                    block24: {
                        Node targetAtom;
                        block22: {
                            int na;
                            block19: {
                                Node a;
                                block20: {
                                    block17: {
                                        if (patternAtom.nSubAtoms > 0) {
                                            for (int i = 0; i < patternAtom.nSubAtoms; ++i) {
                                                if (!this.checkPrimitiveAtom(patternAtom.subAtoms[i], iTarget)) continue;
                                                return true;
                                            }
                                            return false;
                                        }
                                        targetAtom = this.targetAtoms[iTarget];
                                        foundAtom = patternAtom.not;
                                        if (patternAtom.iNested <= 0) break block17;
                                        Object o = this.getNested(patternAtom.iNested);
                                        if (o instanceof SmilesSearch) {
                                            SmilesSearch search = (SmilesSearch)((Object)o);
                                            if (patternAtom.isBioAtom) {
                                                search.nestedBond = patternAtom.getBondTo(null);
                                            }
                                            if ((o = this.subsearch(search, 1)) == null) {
                                                o = new BS();
                                            }
                                            if (!patternAtom.isBioAtom) {
                                                this.setNested(patternAtom.iNested, o);
                                            }
                                        }
                                        foundAtom = patternAtom.not != ((BS)o).get(iTarget);
                                        break block18;
                                    }
                                    na = targetAtom.getElementNumber();
                                    n = patternAtom.elementNumber;
                                    if (na >= 0 && n >= 0 && n != na) break block18;
                                    if (!patternAtom.isBioResidue) break block19;
                                    a = targetAtom;
                                    if (patternAtom.bioAtomName != null && (!patternAtom.isLeadAtom() ? !patternAtom.bioAtomName.equals(a.getAtomName().toUpperCase()) : !a.isLeadAtom())) break block18;
                                    if (patternAtom.residueName != null && !patternAtom.residueName.equals(a.getGroup3(false).toUpperCase()) || patternAtom.residueNumber != Integer.MIN_VALUE && patternAtom.residueNumber != a.getResno() || patternAtom.insCode != '\u0000' && patternAtom.insCode != a.getInsertionCode()) break block18;
                                    if (patternAtom.residueChar == null && patternAtom.elementNumber != -2) break block20;
                                    char atype = a.getBioSmilesType();
                                    char ptype = patternAtom.getBioSmilesType();
                                    boolean ok = true;
                                    boolean isNucleic = false;
                                    switch (ptype) {
                                        case '\u0000': 
                                        case '*': {
                                            ok = true;
                                            break;
                                        }
                                        case 'n': {
                                            ok = atype == 'r' || atype == 'c';
                                            isNucleic = true;
                                            break;
                                        }
                                        case 'c': 
                                        case 'r': {
                                            isNucleic = true;
                                        }
                                        default: {
                                            boolean bl = ok = atype == ptype;
                                        }
                                    }
                                    if (!ok) break block18;
                                    String s = a.getGroup1('\u0000').toUpperCase();
                                    char resChar = patternAtom.residueChar == null ? (char)'*' : (char)patternAtom.residueChar.charAt(0);
                                    boolean isOK = resChar == s.charAt(0);
                                    switch (resChar) {
                                        case '*': {
                                            isOK = true;
                                            break;
                                        }
                                        case 'N': {
                                            isOK = isNucleic ? atype == 'r' || atype == 'c' : isOK;
                                            break;
                                        }
                                        case 'R': {
                                            isOK = isNucleic ? a.isPurine() : isOK;
                                            break;
                                        }
                                        case 'Y': {
                                            boolean bl = isOK = isNucleic ? a.isPyrimidine() : isOK;
                                        }
                                    }
                                    if (!isOK) break block18;
                                }
                                if (!patternAtom.isBioAtom || !patternAtom.notCrossLinked || !a.getCrossLinkVector(null, true, true)) break block21;
                                break block18;
                            }
                            if (patternAtom.atomNumber != Integer.MIN_VALUE && patternAtom.atomNumber != targetAtom.getAtomNumber() || patternAtom.jmolIndex >= 0 && targetAtom.getIndex() != patternAtom.jmolIndex || patternAtom.atomType != null && !patternAtom.atomType.equals(targetAtom.getAtomType()) || (n = patternAtom.getAtomicMass()) != Integer.MIN_VALUE && (n >= 0 && n != (na = targetAtom.getIsotopeNumber()) || n < 0 && na != 0 && -n != na) || !this.noAromatic && !patternAtom.aromaticAmbiguous && patternAtom.isAromatic != this.bsAromatic.get(iTarget) || (n = patternAtom.getCharge()) != Integer.MIN_VALUE && n != targetAtom.getFormalCharge() || (n = patternAtom.getCovalentHydrogenCount() + patternAtom.explicitHydrogenCount) >= 0 && n != targetAtom.getTotalHydrogenCount()) break block18;
                            n = patternAtom.implicitHydrogenCount;
                            if (n == Integer.MIN_VALUE) break block22;
                            na = targetAtom.getImplicitHydrogenCount();
                            if (n != -1 ? n != na : na == 0) break block18;
                        }
                        if (patternAtom.degree > 0 && patternAtom.degree != targetAtom.getCovalentBondCount() - targetAtom.getImplicitHydrogenCount() || patternAtom.nonhydrogenDegree > 0 && patternAtom.nonhydrogenDegree != targetAtom.getCovalentBondCount() - targetAtom.getCovalentHydrogenCount() || this.isSmarts && patternAtom.valence > 0 && patternAtom.valence != targetAtom.getTotalValence() || patternAtom.connectivity > 0 && patternAtom.connectivity != targetAtom.getCovalentBondCountPlusMissingH() || patternAtom.atomNumber != Integer.MIN_VALUE && patternAtom.atomNumber != targetAtom.getAtomNumber() || patternAtom.jmolIndex >= 0 && targetAtom.getIndex() != patternAtom.jmolIndex || patternAtom.atomType != null && !patternAtom.atomType.equals(targetAtom.getAtomType()) || (!this.ignoreAtomClass || this.isSmarts) && !Float.isNaN(patternAtom.atomClass) && patternAtom.atomClass != targetAtom.getFloatProperty("property_atomclass")) break block18;
                        if (this.ringData == null) break block21;
                        if (patternAtom.ringSize < -1) break block23;
                        if (patternAtom.ringSize > 0) break block24;
                        if (this.ringCounts[iTarget] == 0 == (patternAtom.ringSize == 0)) break block23;
                        break block18;
                    }
                    BS rd = this.ringData[patternAtom.ringSize == 500 ? 5 : (patternAtom.ringSize == 600 ? 6 : patternAtom.ringSize)];
                    if (rd == null || !rd.get(iTarget) || !this.noAromatic && (patternAtom.ringSize != 500 ? patternAtom.ringSize == 600 && !this.bsAromatic6.get(iTarget) : !this.bsAromatic5.get(iTarget))) break block18;
                }
                if (patternAtom.ringMembership >= -1 && (patternAtom.ringMembership != -1 ? this.ringCounts[iTarget] != patternAtom.ringMembership : this.ringCounts[iTarget] == 0)) break block18;
                if (patternAtom.ringConnectivity < 0) break block21;
                n = this.ringConnections[iTarget];
                if (patternAtom.ringConnectivity == -1 && n == 0 || patternAtom.ringConnectivity != -1 && n != patternAtom.ringConnectivity) break block18;
            }
            foundAtom = !foundAtom;
        }
        return foundAtom;
    }

    private boolean checkMatchBond(SmilesAtom patternAtom, SmilesAtom atom1, SmilesBond patternBond, int iAtom, int matchingAtom, Edge bond) {
        if (patternBond.bondsOr != null) {
            for (int ii = 0; ii < patternBond.nBondsOr; ++ii) {
                if (!this.checkMatchBond(patternAtom, atom1, patternBond.bondsOr[ii], iAtom, matchingAtom, bond)) continue;
                return true;
            }
            return false;
        }
        if (!this.isRingCheck && !this.isTopology) {
            if (patternBond.nPrimitives == 0) {
                if (!this.checkPrimitiveBond(patternBond, iAtom, matchingAtom, bond)) {
                    return false;
                }
            } else {
                for (int i = 0; i < patternBond.nPrimitives; ++i) {
                    SmilesBond prim = patternBond.setPrimitive(i);
                    if (this.checkPrimitiveBond(prim, iAtom, matchingAtom, bond)) continue;
                    return false;
                }
            }
        }
        patternBond.matchingBond = bond;
        return true;
    }

    private boolean checkPrimitiveBond(SmilesBond patternBond, int iAtom1, int iAtom2, Edge bond) {
        boolean bondFound = false;
        switch (patternBond.order) {
            case 96: {
                return patternBond.isNot != (this.targetAtoms[iAtom2].getOffsetResidueAtom("\u0000", 1) == this.targetAtoms[iAtom1].getOffsetResidueAtom("\u0000", 0));
            }
            case 112: {
                return patternBond.isNot != this.targetAtoms[iAtom1].isCrossLinked(this.targetAtoms[iAtom2]);
            }
        }
        boolean isAromatic1 = !this.noAromatic && this.bsAromatic.get(iAtom1);
        boolean isAromatic2 = !this.noAromatic && this.bsAromatic.get(iAtom2);
        int order = bond.getCovalentOrder();
        int patternOrder = patternBond.order;
        if (isAromatic1 && isAromatic2) {
            switch (patternOrder) {
                case 17: 
                case 65: {
                    bondFound = SmilesSearch.isRingBond(this.ringSets, null, iAtom1, iAtom2);
                    break;
                }
                case 1: {
                    bondFound = !this.isSmarts || !SmilesSearch.isRingBond(this.ringSets, this.getBSAromaticRings(), iAtom1, iAtom2);
                    break;
                }
                case 2: {
                    bondFound = this.isNormalized || this.aromaticDouble && (order == 2 || order == 514);
                    break;
                }
                case 65537: 
                case 65538: {
                    bondFound = !patternBond.isNot;
                    break;
                }
                case -1: 
                case 81: {
                    bondFound = true;
                }
            }
        } else {
            switch (patternOrder) {
                case 17: {
                    if (!this.noAromatic) break;
                }
                case -1: 
                case 81: {
                    bondFound = true;
                    break;
                }
                case 1: 
                case 1025: 
                case 1041: {
                    switch (order) {
                        case 1: 
                        case 1025: 
                        case 1041: {
                            bondFound = true;
                        }
                    }
                    break;
                }
                case 65537: 
                case 65538: {
                    switch (order) {
                        case 1: 
                        case 65537: 
                        case 65538: {
                            bondFound = !patternBond.isNot;
                        }
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    bondFound = order == patternOrder;
                    break;
                }
                case 65: {
                    bondFound = SmilesSearch.isRingBond(this.ringSets, null, iAtom1, iAtom2);
                }
            }
        }
        return bondFound != patternBond.isNot;
    }

    private BS getBSAromaticRings() {
        if (this.bsAromaticRings == null) {
            this.bsAromaticRings = new BS();
            if (this.ringSets != null && this.bsAromatic != null) {
                int i = this.ringSets.size();
                while (--i >= 0) {
                    BS bsRing = (BS)((BS)this.ringSets.get(i)).clone();
                    bsRing.andNot(this.bsAromatic);
                    if (!bsRing.isEmpty()) continue;
                    this.bsAromaticRings.set(i);
                }
            }
        }
        return this.bsAromaticRings;
    }

    static boolean isRingBond(Lst<BS> ringSets, BS bsAromaticRings, int a1, int a2) {
        if (ringSets != null) {
            int i = ringSets.size();
            while (--i >= 0) {
                BS bsRing = (BS)ringSets.get(i);
                if (!bsRing.get(a1) || !bsRing.get(a2) || bsAromaticRings != null && !bsAromaticRings.get(i)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkStereochemistry() {
        for (int i = 0; i < this.measures.size(); ++i) {
            if (((SmilesMeasure)this.measures.get(i)).check()) continue;
            return false;
        }
        if (this.stereo != null && !this.stereo.checkStereoChemistry(this, this.v)) {
            return false;
        }
        if (!this.haveBondStereochemistry) {
            return true;
        }
        Lst lstAtrop = null;
        SmilesBond b = null;
        for (int k = 0; k < this.ac; ++k) {
            SmilesAtom sAtom1 = this.patternAtoms[k];
            SmilesAtom sAtom2 = null;
            SmilesAtom sAtomDirected1 = null;
            SmilesAtom sAtomDirected2 = null;
            int dir1 = 0;
            int dir2 = 0;
            int bondType = 0;
            int nBonds = sAtom1.getBondCount();
            boolean isAtropisomer = false;
            boolean indexOrder = true;
            block10: for (int j = 0; j < nBonds; ++j) {
                b = sAtom1.getBond(j);
                boolean isAtom2 = b.atom2 == sAtom1;
                indexOrder = b.atom1.index < b.atom2.index;
                int type = b.order;
                switch (type) {
                    case 65537: 
                    case 65538: {
                        if (!indexOrder) continue block10;
                    }
                    case 2: {
                        if (isAtom2) continue block10;
                        sAtom2 = b.atom2;
                        bondType = type;
                        boolean bl = isAtropisomer = type != 2;
                        if (!isAtropisomer) continue block10;
                        dir1 = b.isNot ? -1 : 1;
                        continue block10;
                    }
                    case 1025: 
                    case 1041: {
                        sAtomDirected1 = isAtom2 ? b.atom1 : b.atom2;
                        dir1 = isAtom2 != (type == 1025) ? 1 : -1;
                    }
                }
            }
            if (isAtropisomer) {
                if (this.setAtropicity) {
                    if (lstAtrop == null) {
                        lstAtrop = new Lst();
                    }
                    lstAtrop.addLast((Object)b);
                    continue;
                }
                SmilesBond b1 = sAtom1.getBond(b.atropType[0]);
                if (b1 == null) {
                    return false;
                }
                sAtomDirected1 = b1.getOtherAtom(sAtom1);
                b1 = sAtom2.getBond(b.atropType[1]);
                if (b1 == null) {
                    return false;
                }
                sAtomDirected2 = b1.getOtherAtom(sAtom2);
                if (Logger.debugging) {
                    Logger.info((String)("atropisomer check for atoms " + (Object)((Object)sAtomDirected1) + (Object)((Object)sAtom1) + " " + (Object)((Object)sAtom2) + (Object)((Object)sAtomDirected2)));
                }
            } else {
                if (sAtom2 == null || dir1 == 0) continue;
                SmilesAtom a10 = sAtom1;
                int nCumulene = 0;
                while (sAtom2.getBondCount() == 2 && sAtom2.getValence() == 4) {
                    Edge[] e2;
                    ++nCumulene;
                    Edge e = e2[(e2 = sAtom2.getEdges())[0].getOtherNode((SimpleNode)sAtom2) == a10 ? 1 : 0];
                    a10 = sAtom2;
                    sAtom2 = (SmilesAtom)e.getOtherNode((SimpleNode)sAtom2);
                }
                if (nCumulene % 2 == 1) continue;
                nBonds = sAtom2.getBondCount();
                for (int j = 0; j < nBonds && dir2 == 0; ++j) {
                    b = sAtom2.getBond(j);
                    int type = b.order;
                    switch (type) {
                        case 1025: 
                        case 1041: {
                            boolean isAtom2 = b.atom2 == sAtom2;
                            sAtomDirected2 = isAtom2 ? b.atom1 : b.atom2;
                            dir2 = isAtom2 != (type == 1025) ? 1 : -1;
                        }
                    }
                }
                if (dir2 == 0) continue;
            }
            Node dbAtom1 = sAtom1.getMatchingAtom();
            Node dbAtom2 = sAtom2.getMatchingAtom();
            Node dbAtom1a = sAtomDirected1.getMatchingAtom();
            Node dbAtom2a = sAtomDirected2.getMatchingAtom();
            if (dbAtom1a == null || dbAtom2a == null) {
                return false;
            }
            if (this.haveTopo) {
                this.setTopoCoordinates((SmilesAtom)dbAtom1, (SmilesAtom)dbAtom2, (SmilesAtom)dbAtom1a, (SmilesAtom)dbAtom2a, bondType);
            }
            float d = SmilesMeasure.setTorsionData((T3)dbAtom1a, (T3)dbAtom1, (T3)dbAtom2, (T3)dbAtom2a, this.v, isAtropisomer);
            if (isAtropisomer) {
                d *= (float)(dir1 * (bondType == 65537 ? 1 : -1) * (indexOrder ? 1 : -1));
                if (Logger.debugging) {
                    Logger.info((String)("atrop dihedral " + d + " " + (Object)((Object)sAtom1) + " " + (Object)((Object)sAtom2) + " " + (Object)((Object)b)));
                }
                if (!(d < 1.0f)) continue;
                return false;
            }
            if (!(this.v.vTemp1.dot((T3)this.v.vTemp2) * (float)dir1 * (float)dir2 < 0.0f)) continue;
            return false;
        }
        if (this.setAtropicity) {
            this.atropKeys = "";
            for (int i = 0; i < lstAtrop.size(); ++i) {
                b = (SmilesBond)((Object)lstAtrop.get(i));
                this.atropKeys = this.atropKeys + "," + this.getAtropIndex(b, true) + this.getAtropIndex(b, false);
            }
        }
        return true;
    }

    private int getAtropIndex(SmilesBond b, boolean isFirst) {
        SmilesAtom s1 = isFirst ? b.atom1 : b.atom2;
        Node a1 = s1.getMatchingAtom();
        Node a11 = Edge.getAtropismNode((int)b.matchingBond.order, (Node)a1, (boolean)isFirst);
        SmilesBond[] b1 = s1.bonds;
        int i = s1.getBondCount();
        while (--i >= 0) {
            if (((SmilesAtom)b1[i].getOtherNode((SimpleNode)s1)).getMatchingAtom() != a11) continue;
            return i + 1;
        }
        return 0;
    }

    private void setTopoCoordinates(SmilesAtom dbAtom1, SmilesAtom dbAtom2, SmilesAtom dbAtom1a, SmilesAtom dbAtom2a, int bondType) {
        dbAtom1.set(-1.0f, 0.0f, 0.0f);
        dbAtom2.set(1.0f, 0.0f, 0.0f);
        if (bondType != 2) {
            SmilesBond bond = dbAtom1.getBondTo(dbAtom2);
            int dir = bond.order == 65537 ? 1 : -1;
            dbAtom1a.set(-1.0f, 1.0f, 0.0f);
            dbAtom2a.set(1.0f, 1.0f, (float)dir / 2.0f);
            return;
        }
        int nBonds = 0;
        int dir1 = 0;
        Edge[] bonds = dbAtom1.getEdges();
        int k = bonds.length;
        while (--k >= 0) {
            Edge bond = bonds[k];
            if (bond.order == 2) continue;
            SimpleNode atom = bond.getOtherNode((SimpleNode)dbAtom1);
            ((Node)atom).set(-1.0f, nBonds++ == 0 ? -1.0f : 1.0f, 0.0f);
            int mode = bond.getAtomIndex2() == dbAtom1.getIndex() ? nBonds : -nBonds;
            switch (bond.order) {
                case 1025: {
                    dir1 = mode;
                    break;
                }
                case 1041: {
                    dir1 = -mode;
                }
            }
        }
        int dir2 = 0;
        nBonds = 0;
        Node[] atoms = new Node[2];
        bonds = dbAtom2.getEdges();
        int k2 = bonds.length;
        while (--k2 >= 0) {
            Edge bond = bonds[k2];
            if (bond.order == 2) continue;
            SimpleNode atom = bond.getOtherNode((SimpleNode)dbAtom2);
            atoms[nBonds] = atom;
            ((Node)atom).set(1.0f, nBonds++ == 0 ? 1.0f : -1.0f, 0.0f);
            int mode = bond.getAtomIndex2() == dbAtom2.getIndex() ? nBonds : -nBonds;
            switch (bond.order) {
                case 1025: {
                    dir2 = mode;
                    break;
                }
                case 1041: {
                    dir2 = -mode;
                }
            }
        }
        if (dir1 * dir2 > 0 == (Math.abs(dir1) % 2 == Math.abs(dir2) % 2)) {
            float y = ((P3)atoms[0]).y;
            ((P3)atoms[0]).y = ((P3)atoms[1]).y;
            ((P3)atoms[1]).y = y;
        }
    }

    void createTopoMap(BS bsAro) throws InvalidSmilesException {
        boolean isForMF = bsAro == null;
        int nAtomsMissing = this.getMissingHydrogenCount();
        int totalAtoms = this.ac + nAtomsMissing;
        SmilesAtom[] atoms = new SmilesAtom[totalAtoms];
        this.targetAtoms = atoms;
        int i = 0;
        int ptAtom = 0;
        while (i < this.ac) {
            SmilesAtom sAtom = this.patternAtoms[i];
            int n = sAtom.explicitHydrogenCount;
            if (n < 0) {
                n = 0;
            }
            SmilesAtom atom = atoms[ptAtom] = new SmilesAtom().setTopoAtom(sAtom.component, ptAtom, sAtom.symbol, sAtom.getCharge(), i);
            atom.implicitHydrogenCount = n;
            if (!isForMF) {
                atom.mapIndex = i;
                atom.stereo = sAtom.stereo;
                atom.setAtomicMass(sAtom.getAtomicMass());
                atom.bioAtomName = sAtom.bioAtomName;
                atom.residueName = sAtom.residueName;
                atom.residueChar = sAtom.residueChar;
                atom.residueNumber = sAtom.residueNumber;
                atom.atomNumber = sAtom.residueNumber;
                atom.insCode = sAtom.insCode;
                atom.atomClass = sAtom.atomClass;
                atom.explicitHydrogenCount = 0;
                atom.isBioAtom = sAtom.isBioAtom;
                atom.bioType = sAtom.bioType;
                atom.isLeadAtom = sAtom.isLeadAtom;
                if (!isForMF && sAtom.isAromatic) {
                    bsAro.set(ptAtom);
                }
                sAtom.setMatchingAtom(null, ptAtom);
                SmilesBond[] bonds = new SmilesBond[sAtom.getBondCount() + n];
                atom.setBonds(bonds);
                while (--n >= 0) {
                    SmilesAtom atomH = atoms[ptAtom] = new SmilesAtom().setTopoAtom(atom.component, ++ptAtom, "H", 0, -1);
                    atomH.mapIndex = -i - 1;
                    atomH.setBonds(new SmilesBond[1]);
                    SmilesBond b = new SmilesBond(atom, atomH, 1, false);
                    if (!Logger.debugging) continue;
                    Logger.info((String)("" + (Object)((Object)b)));
                }
            }
            ++i;
            ++ptAtom;
        }
        if (isForMF) {
            return;
        }
        for (i = 0; i < this.ac; ++i) {
            SmilesAtom sAtom = this.patternAtoms[i];
            int i1 = sAtom.getMatchingAtomIndex();
            SmilesAtom atom1 = atoms[i1];
            int n = sAtom.getBondCount();
            for (int j = 0; j < n; ++j) {
                boolean firstAtom;
                SmilesBond sBond = sAtom.getBond(j);
                boolean bl = firstAtom = sBond.atom1 == sAtom;
                if (firstAtom) {
                    int order = 1;
                    switch (sBond.order) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 96: 
                        case 112: 
                        case 1025: 
                        case 1041: 
                        case 65537: 
                        case 65538: {
                            order = sBond.order;
                            break;
                        }
                        case 17: {
                            order = 514;
                        }
                    }
                    SmilesAtom atom2 = atoms[sBond.atom2.getMatchingAtomIndex()];
                    SmilesBond b = new SmilesBond(atom1, atom2, order, false);
                    b.isConnection = sBond.isConnection;
                    --atom2.bondCount;
                    if (!Logger.debugging) continue;
                    Logger.info((String)("" + (Object)((Object)b)));
                    continue;
                }
                SmilesAtom atom2 = atoms[sBond.atom1.getMatchingAtomIndex()];
                SmilesBond b = atom2.getBondTo(atom1);
                atom1.addBond(b);
            }
        }
        block8: for (i = 0; i < totalAtoms; ++i) {
            SmilesAtom a = atoms[i];
            SmilesBond[] bonds = a.bonds;
            if (bonds.length < 2 || bonds[0].isFromPreviousTo(a)) continue;
            int k = bonds.length;
            while (--k >= 1) {
                if (!bonds[k].isFromPreviousTo(a)) continue;
                SmilesBond b = bonds[k];
                bonds[k] = bonds[0];
                bonds[0] = b;
                continue block8;
            }
        }
        if (!this.ignoreStereochemistry) {
            i = this.ac;
            while (--i >= 0) {
                SmilesAtom sAtom = this.patternAtoms[i];
                if (sAtom.stereo == null) continue;
                sAtom.stereo.fixStereo(sAtom);
            }
        }
    }

    static void normalizeAromaticity(SmilesAtom[] atoms, BS bsAromatic, int flags) throws InvalidSmilesException {
        SmilesSearch ss = new SmilesSearch();
        ss.setFlags(flags);
        ss.targetAtoms = atoms;
        ss.targetAtomCount = atoms.length;
        ss.bsSelected = BSUtil.newBitSet2((int)0, (int)atoms.length);
        Lst[] vRings = AU.createArrayOfArrayList((int)4);
        ss.setRingData(null, vRings, true);
        bsAromatic.or(ss.bsAromatic);
        if (!bsAromatic.isEmpty()) {
            Lst lst = vRings[3];
            int i = lst.size();
            while (--i >= 0) {
                BS bs = (BS)lst.get(i);
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    SmilesAtom a = atoms[j];
                    if (!a.isAromatic && a.elementNumber != -2 && a.elementNumber != 0) {
                        a.setSymbol(a.symbol.toLowerCase());
                    }
                    j = bs.nextSetBit(j + 1);
                }
            }
        }
    }

    void getSelections() {
        Map<String, Object> ht = this.top.htNested;
        if (ht == null || this.targetAtoms.length == 0) {
            return;
        }
        Hashtable<String, BS> htNew = new Hashtable<String, BS>();
        for (Map.Entry<String, Object> entry : ht.entrySet()) {
            BS bs;
            String key = entry.getValue().toString();
            if (!key.startsWith("select")) continue;
            BS bS = bs = htNew.containsKey(key) ? (BS)htNew.get(key) : this.targetAtoms[0].findAtomsLike(key.substring(6));
            if (bs == null) {
                bs = new BS();
            }
            htNew.put(key, bs);
            entry.setValue(bs);
        }
    }

    Node findImplicitHydrogen(Node atom) {
        Edge[] edges = atom.getEdges();
        int i = edges.length;
        while (--i >= 0) {
            int k = atom.getBondedAtomIndex(i);
            if (this.targetAtoms[k].getElementNumber() != 1 || this.bsFound.get(k)) continue;
            return this.targetAtoms[k];
        }
        return null;
    }

    public String toString() {
        SB sb = new SB().append(this.pattern);
        sb.append("\nmolecular formula: " + this.getMolecularFormula(true, null, false));
        return sb.toString();
    }
}

