/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.util.Logger;

public class JaguarReader
extends MOReader {
    private int moCount = 0;
    private float lumoEnergy = Float.MAX_VALUE;
    private static final float ROOT3 = 1.7320508f;
    private boolean haveLine;

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Input geometry:") || this.line.startsWith(" Symmetrized geometry:") || this.line.startsWith("  final geometry:")) {
            this.readAtoms();
            return true;
        }
        if (this.line.startsWith("  Atomic charges from electrostatic potential:")) {
            this.readCharges();
            return true;
        }
        if (this.line.startsWith("  number of basis functions....")) {
            this.moCount = this.parseIntAt(this.line, 32);
            return true;
        }
        if (this.line.startsWith("  basis set:")) {
            this.moData.put("energyUnits", "");
            this.calculationType = this.line.substring(13).trim();
            this.moData.put("calculationType", this.calculationType);
            if ("sto-3g".equals(this.calculationType)) {
                Logger.error((String)"STO-3G not supported for Jaguar -- unusual SP basis definition.");
            }
            return true;
        }
        if (this.line.indexOf("XXXXXShell information") >= 0) {
            this.readUnnormalizedBasis();
            return true;
        }
        if (this.line.indexOf("Normalized coefficients") >= 0) {
            if (!"sto-3g".equals(this.calculationType)) {
                this.readBasisNormalized();
            }
            return true;
        }
        if (this.line.startsWith(" LUMO energy:")) {
            this.lumoEnergy = this.parseFloatStr(this.line.substring(13));
            return true;
        }
        if (this.line.indexOf("final wvfn") >= 0) {
            if (this.shells != null) {
                this.readJaguarMolecularOrbitals();
            }
            return true;
        }
        if (this.line.startsWith("  harmonic frequencies in")) {
            this.readFrequencies();
            this.continuing = false;
            return false;
        }
        return this.checkNboLine();
    }

    private void readAtoms() throws Exception {
        this.discardPreviousAtoms();
        this.readLines(2);
        while (this.rd() != null && this.line.length() >= 60 && this.line.charAt(2) != ' ') {
            String[] tokens = this.getTokens();
            String atomName = tokens[0];
            if (atomName.length() < 2) {
                return;
            }
            char ch2 = atomName.charAt(1);
            String elementSymbol = ch2 >= 'a' && ch2 <= 'z' ? atomName.substring(0, 2) : atomName.substring(0, 1);
            this.addAtomXYZSymName(tokens, 1, elementSymbol, atomName);
        }
    }

    private void readCharges() throws Exception {
        int iAtom = 0;
        while (this.rd() != null && this.line.indexOf("sum") < 0) {
            if (this.line.indexOf("Charge") < 0) continue;
            String[] tokens = this.getTokens();
            for (int i = 1; i < tokens.length; ++i) {
                this.asc.atoms[iAtom++].partialCharge = this.parseFloatStr(tokens[i]);
            }
        }
    }

    private void readUnnormalizedBasis() throws Exception {
        String[] tokens;
        String lastAtom = "";
        int iAtom = 0;
        int[][] sdata = new int[this.moCount][4];
        Lst[] sgdata = AU.createArrayOfArrayList((int)this.moCount);
        this.gaussianCount = 0;
        this.discardLinesUntilContains("--------");
        while (this.rd() != null && (tokens = this.getTokens()).length == 9) {
            int jCont = this.parseIntStr(tokens[2]);
            if (jCont <= 0) continue;
            if (!tokens[0].equals(lastAtom)) {
                ++iAtom;
            }
            lastAtom = tokens[0];
            int iFunc = this.parseIntStr(tokens[5]);
            int iType = this.parseIntStr(tokens[4]);
            if (iType <= 2) {
                --iType;
            }
            if (sgdata[iFunc] == null) {
                sdata[iFunc][0] = iAtom;
                sdata[iFunc][1] = iType;
                sdata[iFunc][2] = 0;
                sdata[iFunc][3] = 0;
                sgdata[iFunc] = new Lst();
            }
            float factor = 1.0f;
            sgdata[iFunc].addLast((Object)new float[]{this.parseFloatStr(tokens[6]), this.parseFloatStr(tokens[8]) * factor});
            this.gaussianCount += jCont;
            int i = jCont - 1;
            while (--i >= 0) {
                tokens = PT.getTokens((String)this.rd());
                sgdata[iFunc].addLast((Object)new float[]{this.parseFloatStr(tokens[6]), this.parseFloatStr(tokens[8]) * factor});
            }
        }
        float[][] garray = AU.newFloat2((int)this.gaussianCount);
        Lst sarray = new Lst();
        this.gaussianCount = 0;
        for (int i = 0; i < this.moCount; ++i) {
            if (sgdata[i] == null) continue;
            int n = sgdata[i].size();
            sdata[i][2] = this.gaussianCount;
            sdata[i][3] = n;
            for (int j = 0; j < n; ++j) {
                garray[this.gaussianCount++] = (float[])sgdata[i].get(j);
            }
            sarray.addLast((Object)sdata[i]);
        }
        this.moData.put("shells", sarray);
        this.moData.put("gaussians", garray);
        if (this.debugging) {
            Logger.debug((String)(sarray.size() + " slater shells read"));
            Logger.debug((String)(this.gaussianCount + " gaussian primitives read"));
        }
    }

    private void readBasisNormalized() throws Exception {
        String lastAtom = "";
        int iAtom = 0;
        int iFunc = 0;
        int iFuncLast = -1;
        Lst sarray = new Lst();
        Lst gdata = new Lst();
        this.gaussianCount = 0;
        int[] sdata = null;
        this.discardLinesUntilContains("--------");
        while (this.rd() != null && this.line.length() > 3) {
            String id;
            String[] tokens = this.getTokens();
            if (tokens.length == 4) {
                id = tokens[0];
                continue;
            }
            if (!tokens[0].equals(lastAtom)) {
                ++iAtom;
            }
            lastAtom = tokens[0];
            id = tokens[2];
            int iType = BasisFunctionReader.getQuantumShellTagID(id);
            iFunc = this.parseIntStr(tokens[3]) - 1;
            int gPtr = gdata.size();
            if (iFunc == iFuncLast) {
                sdata[3] = sdata[3] + true;
            } else if (iFunc < iFuncLast) {
                int i = gdata.size();
                while (--i >= 0) {
                    if (((float[])gdata.get(i))[2] != (float)iFunc) continue;
                    gPtr = i + 1;
                    break;
                }
                i = sarray.size();
                while (--i >= 0) {
                    if (((int[])sarray.get(i))[4] != iFunc) continue;
                    int[] nArray = (int[])sarray.get(i);
                    nArray[3] = nArray[3] + 1;
                    while (++i < sarray.size()) {
                        int[] nArray2 = (int[])sarray.get(i);
                        nArray2[2] = nArray2[2] + 1;
                    }
                    break;
                }
            } else {
                sdata = new int[]{iAtom, iType, this.gaussianCount + 1, 1, iFunc};
                sarray.addLast((Object)sdata);
                iFuncLast = iFunc;
            }
            ++this.gaussianCount;
            float z = this.parseFloatStr(tokens[4]);
            float rCoef = this.parseFloatStr(tokens[5]);
            if (id.equals("XX")) {
                rCoef *= 1.7320508f;
            }
            gdata.add(gPtr, (Object)new float[]{z, rCoef, iFunc});
        }
        float[][] garray = AU.newFloat2((int)this.gaussianCount);
        int i = gdata.size();
        while (--i >= 0) {
            garray[i] = (float[])gdata.get(i);
        }
        this.shells = sarray;
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", garray);
        if (this.debugging) {
            Logger.debug((String)(sarray.size() + " slater shells read"));
            Logger.debug((String)(this.gaussianCount + " gaussian primitives read"));
        }
        this.moData.put("isNormalized", Boolean.TRUE);
    }

    private void readJaguarMolecularOrbitals() throws Exception {
        String[][] dataBlock = new String[this.moCount][];
        this.rd();
        this.rd();
        this.rd();
        int nMo = 0;
        while (this.line != null) {
            this.rd();
            this.rd();
            this.rd();
            if (this.line == null || this.line.indexOf("eigenvalues-") < 0) break;
            String[] eigenValues = this.getTokens();
            int n = eigenValues.length - 1;
            this.fillDataBlock(dataBlock, 0);
            float occ = 2.0f;
            for (int iOrb = 0; iOrb < n; ++iOrb) {
                float[] coefs = new float[this.moCount];
                Hashtable<String, Object> mo = new Hashtable<String, Object>();
                float energy = this.parseFloatStr(eigenValues[iOrb + 1]);
                mo.put("energy", Float.valueOf(energy));
                if ((double)Math.abs(energy - this.lumoEnergy) < 1.0E-4) {
                    this.moData.put("HOMO", nMo);
                    this.lumoEnergy = Float.MAX_VALUE;
                    occ = 0.0f;
                }
                mo.put("occupancy", Float.valueOf(occ));
                ++nMo;
                int pt = 0;
                for (int i = 0; i < this.moCount; ++i) {
                    coefs[pt++] = this.parseFloatStr(dataBlock[i][iOrb + 3]);
                }
                mo.put("coefficients", coefs);
                this.setMO(mo);
            }
        }
        this.moData.put("mos", this.orbitals);
        this.finalizeMOData(this.moData);
    }

    private void readFrequencies() throws Exception {
        int ac = this.asc.getLastAtomSetAtomCount();
        this.discardLinesUntilStartsWith("  frequencies ");
        while (this.line != null && this.line.startsWith("  frequencies ")) {
            int iAtom0 = this.asc.ac;
            String[] frequencies = this.getTokens();
            int frequencyCount = frequencies.length - 1;
            boolean[] ignore = new boolean[frequencyCount];
            String[] symmetries = null;
            String[] intensities = null;
            while (this.line != null && this.line.charAt(2) != ' ') {
                if (this.line.indexOf("symmetries") >= 0) {
                    symmetries = this.getTokens();
                } else if (this.line.indexOf("intensities") >= 0) {
                    intensities = this.getTokens();
                }
                this.rd();
            }
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                this.asc.cloneFirstAtomSet(0);
                this.asc.setAtomSetFrequency(this.vibrationNumber, null, symmetries == null ? null : symmetries[i + 1], frequencies[i + 1], null);
                if (intensities == null) continue;
                this.asc.setAtomSetModelProperty("IRIntensity", intensities[i + 1] + " km/mol");
            }
            this.haveLine = true;
            this.fillFrequencyData(iAtom0, ac, ac, ignore, false, 0, 0, null, 0, null);
            this.rd();
            this.rd();
        }
    }

    public String rd() throws Exception {
        if (!this.haveLine) {
            return super.rd();
        }
        this.haveLine = false;
        return this.line;
    }
}

