/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.jvxl.readers.PeriodicVolumeFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class CastepDensityReader
extends PeriodicVolumeFileReader {
    private int nFilePoints;
    private int nSkip;

    CastepDensityReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
        this.isProgressive = false;
        this.isAngstroms = true;
    }

    @Override
    protected void gotoData(int n, int nPoints) throws Exception {
        this.nSkip = n;
    }

    @Override
    protected void readParameters() throws Exception {
        int i;
        this.jvxlFileHeaderBuffer = new SB();
        while (this.rd() != null && this.line.indexOf(".") < 0) {
        }
        for (i = 0; i < 3; ++i) {
            V3 voxelVector = this.volumetricVectors[i];
            voxelVector.set(this.parseFloatStr(this.line), this.parseFloat(), this.parseFloat());
            this.rd();
        }
        this.nSurfaces = this.parseIntStr(this.rd());
        this.rd();
        this.nPointsX = this.parseIntStr(this.line);
        this.voxelCounts[0] = this.nPointsX + 1;
        this.nPointsY = this.parseInt();
        this.voxelCounts[1] = this.nPointsY + 1;
        this.nPointsZ = this.parseInt();
        this.voxelCounts[2] = this.nPointsZ + 1;
        this.nFilePoints = this.nPointsX++ * this.nPointsY++ * this.nPointsZ++;
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
        for (i = 0; i < 3; ++i) {
            this.volumetricVectors[i].scale(1.0f / (float)(this.voxelCounts[i] - 1));
            if (!this.isAnisotropic) continue;
            this.setVectorAnisotropy((T3)this.volumetricVectors[i]);
        }
        while (this.rd().trim().length() > 0) {
        }
    }

    @Override
    protected void getPeriodicVoxels() throws Exception {
        int dsf;
        int i;
        this.rd();
        String[] tokens = this.getTokens();
        if (this.nSkip > 0 && tokens.length < 3 + this.nSurfaces) {
            for (int j = 0; j < this.nSkip; ++j) {
                for (i = 0; i < this.nFilePoints; ++i) {
                    this.rd();
                }
            }
            this.nSkip = 0;
        }
        if ((dsf = this.downsampleFactor) > 1) {
            for (i = 0; i < this.nFilePoints; ++i) {
                int x = this.parseIntStr(this.line) - 1;
                int y = this.parseInt() - 1;
                int z = this.parseInt() - 1;
                if (x % dsf == 0 && y % dsf == 0 && z % dsf == 0) {
                    if (this.nSkip > 0) {
                        this.skipPoints(this.nSkip);
                    }
                    this.voxelData[x / dsf][y / dsf][z / dsf] = this.recordData(this.parseFloat());
                }
                this.rd();
            }
        } else {
            for (i = 0; i < this.nFilePoints; ++i) {
                int x = this.parseIntStr(this.line) - 1;
                int y = this.parseInt() - 1;
                int z = this.parseInt() - 1;
                if (this.nSkip > 0) {
                    this.skipPoints(this.nSkip);
                }
                this.voxelData[x][y][z] = this.recordData(this.parseFloat());
                this.rd();
            }
        }
    }

    private void skipPoints(int n) {
        int pt = this.next[0];
        for (int i = 0; i < n; ++i) {
            while (pt < this.line.length() && PT.isWhitespace((char)this.line.charAt(pt++))) {
            }
            while (pt < this.line.length() && !PT.isWhitespace((char)this.line.charAt(pt++))) {
            }
        }
        this.next[0] = pt;
    }
}

