/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.adapter.readers.pymol.JmolObject;
import org.jmol.adapter.readers.pymol.PyMOL;
import org.jmol.adapter.readers.pymol.PyMOLGroup;
import org.jmol.adapter.readers.pymol.PyMOLReader;
import org.jmol.api.JmolSceneGenerator;
import org.jmol.api.PymolAtomReader;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.Text;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

class PyMOLScene
implements JmolSceneGenerator {
    private Viewer vwr;
    private int pymolVersion;
    BS bsHidden = new BS();
    BS bsNucleic = new BS();
    BS bsNonbonded = new BS();
    BS bsLabeled = new BS();
    BS bsHydrogen = new BS();
    BS bsNoSurface = new BS();
    private Map<Float, BS> htSpacefill = new Hashtable<Float, BS>();
    private Map<String, BS> ssMapAtom = new Hashtable<String, BS>();
    private Lst<Integer> atomColorList = new Lst();
    private Map<String, Boolean> occludedObjects = new Hashtable<String, Boolean>();
    private Map<Integer, Text> labels = new Hashtable<Integer, Text>();
    private short[] colixes;
    private JmolObject frameObj;
    private Map<String, PyMOLGroup> groups;
    private Map<Integer, Lst<Object>> objectSettings;
    private BS bsCartoon = new BS();
    private Map<String, BS> htCarveSets = new Hashtable<String, BS>();
    private Map<String, BS> htDefinedAtoms = new Hashtable<String, BS>();
    private Map<String, Boolean> htHiddenObjects = new Hashtable<String, Boolean>();
    private Lst<String> moleculeNames = new Lst();
    private Lst<JmolObject> jmolObjects = new Lst();
    private Map<String, int[]> htAtomMap = new Hashtable<String, int[]>();
    private Map<String, BS> htObjectAtoms = new Hashtable<String, BS>();
    private Map<String, String> htObjectGroups = new Hashtable<String, String>();
    private Map<String, MeasurementData[]> htMeasures = new Hashtable<String, MeasurementData[]>();
    private Map<String, Map<Integer, Lst<Object>>> htObjectSettings = new Hashtable<String, Map<Integer, Lst<Object>>>();
    private Map<String, Object[]> objectInfo = new Hashtable<String, Object[]>();
    private Lst<Object> settings;
    private Map<String, Map<Integer, Lst<Object>>> htStateSettings = new Hashtable<String, Map<Integer, Lst<Object>>>();
    private Map<Integer, Lst<Object>> stateSettings;
    private Map<Integer, Lst<Object>> uniqueSettings;
    private Map<Integer, Integer> uniqueList;
    private BS bsUniqueBonds;
    private int bgRgb;
    private int dotColor;
    private int surfaceMode;
    private int surfaceColor;
    private int cartoonColor;
    private int ribbonColor;
    private int sphereColor;
    private int labelFontId;
    private int labelColor;
    private float cartoonTranslucency;
    private float ribbonTranslucency;
    private float labelSize;
    private float meshWidth;
    private float nonbondedSize;
    private float nonbondedTranslucency;
    private float sphereScale;
    private float sphereTranslucency;
    private float stickTranslucency;
    private float transparency;
    private boolean cartoonLadderMode;
    private boolean cartoonRockets;
    private boolean haveNucleicLadder;
    private P3 labelPosition;
    private P3 labelPosition0 = new P3();
    private String objectName;
    private String objectNameID;
    private String objectJmolName;
    private int objectType;
    private BS bsAtoms;
    private boolean objectHidden;
    private PymolAtomReader reader;
    private int[] uniqueIDs;
    private int[] cartoonTypes;
    private int[] sequenceNumbers;
    private boolean[] newChain;
    private float[] radii;
    private int baseModelIndex;
    private int baseAtomIndex;
    private int stateCount;
    String mepList = "";
    boolean doCache;
    private boolean haveScenes;
    private BS bsCarve;
    private boolean solventAccessible;
    private BS bsLineBonds = new BS();
    private BS bsStickBonds = new BS();
    private int thisState;
    int currentAtomSetIndex;
    String surfaceInfoName;
    private final P3 ptTemp = new P3();
    private static final int[] MEAS_DIGITS = new int[]{530, 531, 532};

    private void clearReaderData() {
        this.reader = null;
        this.colixes = null;
        this.atomColorList = null;
        this.objectSettings = null;
        this.stateSettings = null;
        if (this.haveScenes) {
            return;
        }
        this.settings = null;
        this.groups = null;
        this.labels = null;
        this.ssMapAtom = null;
        this.htSpacefill = null;
        this.htAtomMap = null;
        this.htMeasures = null;
        this.htObjectGroups = null;
        this.htObjectAtoms = null;
        this.htObjectSettings = null;
        this.htStateSettings = null;
        this.htHiddenObjects = null;
        this.objectInfo = null;
        this.occludedObjects = null;
        this.bsCartoon = null;
        this.bsNoSurface = null;
        this.bsHydrogen = null;
        this.bsLabeled = null;
        this.bsNonbonded = null;
        this.bsNucleic = null;
        this.bsHidden = null;
    }

    void setUniqueBond(int index, int uniqueID) {
        if (uniqueID < 0) {
            return;
        }
        if (this.uniqueList == null) {
            this.uniqueList = new Hashtable<Integer, Integer>();
            this.bsUniqueBonds = new BS();
        }
        this.uniqueList.put(index, uniqueID);
        this.bsUniqueBonds.set(index);
    }

    void setStateCount(int stateCount) {
        this.stateCount = stateCount;
    }

    PyMOLScene(PymolAtomReader reader, Viewer vwr, Lst<Object> settings, Map<Integer, Lst<Object>> uniqueSettings, int pymolVersion, boolean haveScenes, int baseAtomIndex, int baseModelIndex, boolean doCache, String filePath) {
        this.reader = reader;
        this.vwr = vwr;
        this.settings = settings;
        this.uniqueSettings = uniqueSettings;
        this.pymolVersion = pymolVersion;
        this.haveScenes = haveScenes;
        this.baseAtomIndex = baseAtomIndex;
        this.baseModelIndex = baseModelIndex;
        this.doCache = doCache;
        this.surfaceInfoName = filePath + "##JmolSurfaceInfo##";
        this.setVersionSettings();
        settings.trimToSize();
        this.bgRgb = this.colorSetting(6);
        this.labelPosition0 = this.pointSetting(471);
    }

    private int colorSetting(int i) {
        Object o;
        Lst<Object> pos = PyMOLReader.listAt(this.settings, i);
        Object object = o = pos == null || pos.size() != 3 ? null : pos.get(2);
        if (o == null) {
            return (int)PyMOL.getDefaultSetting(i, this.pymolVersion);
        }
        return o instanceof Integer ? (Integer)o : CU.colorPtToFFRGB((T3)PyMOLReader.pointAt((Lst<Object>)((Lst)o), 0, this.ptTemp));
    }

    private P3 pointSetting(int i) {
        P3 pt = new P3();
        Lst<Object> pos = PyMOLReader.listAt(this.settings, i);
        if (pos != null && pos.size() == 3) {
            return PyMOLReader.pointAt((Lst<Object>)((Lst)pos.get(2)), 0, pt);
        }
        return PyMOL.getDefaultSettingPt(i, this.pymolVersion, pt);
    }

    void ensureCapacity(int n) {
        this.atomColorList.ensureCapacity(this.atomColorList.size() + n);
    }

    void setReaderObjectInfo(String name, int type, String groupName, boolean isHidden, Lst<Object> listObjSettings, Lst<Object> listStateSettings, String ext) {
        this.objectName = name;
        this.objectHidden = isHidden;
        this.objectNameID = this.objectName == null ? null : this.fixName(this.objectName + ext);
        this.objectSettings = new Hashtable<Integer, Lst<Object>>();
        this.stateSettings = new Hashtable<Integer, Lst<Object>>();
        if (this.objectName != null) {
            this.objectJmolName = this.getJmolName(name);
            if (groupName != null) {
                this.htObjectGroups.put(this.objectName, groupName);
                this.htObjectGroups.put(this.objectNameID, groupName);
            }
            this.objectInfo.put(this.objectName, new Object[]{this.objectNameID, type});
            if (this.htObjectSettings.get(this.objectName) == null) {
                this.listToSettings(listObjSettings, this.objectSettings);
                this.htObjectSettings.put(this.objectName, this.objectSettings);
            }
            if (this.htStateSettings.get(this.objectNameID) == null) {
                this.listToSettings(listStateSettings, this.stateSettings);
                this.htStateSettings.put(this.objectNameID, this.stateSettings);
            }
        }
        this.getObjectSettings();
    }

    private void listToSettings(Lst<Object> list, Map<Integer, Lst<Object>> objectSettings) {
        if (list != null && list.size() != 0) {
            int i = list.size();
            while (--i >= 0) {
                Lst setting = (Lst)list.get(i);
                objectSettings.put((Integer)setting.get(0), (Lst<Object>)setting);
            }
        }
    }

    private void getObjectSettings() {
        this.transparency = this.floatSetting(138);
        this.dotColor = (int)this.floatSetting(210);
        this.nonbondedSize = this.floatSetting(65);
        this.nonbondedTranslucency = this.floatSetting(524);
        this.sphereScale = this.floatSetting(155);
        this.cartoonColor = (int)this.floatSetting(236);
        this.ribbonColor = (int)this.floatSetting(235);
        this.sphereColor = (int)this.floatSetting(173);
        this.cartoonTranslucency = this.floatSetting(279);
        this.ribbonTranslucency = this.floatSetting(666);
        this.stickTranslucency = this.floatSetting(198);
        this.sphereTranslucency = this.floatSetting(172);
        this.cartoonLadderMode = this.booleanSetting(448);
        this.cartoonRockets = this.booleanSetting(180);
        this.surfaceMode = (int)this.floatSetting(143);
        this.surfaceColor = (int)this.floatSetting(144);
        this.solventAccessible = this.booleanSetting(338);
        this.meshWidth = this.floatSetting(90);
        String carveSet = this.stringSetting(342).trim();
        if (carveSet.length() == 0) {
            this.bsCarve = null;
        } else {
            this.bsCarve = this.htCarveSets.get(carveSet);
            if (this.bsCarve == null) {
                this.bsCarve = new BS();
                this.htCarveSets.put(carveSet, this.bsCarve);
            }
        }
        this.labelPosition = new P3();
        try {
            Lst<Object> setting = this.getObjectSetting(471);
            PyMOLReader.pointAt(PyMOLReader.listAt(setting, 2), 0, this.labelPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.labelPosition.add((T3)this.labelPosition0);
        this.labelColor = (int)this.floatSetting(66);
        this.labelSize = this.floatSetting(453);
        this.labelFontId = (int)this.floatSetting(328);
    }

    void setAtomInfo(int[] uniqueIDs, int[] cartoonTypes, int[] sequenceNumbers, boolean[] newChain, float[] radii) {
        this.uniqueIDs = uniqueIDs;
        this.cartoonTypes = cartoonTypes;
        this.sequenceNumbers = sequenceNumbers;
        this.newChain = newChain;
        this.radii = radii;
    }

    private void setSceneObject(String name, int istate) {
        this.objectName = name;
        this.objectType = this.getObjectType(name);
        this.objectJmolName = this.getJmolName(name);
        this.objectNameID = istate == 0 && this.objectType != 0 ? this.getObjectID(name) : this.objectJmolName + "_" + istate;
        this.bsAtoms = this.htObjectAtoms.get(name);
        this.objectSettings = this.htObjectSettings.get(name);
        this.stateSettings = this.htStateSettings.get(name + "_" + istate);
        String groupName = this.htObjectGroups.get(name);
        this.objectHidden = this.htHiddenObjects.containsKey(name) || groupName != null && !this.groups.get((Object)groupName).visible;
        this.getObjectSettings();
    }

    void buildScene(String name, Lst<Object> thisScene, Map<String, Lst<Object>> htObjNames, Map<String, Lst<Object>> htSecrets) {
        Object frame = thisScene.get(2);
        Hashtable<String, Object> smap = new Hashtable<String, Object>();
        smap.put("pymolFrame", frame);
        smap.put("generator", this);
        smap.put("name", name);
        Lst<Object> view = PyMOLReader.listAt(thisScene, 0);
        if (view != null) {
            smap.put("pymolView", this.getPymolView(view, false));
        }
        Map visibilities = (Map)thisScene.get(1);
        smap.put("visibilities", visibilities);
        String sname = "_scene_" + name + "_";
        Object[] reps = new Object[PyMOL.REP_LIST.length];
        int j = PyMOL.REP_LIST.length;
        while (--j >= 0) {
            Lst<Object> list = htObjNames.get(sname + PyMOL.REP_LIST[j]);
            Lst<Object> data = PyMOLReader.listAt(list, 5);
            if (data == null || data.size() <= 0) continue;
            reps[j] = PyMOLReader.listToMap(data);
        }
        smap.put("moleculeReps", reps);
        sname = "_!c_" + name + "_";
        Lst<Object> colorection = PyMOLReader.listAt(thisScene, 3);
        int n = colorection.size();
        n -= n % 2;
        Object[] colors = new Object[n / 2];
        int i = 0;
        for (int j2 = 0; j2 < n; j2 += 2) {
            int color = PyMOLReader.intAt(colorection, j2);
            Lst<Object> c = htSecrets.get(sname + color);
            if (c == null || c.size() <= 1) continue;
            colors[i++] = new Object[]{color, c.get(1)};
        }
        smap.put("colors", colors);
        this.addJmolObject((int)1073742139, null, smap).jmolName = name;
    }

    public void generateScene(Map<String, Object> scene) {
        block2: {
            Logger.info((String)("PyMOLScene - generateScene " + scene.get("name")));
            this.jmolObjects.clear();
            this.bsHidden.clearAll();
            this.occludedObjects.clear();
            this.htHiddenObjects.clear();
            Integer frame = (Integer)scene.get("pymolFrame");
            this.thisState = frame;
            this.addJmolObject(4115, null, this.thisState - 1);
            try {
                this.generateVisibilities((Map)scene.get("visibilities"));
                this.generateColors((Object[])scene.get("colors"));
                this.generateShapes((Object[])scene.get("moleculeReps"));
                this.finalizeVisibility();
                this.offsetObjects();
                this.finalizeObjects();
            }
            catch (Exception e) {
                Logger.info((String)("PyMOLScene exception " + e));
                if (Viewer.isJS) break block2;
                e.printStackTrace();
            }
        }
    }

    private void generateColors(Object[] colors) {
        if (colors == null) {
            return;
        }
        int i = colors.length;
        while (--i >= 0) {
            Object[] item = (Object[])colors[i];
            int color = (Integer)item[0];
            int icolor = PyMOL.getRGB(color);
            Lst molecules = (Lst)item[1];
            BS bs = this.getSelectionAtoms((Lst<Object>)molecules, this.thisState, new BS());
            this.addJmolObject((int)0x44000001, (BS)bs, null).argb = icolor;
        }
    }

    void processSelection(Lst<Object> selection) {
        String id = selection.get(0).toString();
        id = "_" + (id.equals("sele") ? id : "sele_" + id);
        PyMOLGroup g = this.getGroup(id);
        this.getSelectionAtoms(PyMOLReader.listAt(selection, 5), 0, g.bsAtoms);
    }

    private BS getSelectionAtoms(Lst<Object> molecules, int istate, BS bs) {
        if (molecules != null) {
            int j = molecules.size();
            while (--j >= 0) {
                this.selectAllAtoms(PyMOLReader.listAt(molecules, j), istate, bs);
            }
        }
        return bs;
    }

    private void selectAllAtoms(Lst<Object> obj, int istate, BS bs) {
        String name = PyMOLReader.stringAt(obj, 0);
        this.setSceneObject(name, istate);
        Lst<Object> atomList = PyMOLReader.listAt(obj, 1);
        int k0 = istate == 0 ? 1 : istate;
        int k1 = istate == 0 ? this.stateCount : istate;
        for (int k = k0; k <= k1; ++k) {
            int[] atomMap = this.htAtomMap.get(this.fixName(name + "_" + k));
            if (atomMap == null) continue;
            this.getBsAtoms(atomList, atomMap, bs);
        }
    }

    private void generateVisibilities(Map<String, Object> vis) {
        int tok;
        Lst list;
        String name;
        if (vis == null) {
            return;
        }
        BS bs = new BS();
        this.addJmolObject(12294, null, null);
        for (Map.Entry<String, PyMOLGroup> entry : this.groups.entrySet()) {
            entry.getValue().visible = true;
        }
        for (Map.Entry<String, Object> entry : vis.entrySet()) {
            name = entry.getKey();
            if (name.equals("all")) continue;
            list = (Lst)entry.getValue();
            int n = tok = PyMOLReader.intAt((Lst<Object>)list, 0) == 1 ? 1610625028 : 12294;
            if (tok == 12294) {
                this.htHiddenObjects.put(name, Boolean.TRUE);
            }
            switch (this.getObjectType(name)) {
                case 12: {
                    PyMOLGroup g = this.groups.get(name);
                    if (g == null) break;
                    g.visible = tok == 1610625028;
                }
            }
        }
        this.setGroupVisibilities();
        block10: for (Map.Entry<String, Object> entry : vis.entrySet()) {
            name = entry.getKey();
            if (name.equals("all")) continue;
            this.setSceneObject(name, this.thisState);
            if (this.objectHidden) continue;
            list = (Lst)entry.getValue();
            tok = this.objectHidden ? 12294 : 1610625028;
            bs = null;
            String info = this.objectJmolName;
            switch (this.objectType) {
                case 0: 
                case 12: {
                    continue block10;
                }
                case 1: {
                    bs = this.vwr.getDefinedAtomSet(info);
                    if (bs.nextSetBit(0) >= 0) break;
                    continue block10;
                }
                case 4: {
                    MeasurementData[] mdList;
                    if (tok == 1610625028 && (mdList = this.htMeasures.get(name)) != null) {
                        this.addMeasurements(mdList, mdList[0].points.size(), null, this.getBS(PyMOLReader.listAt((Lst<Object>)list, 2)), PyMOLReader.intAt((Lst<Object>)list, 3), null, true);
                    }
                    info = info + "_*";
                    break;
                }
            }
            this.addJmolObject(tok, bs, info);
        }
    }

    private void generateShapes(Object[] reps) {
        if (reps == null) {
            return;
        }
        this.addJmolObject((int)12295, null, null).argb = this.thisState - 1;
        for (int m = 0; m < this.moleculeNames.size(); ++m) {
            int i;
            this.setSceneObject((String)this.moleculeNames.get(m), this.thisState);
            if (this.objectHidden) continue;
            BS[] molReps = new BS[23];
            for (i = 0; i < 23; ++i) {
                molReps[i] = new BS();
            }
            i = reps.length;
            while (--i >= 0) {
                Map repMap = (Map)reps[i];
                Lst list = repMap == null ? null : (Lst)repMap.get(this.objectName);
                if (list == null) continue;
                this.selectAllAtoms((Lst<Object>)list, this.thisState, molReps[i]);
            }
            this.createShapeObjects(molReps, true, -1, -1);
        }
    }

    private BS getBS(Lst<Object> list) {
        BS bs = new BS();
        int i = list.size();
        while (--i >= 0) {
            bs.set(PyMOLReader.intAt(list, i));
        }
        return bs;
    }

    private void getBsAtoms(Lst<Object> list, int[] atomMap, BS bs) {
        int i = list.size();
        while (--i >= 0) {
            bs.set(atomMap[PyMOLReader.intAt(list, i)]);
        }
    }

    void setReaderObjects() {
        this.clearReaderData();
        this.finalizeObjects();
        if (!this.haveScenes) {
            this.uniqueSettings = null;
            this.bsLineBonds = null;
            this.bsStickBonds = null;
            this.bsUniqueBonds = null;
        }
    }

    private void finalizeObjects() {
        this.vwr.setStringProperty("defaults", "PyMOL");
        for (int i = 0; i < this.jmolObjects.size(); ++i) {
            try {
                JmolObject obj = (JmolObject)this.jmolObjects.get(i);
                obj.finalizeObject(this, this.vwr.ms, this.mepList, this.doCache);
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
                if (Viewer.isJS) continue;
                e.printStackTrace();
            }
        }
        this.finalizeUniqueBonds();
        this.jmolObjects.clear();
    }

    void offsetObjects() {
        int n = this.jmolObjects.size();
        for (int i = 0; i < n; ++i) {
            ((JmolObject)this.jmolObjects.get(i)).offset(this.baseModelIndex, this.baseAtomIndex);
        }
    }

    private JmolObject getJmolObject(int id, BS bsAtoms, Object info) {
        if (this.baseAtomIndex > 0) {
            bsAtoms = BSUtil.copy((BS)bsAtoms);
        }
        return new JmolObject(id, this.objectNameID, bsAtoms, info);
    }

    private JmolObject addJmolObject(int id, BS bsAtoms, Object info) {
        return this.addObject(this.getJmolObject(id, bsAtoms, info));
    }

    private float[] getPymolView(Lst<Object> view, boolean isViewObj) {
        int j;
        float[] pymolView = new float[21];
        boolean depthCue = this.booleanSetting(84);
        boolean fog = this.booleanSetting(88);
        float fog_start = this.floatSetting(192);
        int pt = 0;
        int i = 0;
        for (j = 0; j < 3; ++j) {
            pymolView[pt++] = PyMOLReader.floatAt(view, i++);
        }
        if (isViewObj) {
            ++i;
        }
        for (j = 0; j < 3; ++j) {
            pymolView[pt++] = PyMOLReader.floatAt(view, i++);
        }
        if (isViewObj) {
            ++i;
        }
        for (j = 0; j < 3; ++j) {
            pymolView[pt++] = PyMOLReader.floatAt(view, i++);
        }
        if (isViewObj) {
            i += 5;
        }
        for (j = 0; j < 8; ++j) {
            pymolView[pt++] = PyMOLReader.floatAt(view, i++);
        }
        boolean isOrtho = this.booleanSetting(23);
        float fov = this.floatSetting(152);
        pymolView[pt++] = isOrtho ? fov : -fov;
        pymolView[pt++] = depthCue ? 1 : 0;
        pymolView[pt++] = fog ? 1 : 0;
        pymolView[pt++] = fog_start;
        return pymolView;
    }

    float globalSetting(int i) {
        Lst<Object> setting = PyMOLReader.listAt(this.settings, i);
        if (setting != null && setting.size() == 3) {
            return ((Number)setting.get(2)).floatValue();
        }
        return PyMOL.getDefaultSetting(i, this.pymolVersion);
    }

    PyMOLGroup addGroup(Lst<Object> object, String parent, int type, BS bsAtoms) {
        if (this.groups == null) {
            this.groups = new Hashtable<String, PyMOLGroup>();
        }
        PyMOLGroup myGroup = this.getGroup(this.objectName);
        myGroup.object = object;
        myGroup.objectNameID = this.objectNameID;
        myGroup.visible = !this.objectHidden;
        myGroup.type = type;
        if (!myGroup.visible) {
            this.occludedObjects.put(this.objectNameID, Boolean.TRUE);
            this.htHiddenObjects.put(this.objectName, Boolean.TRUE);
        }
        if (parent != null && parent.length() != 0) {
            this.getGroup(parent).addList(myGroup);
        }
        if (bsAtoms != null) {
            myGroup.addGroupAtoms(bsAtoms);
        }
        return myGroup;
    }

    PyMOLGroup getGroup(String name) {
        PyMOLGroup g = this.groups.get(name);
        if (g == null) {
            g = new PyMOLGroup(name);
            this.groups.put(name, g);
            this.defineAtoms(name, g.bsAtoms);
        }
        return g;
    }

    void finalizeVisibility() {
        this.setGroupVisibilities();
        if (this.groups != null) {
            int i = this.jmolObjects.size();
            while (--i >= 0) {
                JmolObject obj = (JmolObject)this.jmolObjects.get(i);
                if (obj.jmolName == null || !this.occludedObjects.containsKey(obj.jmolName)) continue;
                obj.visible = false;
            }
        }
        if (!this.bsHidden.isEmpty()) {
            this.addJmolObject(0x20002A, this.bsHidden, null);
        }
    }

    void setCarveSets(Map<String, Lst<Object>> htObjNames) {
        if (this.htCarveSets.isEmpty()) {
            return;
        }
        for (Map.Entry<String, BS> e : this.htCarveSets.entrySet()) {
            this.getSelectionAtoms(PyMOLReader.listAt(htObjNames.get(e.getKey()), 5), 0, e.getValue());
        }
    }

    private void setGroupVisibilities() {
        if (this.groups == null) {
            return;
        }
        Collection<PyMOLGroup> list = this.groups.values();
        BS bsAll = new BS();
        for (PyMOLGroup g : list) {
            bsAll.or(g.bsAtoms);
            if (g.parent == null) {
                this.setGroupVisible(g, true);
                continue;
            }
            if (!g.list.isEmpty()) continue;
            g.addGroupAtoms(new BS());
        }
        this.defineAtoms("all", bsAll);
    }

    private void defineAtoms(String name, BS bs) {
        this.htDefinedAtoms.put(this.getJmolName(name), bs);
    }

    private String getJmolName(String name) {
        return "__" + this.fixName(name);
    }

    void createShapeObjects(BS[] reps, boolean allowSurface, int ac0, int ac) {
        if (ac >= 0) {
            this.bsAtoms = BSUtil.newBitSet2((int)ac0, (int)ac);
            JmolObject jo = this.addJmolObject(0x44000001, this.bsAtoms, null);
            this.colixes = AU.ensureLengthShort((short[])this.colixes, (int)ac);
            int i = ac;
            while (--i >= ac0) {
                this.colixes[i] = (short)((Integer)this.atomColorList.get(i)).intValue();
            }
            jo.setColors(this.colixes, 0.0f);
            jo.setSize(0.0f);
            jo = this.addJmolObject(1, this.bsAtoms, null);
            jo.setSize(0.0f);
        }
        this.createShapeObject(7, reps[7]);
        this.createShapeObject(0, reps[0]);
        this.fixReps(reps);
        this.createSpacefillObjects();
        block10: for (int i = 0; i < 23; ++i) {
            switch (i) {
                case 0: 
                case 7: {
                    continue block10;
                }
                case 2: 
                case 8: {
                    if (!allowSurface) continue block10;
                    switch (this.surfaceMode) {
                        case 0: {
                            reps[i].andNot(this.bsNoSurface);
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: 
                        case 4: {
                            reps[i].andNot(this.bsHydrogen);
                        }
                    }
                }
                default: {
                    this.createShapeObject(i, reps[i]);
                }
            }
        }
        this.bsAtoms = null;
    }

    void addLabel(int atomIndex, int uniqueID, int atomColor, float[] labelPos, String label) {
        int icolor = (int)this.getUniqueFloatDef(uniqueID, 66, this.labelColor);
        if (icolor != -7 && icolor != -6 && icolor < 0) {
            icolor = atomColor;
        }
        if (labelPos == null) {
            P3 offset = this.getUniquePoint(uniqueID, 471, null);
            if (offset == null) {
                offset = this.labelPosition;
            } else {
                offset.add((T3)this.labelPosition);
            }
            this.setLabelPosition(offset, labelPos);
        }
        this.labels.put(atomIndex, this.newTextLabel(label, labelPos, icolor, this.labelFontId, this.labelSize));
    }

    float getUniqueFloatDef(int id, int key, float defaultValue) {
        Lst<Object> setting;
        if (id <= 0 || (setting = this.uniqueSettings.get((id << 10) + key)) == null) {
            return defaultValue;
        }
        float v = ((Number)setting.get(2)).floatValue();
        if (Logger.debugging) {
            Logger.debug((String)("Pymol unique setting for " + id + ": [" + key + "] = " + v));
        }
        return v;
    }

    P3 getUniquePoint(int id, int key, P3 pt) {
        Lst<Object> setting;
        if (id <= 0 || (setting = this.uniqueSettings.get((id << 10) + key)) == null) {
            return pt;
        }
        pt = new P3();
        PyMOLReader.pointAt((Lst<Object>)((Lst)setting.get(2)), 0, pt);
        Logger.info((String)("Pymol unique setting for " + id + ": " + key + " = " + pt));
        return pt;
    }

    Lst<Object> getObjectSetting(int i) {
        return this.objectSettings.get(i);
    }

    boolean booleanSetting(int i) {
        return this.floatSetting(i) != 0.0f;
    }

    float floatSetting(int i) {
        Lst<Object> setting = this.getSetting(i);
        if (setting != null && setting.size() == 3) {
            return ((Number)setting.get(2)).floatValue();
        }
        return PyMOL.getDefaultSetting(i, this.pymolVersion);
    }

    String stringSetting(int i) {
        Lst<Object> setting = this.getSetting(i);
        if (setting != null && setting.size() == 3) {
            return setting.get(2).toString();
        }
        return PyMOL.getDefaultSettingS(i, this.pymolVersion);
    }

    private Lst<Object> getSetting(int i) {
        Lst setting = null;
        if (this.stateSettings != null) {
            setting = this.stateSettings.get(i);
        }
        if (setting == null && this.objectSettings != null) {
            setting = this.objectSettings.get(i);
        }
        if (setting == null && i < this.settings.size()) {
            setting = (Lst)this.settings.get(i);
        }
        return setting;
    }

    float[] setLabelPosition(P3 offset, float[] labelPos) {
        labelPos[0] = 1.0f;
        labelPos[1] = offset.x;
        labelPos[2] = offset.y;
        labelPos[3] = offset.z;
        return labelPos;
    }

    String addCGO(Lst<Object> data, int color) {
        data.addLast((Object)this.objectName);
        JmolObject jo = this.addJmolObject(23, null, data);
        jo.argb = color;
        jo.translucency = this.floatSetting(441);
        return this.fixName(this.objectName);
    }

    boolean addMeasurements(MeasurementData[] mdList, int nCoord, Lst<Object> list, BS bsReps, int color, Lst<Object> offsets, boolean haveLabels) {
        int clabel;
        int n;
        boolean isNew = mdList == null;
        int n2 = n = isNew ? list.size() / 3 / nCoord : mdList.length;
        if (n == 0) {
            return false;
        }
        boolean drawLabel = haveLabels && bsReps.get(3);
        boolean drawDashes = bsReps.get(10);
        float rad = this.floatSetting(107) / 20.0f;
        if (rad == 0.0f) {
            rad = 0.05f;
        }
        if (!drawDashes) {
            rad = -5.0E-4f;
        }
        if (color < 0) {
            color = (int)this.floatSetting(574);
        }
        int c = PyMOL.getRGB(color);
        short colix = C.getColix((int)c);
        int n3 = clabel = this.labelColor < 0 ? color : this.labelColor;
        if (isNew) {
            mdList = new MeasurementData[n];
            this.htMeasures.put(this.objectName, mdList);
        }
        BS bs = BSUtil.newAndSetBit((int)0);
        int p = 0;
        for (int index = 0; index < n; ++index) {
            MeasurementData md;
            float[] offset;
            if (isNew) {
                Lst points = new Lst();
                int i = 0;
                while (i < nCoord) {
                    points.addLast((Object)PyMOLReader.pointAt(list, p, (P3)new Point3fi()));
                    ++i;
                    p += 3;
                }
                offset = PyMOLReader.floatsAt(PyMOLReader.listAt(offsets, index), 0, new float[7], 7);
                if (offset == null) {
                    offset = this.setLabelPosition(this.labelPosition, new float[7]);
                }
                md = mdList[index] = this.vwr.newMeasurementData(this.objectNameID + "_" + (index + 1), points);
                md.note = this.objectName;
            } else {
                md = mdList[index];
                offset = md.text.pymolOffset;
            }
            int nDigits = (int)this.floatSetting(MEAS_DIGITS[nCoord - 2]);
            String strFormat = nCoord + ": " + (drawLabel ? "%0." + (nDigits < 0 ? 1 : nDigits) + "VALUE" : "");
            Text text = this.newTextLabel(strFormat, offset, clabel, (int)this.floatSetting(328), this.floatSetting(453));
            md.set(12290, null, null, strFormat, "angstroms", null, false, false, null, false, (int)(rad * 2000.0f), colix, text);
            this.addJmolObject(6, bs, md);
        }
        return true;
    }

    SB getViewScript(Lst<Object> view) {
        SB sb = new SB();
        float[] pymolView = this.getPymolView(view, true);
        sb.append(";set translucent " + (this.globalSetting(213) != 2.0f) + ";set zshadePower 1;set traceAlpha " + (this.globalSetting(111) != 0.0f));
        boolean rockets = this.cartoonRockets;
        sb.append(";set cartoonRockets " + rockets);
        if (rockets) {
            sb.append(";set rocketBarrels " + rockets);
        }
        sb.append(";set cartoonLadders " + this.haveNucleicLadder);
        sb.append(";set ribbonBorder " + (this.globalSetting(118) != 0.0f));
        sb.append(";set cartoonFancy " + (this.globalSetting(118) == 0.0f));
        String s = "000000" + Integer.toHexString(this.bgRgb & 0xFFFFFF);
        s = "[x" + s.substring(s.length() - 6) + "]";
        sb.append(";background " + s);
        sb.append(";moveto 0 PyMOL " + Escape.eAF((float[])pymolView));
        sb.append(";save orientation 'default';");
        return sb;
    }

    short getColix(int colorIndex, float translucency) {
        short colix = colorIndex == -7 ? (C.getBgContrast((int)this.bgRgb) == 8 ? (short)4 : 8) : (colorIndex == -6 ? (short)C.getBgContrast((int)this.bgRgb) : (short)C.getColixO((Object)PyMOL.getRGB(colorIndex)));
        return C.getColixTranslucent3((short)colix, (translucency > 0.0f ? 1 : 0) != 0, (float)translucency);
    }

    void setAtomColor(int atomColor) {
        this.atomColorList.addLast((Object)this.getColix(atomColor, 0.0f));
    }

    void setFrameObject(int type, Object info) {
        if (info != null) {
            this.frameObj = this.getJmolObject(type, null, info);
            return;
        }
        if (this.frameObj == null) {
            return;
        }
        this.frameObj.finalizeObject(this, this.vwr.ms, null, false);
        this.frameObj = null;
    }

    private String fixName(String name) {
        char[] chars = name.toLowerCase().toCharArray();
        int i = chars.length;
        while (--i >= 0) {
            if (PT.isLetterOrDigit((char)chars[i])) continue;
            chars[i] = 95;
        }
        return String.valueOf(chars);
    }

    String getObjectID(String name) {
        return (String)this.objectInfo.get(name)[0];
    }

    private int getObjectType(String name) {
        Object[] o = this.objectInfo.get(name);
        return o == null ? 0 : (Integer)o[1];
    }

    BS setAtomMap(int[] atomMap, int ac0) {
        this.htAtomMap.put(this.objectNameID, atomMap);
        BS bsAtoms = this.htDefinedAtoms.get(this.objectJmolName);
        if (bsAtoms == null) {
            bsAtoms = BS.newN((int)(ac0 + atomMap.length));
            Logger.info((String)("PyMOL molecule " + this.objectName));
            this.htDefinedAtoms.put(this.objectJmolName, bsAtoms);
            this.htObjectAtoms.put(this.objectName, bsAtoms);
            this.moleculeNames.addLast((Object)this.objectName);
        }
        return bsAtoms;
    }

    private Text newTextLabel(String label, float[] labelOffset, int colorIndex, int fontID, float fontSize) {
        String style;
        String face;
        float factor = 1.0f;
        switch (fontID) {
            default: {
                face = "SansSerif";
                break;
            }
            case 0: 
            case 1: {
                face = "Monospaced";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                face = "Serif";
            }
        }
        switch (fontID) {
            default: {
                style = "Plain";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 17: {
                style = "Italic";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                style = "Bold";
                break;
            }
            case 8: 
            case 14: 
            case 18: {
                style = "BoldItalic";
            }
        }
        Font font = this.vwr.getFont3D(face, style, fontSize == 0.0f ? 12.0f : fontSize * factor);
        Text t = Text.newLabel((Viewer)this.vwr, (Font)font, (String)label, (short)this.getColix(colorIndex, 0.0f), (short)0, (int)0, (float)0.0f);
        if (t != null) {
            t.pymolOffset = labelOffset;
        }
        return t;
    }

    private void setVersionSettings() {
        if (this.pymolVersion < 100) {
            this.addSetting(550, 2, 0);
            this.addSetting(529, 2, 2);
            this.addSetting(471, 4, new double[]{1.0, 1.0, 0.0});
            if (this.pymolVersion < 99) {
                this.addSetting(448, 2, 0);
                this.addSetting(431, 2, 0);
                this.addSetting(361, 2, 1);
            }
        }
    }

    private void addSetting(int key, int type, Object val) {
        int settingCount = this.settings.size();
        if (settingCount <= key) {
            int i = key + 1;
            while (--i >= settingCount) {
                this.settings.addLast(null);
            }
        }
        if (type == 4) {
            double[] d = (double[])val;
            Lst list = new Lst();
            val = list;
            for (int i = 0; i < 3; ++i) {
                list.addLast((Object)d[i]);
            }
        }
        Lst setting = new Lst();
        setting.addLast((Object)key);
        setting.addLast((Object)type);
        setting.addLast(val);
        this.settings.set(key, (Object)setting);
    }

    private void fixReps(BS[] reps) {
        this.htSpacefill.clear();
        this.bsCartoon.clearAll();
        int iAtom = this.bsAtoms.nextSetBit(0);
        while (iAtom >= 0) {
            int cartoonType;
            int uniqueID;
            float rad = 0.0f;
            int n = uniqueID = this.reader == null ? this.uniqueIDs[iAtom] : this.reader.getUniqueID(iAtom);
            if (reps[1].get(iAtom)) {
                rad = (this.reader == null ? this.radii[iAtom] : this.reader.getVDW(iAtom)) * this.getUniqueFloatDef(uniqueID, 155, this.sphereScale);
            } else if (reps[4].get(iAtom)) {
                rad = this.nonbondedSize;
            }
            if (rad != 0.0f) {
                Float r = Float.valueOf(rad);
                BS bsr = this.htSpacefill.get(r);
                if (bsr == null) {
                    bsr = new BS();
                    this.htSpacefill.put(r, bsr);
                }
                bsr.set(iAtom);
            }
            int n2 = cartoonType = this.reader == null ? this.cartoonTypes[iAtom] : this.reader.getCartoonType(iAtom);
            if (reps[5].get(iAtom)) {
                switch (cartoonType) {
                    case 1: 
                    case 4: {
                        reps[21].set(iAtom);
                    }
                    case -1: {
                        reps[5].clear(iAtom);
                        this.bsCartoon.clear(iAtom);
                        break;
                    }
                    case 7: {
                        reps[22].set(iAtom);
                        reps[5].clear(iAtom);
                        this.bsCartoon.clear(iAtom);
                        break;
                    }
                    default: {
                        this.bsCartoon.set(iAtom);
                    }
                }
            }
            iAtom = this.bsAtoms.nextSetBit(iAtom + 1);
        }
        reps[5].and(this.bsCartoon);
        this.cleanSingletons(reps[5]);
        this.cleanSingletons(reps[6]);
        this.cleanSingletons(reps[21]);
        this.cleanSingletons(reps[22]);
        this.bsCartoon.and(reps[5]);
    }

    private void cleanSingletons(BS bs) {
        if (bs.isEmpty()) {
            return;
        }
        bs.and(this.bsAtoms);
        BS bsr = new BS();
        int n = bs.length();
        int pass = 0;
        while (true) {
            int i = 0;
            int offset = 0;
            int iPrev = Integer.MIN_VALUE;
            int iSeqLast = Integer.MIN_VALUE;
            int iSeq = Integer.MIN_VALUE;
            while (i < n) {
                if (iPrev < 0 || (this.reader == null ? this.newChain[i] : this.reader.compareAtoms(iPrev, i))) {
                    ++offset;
                }
                int n2 = iSeq = this.reader == null ? this.sequenceNumbers[i] : this.reader.getSequenceNumber(i);
                if (iSeq != iSeqLast) {
                    iSeqLast = iSeq;
                    ++offset;
                }
                if (pass == 0) {
                    if (bs.get(i)) {
                        bsr.set(offset);
                    }
                } else if (!bsr.get(offset)) {
                    bs.clear(i);
                }
                iPrev = i++;
            }
            if (++pass == 2) break;
            BS bsnot = new BS();
            int i2 = bsr.nextSetBit(0);
            while (i2 >= 0) {
                if (!bsr.get(i2 - 1) && !bsr.get(i2 + 1)) {
                    bsnot.set(i2);
                }
                i2 = bsr.nextSetBit(i2 + 1);
            }
            bsr.andNot(bsnot);
        }
    }

    private void createShapeObject(int shapeID, BS bs) {
        if (bs.isEmpty()) {
            return;
        }
        JmolObject jo = null;
        switch (shapeID) {
            case 11: {
                bs.and(this.bsNonbonded);
                if (bs.isEmpty()) {
                    return;
                }
                this.setUniqueObjects(7, bs, 0, 0, 524, this.nonbondedTranslucency, 0, this.nonbondedSize, 0.5f);
                break;
            }
            case 1: 
            case 4: {
                this.setUniqueObjects(0, bs, 173, this.sphereColor, 172, this.sphereTranslucency, 155, this.sphereScale, 1.0f);
                break;
            }
            case 19: {
                float ellipsoidTranslucency = this.floatSetting(571);
                int ellipsoidColor = (int)this.floatSetting(570);
                float ellipsoidScale = this.floatSetting(569);
                this.setUniqueObjects(20, bs, 570, ellipsoidColor, 571, ellipsoidTranslucency, 569, ellipsoidScale, 50.0f);
                break;
            }
            case 9: {
                this.setUniqueObjects(16, bs, 210, this.dotColor, 0, 0.0f, 155, this.sphereScale, 1.0f);
                break;
            }
            case 2: {
                float withinDistance = this.floatSetting(344);
                jo = this.addJmolObject(135180, bs, new Object[]{this.booleanSetting(156) ? "FULLYLIT" : "FRONTLIT", this.surfaceMode == 3 || this.surfaceMode == 4 ? " only" : "", this.bsCarve, Float.valueOf(withinDistance)});
                jo.setSize(this.floatSetting(4) * (float)(this.solventAccessible ? -1 : 1));
                jo.translucency = this.transparency;
                if (this.surfaceColor >= 0) {
                    jo.argb = PyMOL.getRGB(this.surfaceColor);
                }
                jo.modelIndex = this.currentAtomSetIndex;
                jo.cacheID = this.surfaceInfoName;
                this.setUniqueObjects(24, bs, 144, this.surfaceColor, 138, this.transparency, 0, 0.0f, 0.0f);
                break;
            }
            case 8: {
                jo = this.addJmolObject(135180, bs, null);
                jo.setSize(this.floatSetting(4));
                jo.translucency = this.transparency;
                this.setUniqueObjects(24, bs, 144, this.surfaceColor, 138, this.transparency, 0, 0.0f, 0.0f);
                break;
            }
            case 3: {
                bs.and(this.bsLabeled);
                if (bs.isEmpty()) {
                    return;
                }
                jo = this.addJmolObject(5, bs, this.labels);
                break;
            }
            case 7: 
            case 10: {
                jo = this.addJmolObject(659488, bs, null);
                jo.setSize(this.floatSetting(44) / 15.0f);
                int color = (int)this.floatSetting(526);
                if (color < 0) break;
                jo.argb = PyMOL.getRGB(color);
                break;
            }
            case 0: {
                jo = this.addJmolObject(1, bs, null);
                jo.setSize(this.floatSetting(21) * 2.0f);
                jo.translucency = this.stickTranslucency;
                int col = (int)this.floatSetting(376);
                if (col < 0) break;
                jo.argb = PyMOL.getRGB(col);
                break;
            }
            case 5: {
                this.createCartoonObject("H", this.cartoonRockets ? 181 : 100);
                this.createCartoonObject("S", 96);
                this.createCartoonObject("L", 92);
                this.createCartoonObject(" ", 92);
                break;
            }
            case 22: {
                this.createPuttyObject(bs);
                break;
            }
            case 21: {
                this.createTraceObject(bs);
                break;
            }
            case 6: {
                this.createRibbonObject(bs);
                break;
            }
            default: {
                Logger.error((String)("Unprocessed representation type " + shapeID));
            }
        }
    }

    private JmolObject setUniqueObjects(int shape, BS bs, int setColor, int color, int setTrans, float trans, int setSize, float size, float f) {
        int n = bs.cardinality();
        short[] colixes = setColor == 0 ? null : new short[n];
        float[] atrans = setTrans == 0 ? null : new float[n];
        float[] sizes = new float[n];
        int pt = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            int c;
            int id;
            int n2 = id = this.reader == null ? this.uniqueIDs[i] : this.reader.getUniqueID(i);
            if (colixes != null && (c = (int)this.getUniqueFloatDef(id, setColor, color)) > 0) {
                colixes[pt] = this.getColix(c, 0.0f);
            }
            if (atrans != null) {
                atrans[pt] = this.getUniqueFloatDef(id, setTrans, trans);
            }
            sizes[pt] = this.getUniqueFloatDef(id, setSize, size) * f;
            i = bs.nextSetBit(i + 1);
            ++pt;
        }
        return this.addJmolObject(shape, bs, new Object[]{colixes, atrans, sizes});
    }

    private void createSpacefillObjects() {
        for (Map.Entry<Float, BS> e : this.htSpacefill.entrySet()) {
            float r = e.getKey().floatValue();
            BS bs = e.getValue();
            this.addJmolObject((int)0x44000001, (BS)bs, null).rd = new RadiusData(null, r, RadiusData.EnumType.ABSOLUTE, VDW.AUTO);
        }
        this.htSpacefill.clear();
    }

    private void createTraceObject(BS bs) {
        this.checkNucleicObject(bs, true);
        if (bs.isEmpty()) {
            return;
        }
        float r = this.floatSetting(103);
        JmolObject jo = this.setUniqueObjects(10, bs, 236, this.cartoonColor, 0, 0.0f, 0, 0.0f, 0.0f);
        jo.setSize(r * 2.0f);
        jo.translucency = this.cartoonTranslucency;
    }

    private void checkNucleicObject(BS bs, boolean isTrace) {
        BS bsNuc = BSUtil.copy((BS)this.bsNucleic);
        bsNuc.and(bs);
        if (!bsNuc.isEmpty()) {
            if (isTrace && this.cartoonLadderMode) {
                this.haveNucleicLadder = true;
            }
            JmolObject jo = this.addJmolObject(11, bsNuc, null);
            jo.translucency = this.cartoonTranslucency;
            jo.setSize(this.floatSetting(103) * 2.0f);
            bs.andNot(bsNuc);
        }
    }

    private void createPuttyObject(BS bs) {
        float[] info = new float[]{this.floatSetting(378), this.floatSetting(377), this.floatSetting(382), this.floatSetting(379), this.floatSetting(380), this.floatSetting(381), this.floatSetting(581)};
        this.addJmolObject((int)1112152078, (BS)bs, (Object)info).translucency = this.cartoonTranslucency;
    }

    private void createRibbonObject(BS bs) {
        boolean isTrace = this.floatSetting(19) > 1.0f;
        float r = this.floatSetting(20) * 2.0f;
        float rayScale = this.floatSetting(327);
        if (r == 0.0f) {
            r = this.floatSetting(106) * (isTrace ? 1.0f : (rayScale <= 1.0f ? 0.5f : rayScale)) * 0.1f;
        }
        JmolObject jo = this.setUniqueObjects(isTrace ? 10 : 9, bs, 235, this.ribbonColor, 0, 0.0f, 0, 0.0f, 0.0f);
        jo.setSize(r);
        jo.translucency = this.ribbonTranslucency;
    }

    private void createCartoonObject(String key, int sizeID) {
        BS bs = BSUtil.copy((BS)this.ssMapAtom.get(key));
        if (bs == null) {
            return;
        }
        bs.and(this.bsCartoon);
        if (bs.isEmpty()) {
            return;
        }
        if (key.equals(" ")) {
            this.checkNucleicObject(bs, false);
            if (bs.isEmpty()) {
                return;
            }
        }
        JmolObject jo = this.setUniqueObjects(11, bs, 236, this.cartoonColor, 0, 0.0f, 0, 0.0f, 0.0f);
        jo.setSize(this.floatSetting(sizeID) * 2.0f);
        jo.translucency = this.cartoonTranslucency;
    }

    private JmolObject addObject(JmolObject obj) {
        this.jmolObjects.addLast((Object)obj);
        return obj;
    }

    private void setGroupVisible(PyMOLGroup g, boolean parentVis) {
        boolean vis;
        boolean bl = vis = parentVis && g.visible;
        if (vis) {
            return;
        }
        g.visible = false;
        this.occludedObjects.put(g.objectNameID, Boolean.TRUE);
        this.htHiddenObjects.put(g.name, Boolean.TRUE);
        switch (g.type) {
            case 1: {
                this.bsHidden.or(g.bsAtoms);
                break;
            }
            default: {
                g.occluded = true;
            }
        }
        for (PyMOLGroup gg : g.list.values()) {
            this.setGroupVisible(gg, vis);
        }
    }

    BS getSSMapAtom(String ssType) {
        BS bs = this.ssMapAtom.get(ssType);
        if (bs == null) {
            bs = new BS();
            this.ssMapAtom.put(ssType, bs);
        }
        return bs;
    }

    Map<String, Object> setAtomDefs() {
        this.setGroupVisibilities();
        Hashtable<String, Object> defs = new Hashtable<String, Object>();
        for (Map.Entry<String, BS> e : this.htDefinedAtoms.entrySet()) {
            BS bs = e.getValue();
            if (bs.isEmpty()) continue;
            defs.put(e.getKey(), bs);
        }
        this.addJmolObject(12290, null, defs);
        return defs;
    }

    boolean needSelections() {
        return this.haveScenes || !this.htCarveSets.isEmpty();
    }

    void setUniqueBonds(BS bsBonds, boolean isSticks) {
        if (isSticks) {
            this.bsStickBonds.or(bsBonds);
            this.bsStickBonds.andNot(this.bsLineBonds);
        } else {
            this.bsLineBonds.or(bsBonds);
            this.bsLineBonds.andNot(this.bsStickBonds);
        }
    }

    private void finalizeUniqueBonds() {
        if (this.uniqueList == null) {
            return;
        }
        int bondCount = this.vwr.ms.bondCount;
        Bond[] bonds = this.vwr.ms.bo;
        int i = this.bsUniqueBonds.nextSetBit(0);
        while (i >= 0) {
            float rad = Float.NaN;
            int id = this.uniqueList.get(i);
            if (this.bsLineBonds.get(i)) {
                rad = this.getUniqueFloatDef(id, 44, Float.NaN) / 30.0f;
            } else if (this.bsStickBonds.get(i)) {
                rad = this.getUniqueFloatDef(id, 21, Float.NaN);
            }
            int c = (int)this.getUniqueFloatDef(id, 376, 2.1474836E9f);
            if (c != Integer.MAX_VALUE) {
                c = PyMOL.getRGB(c);
            }
            float valence = this.getUniqueFloatDef(id, 64, Float.NaN);
            float t = this.getUniqueFloatDef(id, 198, Float.NaN);
            if (i < 0 || i >= bondCount) {
                return;
            }
            Bond b = bonds[i];
            this.setBondParameters(b, this.thisState - 1, rad, valence, c, t);
            i = this.bsUniqueBonds.nextSetBit(i + 1);
        }
    }

    void setBondParameters(Bond b, int modelIndex, float rad, float pymolValence, int argb, float trans) {
        if (modelIndex >= 0 && b.atom1.mi != modelIndex) {
            return;
        }
        if (!Float.isNaN(rad)) {
            b.mad = (short)(rad * 2000.0f);
        }
        short colix = b.colix;
        if (argb != Integer.MAX_VALUE) {
            colix = C.getColix((int)argb);
        }
        if (!Float.isNaN(trans)) {
            b.colix = C.getColixTranslucent3((short)colix, (trans != 0.0f ? 1 : 0) != 0, (float)trans);
        } else if (b.colix != colix) {
            b.colix = C.copyColixTranslucency((short)b.colix, (short)colix);
        }
        if (pymolValence == 1.0f) {
            b.order |= 0x18000;
        } else if (pymolValence == 0.0f) {
            b.order |= 0x10000;
        }
    }

    void addMesh(int tok, Lst<Object> obj, String objName, boolean isMep) {
        JmolObject jo = this.addJmolObject(tok, null, obj);
        this.setSceneObject(objName, -1);
        int meshColor = (int)this.floatSetting(146);
        if (meshColor < 0) {
            meshColor = PyMOLReader.intAt(PyMOLReader.listAt(obj, 0), 2);
        }
        if (!isMep) {
            jo.setSize(this.meshWidth);
            jo.argb = PyMOL.getRGB(meshColor);
        }
        jo.translucency = this.transparency;
        jo.cacheID = this.surfaceInfoName;
    }

    JmolObject addIsosurface(String objectName) {
        JmolObject jo = this.addJmolObject(135180, null, objectName);
        jo.cacheID = this.surfaceInfoName;
        return jo;
    }
}

