/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.modelset.Atom;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;

public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;
    private static final int MODE_ATROP = 4;

    @Override
    public String getLastException() {
        return InvalidSmilesException.getLastError();
    }

    @Override
    public String getMolecularFormula(String string, boolean bl) throws Exception {
        InvalidSmilesException.clear();
        SmilesSearch smilesSearch = SmilesParser.newSearch("/nostereo/" + string, bl, true);
        smilesSearch.createTopoMap(null);
        smilesSearch.nodes = smilesSearch.targetAtoms;
        return smilesSearch.getMolecularFormula(!bl, null, false);
    }

    @Override
    public String getSmiles(Node[] nodeArray, int n, BS bS, String string, int n2) throws Exception {
        InvalidSmilesException.clear();
        return new SmilesGenerator().getSmiles(this, nodeArray, n, bS, string, n2);
    }

    @Override
    public int areEqual(String string, String string2) throws Exception {
        InvalidSmilesException.clear();
        BS[] bSArray = (BS[])this.findPriv(string, SmilesParser.newSearch(string2, false, true), (string.indexOf("*") >= 0 ? 2 : 1) | 8, 2);
        return bSArray == null ? -1 : bSArray.length;
    }

    public boolean areEqualTest(String string, SmilesSearch smilesSearch) throws Exception {
        BS[] bSArray = (BS[])this.findPriv(string, smilesSearch, 9, 2);
        return bSArray != null && bSArray.length == 1;
    }

    @Override
    public int[][] find(String string, String string2, int n) throws Exception {
        InvalidSmilesException.clear();
        string2 = SmilesParser.cleanPattern(string2);
        string = SmilesParser.cleanPattern(string);
        SmilesSearch smilesSearch = SmilesParser.newSearch(string2, false, true);
        int[][] nArray = (int[][])this.findPriv(string, smilesSearch, n, 3);
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int[] nArray2 = nArray[n2];
            int n3 = nArray2.length;
            while (--n3 >= 0) {
                nArray2[n3] = ((SmilesAtom)smilesSearch.targetAtoms[nArray2[n3]]).mapIndex;
            }
        }
        return nArray;
    }

    @Override
    public Node[] getAtoms(String string) throws Exception {
        InvalidSmilesException.clear();
        string = SmilesParser.cleanPattern(string);
        SmilesSearch smilesSearch = SmilesParser.newSearch(string, false, true);
        smilesSearch.createTopoMap(new BS());
        return smilesSearch.targetAtoms;
    }

    @Override
    public String getRelationship(String string, String string2) throws Exception {
        int n;
        boolean bl;
        String string3;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return "";
        }
        String string4 = this.getMolecularFormula(string, false);
        if (!string4.equals(string3 = this.getMolecularFormula(string2, false))) {
            return "none";
        }
        int n2 = PT.countChar(PT.rep(string, "@@", "@"), '@');
        boolean bl2 = bl = n2 == (n = PT.countChar(PT.rep(string2, "@@", "@"), '@')) && this.areEqual(string2, string) > 0;
        if (!bl) {
            String string5 = String.valueOf(string) + string2;
            if (string5.indexOf("/") >= 0 || string5.indexOf("\\") >= 0 || string5.indexOf("@") >= 0) {
                if (n2 == n && n2 > 0 && string5.indexOf("@SP") < 0) {
                    boolean bl3 = bl = this.areEqual("/invertstereo/" + string2, string) > 0;
                    if (bl) {
                        return "enantiomers";
                    }
                }
                boolean bl4 = bl = this.areEqual("/nostereo/" + string2, string) > 0;
                if (bl) {
                    return n2 == n ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    @Override
    public String reverseChirality(String string) {
        string = PT.rep(string, "@@", "!@");
        string = PT.rep(string, "@", "@@");
        string = PT.rep(string, "!@@", "@");
        return string;
    }

    @Override
    public BS getSubstructureSet(String string, Node[] nodeArray, int n, BS bS, int n2) throws Exception {
        return (BS)this.matchPriv(string, nodeArray, n, bS, null, true, n2 | SmilesParser.getFlags(string), 1);
    }

    @Override
    public void getMMFF94AtomTypes(String[] stringArray, Node[] nodeArray, int n, BS bS, Lst<BS> lst, Lst<BS>[] lstArray) throws Exception {
        InvalidSmilesException.clear();
        SmilesParser smilesParser = new SmilesParser(true, true);
        SmilesSearch smilesSearch = null;
        int n2 = 770;
        smilesSearch = smilesParser.parse("");
        smilesSearch.exitFirstMatch = false;
        smilesSearch.targetAtoms = nodeArray;
        smilesSearch.targetAtomCount = Math.abs(n);
        smilesSearch.setSelected(bS);
        smilesSearch.flags = n2;
        smilesSearch.getRingData(lstArray, true, true);
        smilesSearch.asVector = false;
        smilesSearch.subSearches = new SmilesSearch[1];
        smilesSearch.getSelections();
        BS bS2 = new BS();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] == null || stringArray[n3].length() == 0 || stringArray[n3].startsWith("#")) {
                lst.addLast(null);
            } else {
                smilesSearch.clear();
                smilesSearch.subSearches[0] = smilesParser.getSubsearch(smilesSearch, SmilesParser.cleanPattern(stringArray[n3]), n2);
                BS bS3 = BSUtil.copy((BS)smilesSearch.search());
                lst.addLast(bS3);
                bS2.or(bS3);
                if (bS2.cardinality() == n) {
                    return;
                }
            }
            ++n3;
        }
    }

    @Override
    public BS[] getSubstructureSetArray(String string, Node[] nodeArray, int n, BS bS, BS bS2, int n2) throws Exception {
        return (BS[])this.matchPriv(string, nodeArray, n, bS, bS2, true, n2, 2);
    }

    public String getAtropisomerKeys(String string, Node[] nodeArray, int n, BS bS, BS bS2, int n2) throws Exception {
        return (String)this.matchPriv(string, nodeArray, n, bS, bS2, false, n2, 4);
    }

    @Override
    public String polyhedronToSmiles(Node node, int[][] nArray, int n, P3[] p3Array, int n2, String string) throws Exception {
        Object object;
        Node[] nodeArray = new SmilesAtom[n];
        int n3 = 0;
        while (n3 < n) {
            P3 p3;
            nodeArray[n3] = new SmilesAtom();
            P3 p32 = p3 = p3Array == null ? null : p3Array[n3];
            if (p3 instanceof Node) {
                nodeArray[n3].elementNumber = ((Node)((Object)p3)).getElementNumber();
                nodeArray[n3].bioAtomName = ((Node)((Object)p3)).getAtomName();
                nodeArray[n3].atomNumber = ((Node)((Object)p3)).getAtomNumber();
                nodeArray[n3].setT(p3);
            } else {
                nodeArray[n3].elementNumber = p3 instanceof Point3fi ? (int)((Point3fi)p3).sD : -2;
            }
            nodeArray[n3].index = n3;
            ++n3;
        }
        n3 = 0;
        int n4 = nArray.length;
        while (--n4 >= 0) {
            int n5;
            object = nArray[n4];
            int n6 = n5 = ((int[])object).length;
            while (--n6 >= 0) {
                int n7;
                int n8 = object[n6];
                if (n8 >= n || (n7 = object[(n6 + 1) % n5]) >= n || ((SmilesAtom)nodeArray[n8]).getBondTo((SmilesAtom)nodeArray[n7]) != null) continue;
                SmilesBond smilesBond = new SmilesBond((SmilesAtom)nodeArray[n8], (SmilesAtom)nodeArray[n7], 1, false);
                smilesBond.index = n3++;
            }
        }
        n4 = 0;
        while (n4 < n) {
            int n9 = nodeArray[n4].bondCount;
            if (n9 == 0 || n9 != nodeArray[n4].bonds.length) {
                nodeArray[n4].bonds = (SmilesBond[])AU.arrayCopyObject(nodeArray[n4].bonds, n9);
            }
            ++n4;
        }
        String string2 = null;
        object = new SmilesGenerator();
        if (p3Array != null) {
            ((SmilesGenerator)object).polySmilesCenter = (P3)((Object)node);
        }
        InvalidSmilesException.clear();
        string2 = ((SmilesGenerator)object).getSmiles(this, nodeArray, n, BSUtil.newBitSet2(0, n), null, n2 | 0x1000 | 0x10 | 0x20);
        if ((n2 & 0x10000) == 65536) {
            string2 = "//* " + node + " *//\t[" + Elements.elementSymbolFromNumber(node.getElementNumber()) + "@PH" + n + (string == null ? "" : "/" + string + "/") + "]." + string2;
        }
        return string2;
    }

    @Override
    public int[][] getCorrelationMaps(String string, Node[] nodeArray, int n, BS bS, int n2) throws Exception {
        return (int[][])this.matchPriv(string, nodeArray, n, bS, null, true, n2, 3);
    }

    private Object findPriv(String string, SmilesSearch smilesSearch, int n, int n2) throws Exception {
        BS bS = new BS();
        smilesSearch.setFlags(smilesSearch.flags | SmilesParser.getFlags(string));
        smilesSearch.createTopoMap(bS);
        return this.matchPriv(string, smilesSearch.targetAtoms, -smilesSearch.targetAtoms.length, null, bS, bS.isEmpty(), n, n2);
    }

    private Object matchPriv(String string, Node[] nodeArray, int n, BS bS, BS bS2, boolean bl, int n2, int n3) throws Exception {
        InvalidSmilesException.clear();
        try {
            boolean bl2 = (n2 & 2) == 2;
            SmilesSearch smilesSearch = SmilesParser.newSearch(string, bl2, false);
            if (!bl2 && !smilesSearch.patternAromatic) {
                if (bS2 == null) {
                    bS2 = new BS();
                }
                SmilesSearch.normalizeAromaticity(smilesSearch.patternAtoms, bS2, smilesSearch.flags);
                smilesSearch.isNormalized = true;
            }
            smilesSearch.targetAtoms = nodeArray;
            smilesSearch.targetAtomCount = Math.abs(n);
            if (n < 0) {
                smilesSearch.haveTopo = true;
            }
            if (!(n == 0 || bS != null && bS.isEmpty())) {
                boolean bl3 = !(nodeArray[0] instanceof SmilesAtom);
                smilesSearch.setSelected(bS);
                smilesSearch.getSelections();
                if (!bl) {
                    smilesSearch.bsAromatic = bS2;
                }
                smilesSearch.setRingData(null, null, bl3 || bl);
                smilesSearch.exitFirstMatch = (n2 & 8) == 8;
                smilesSearch.mapUnique = (n2 & 0x80) == 128;
            }
            switch (n3) {
                case 1: {
                    smilesSearch.asVector = false;
                    return smilesSearch.search();
                }
                case 2: {
                    smilesSearch.asVector = true;
                    Lst lst = (Lst)smilesSearch.search();
                    return lst.toArray(new BS[lst.size()]);
                }
                case 4: {
                    smilesSearch.exitFirstMatch = true;
                    smilesSearch.setAtropicity = true;
                    smilesSearch.search();
                    return smilesSearch.atropKeys;
                }
                case 3: {
                    smilesSearch.getMaps = true;
                    smilesSearch.setFlags(n2 | smilesSearch.flags);
                    Lst lst = (Lst)smilesSearch.search();
                    return lst.toArray((T[])AU.newInt2(lst.size()));
                }
            }
        }
        catch (Exception exception) {
            if (Logger.debugging) {
                exception.printStackTrace();
            }
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.clear();
            }
            throw new InvalidSmilesException(InvalidSmilesException.getLastError());
        }
        return null;
    }

    @Override
    public String cleanSmiles(String string) {
        return SmilesParser.cleanPattern(string);
    }

    @Override
    public int[][] getMapForJME(String string, Atom[] atomArray, BS bS) {
        int n;
        Object object;
        Object object2;
        SmilesSearch smilesSearch = new SmilesSearch();
        String[] stringArray = PT.getTokens(string);
        int n2 = PT.parseInt(stringArray[0]);
        int n3 = PT.parseInt(stringArray[1]);
        int n4 = 2;
        int n5 = 0;
        while (n5 < n2) {
            object2 = stringArray[n4];
            object = smilesSearch.addAtom();
            n = ((String)object2).indexOf("+");
            int n6 = 0;
            if (n >= 0) {
                n6 = n == ((String)object2).length() - 1 ? 1 : PT.parseInt(((String)object2).substring(n + 1));
            } else {
                n = ((String)object2).indexOf("-");
                if (n >= 0) {
                    n6 = PT.parseInt(((String)object2).substring(n));
                }
            }
            ((SmilesAtom)object).setCharge(n6);
            ((SmilesAtom)object).setSymbol((String)(n < 0 ? object2 : ((String)object2).substring(0, n)));
            ++n5;
            n4 += 3;
        }
        n5 = 0;
        while (n5 < n3) {
            int n7 = PT.parseInt(stringArray[n4++]) - 1;
            int n8 = PT.parseInt(stringArray[n4++]) - 1;
            n = PT.parseInt(stringArray[n4++]);
            SmilesAtom smilesAtom = smilesSearch.patternAtoms[n7];
            SmilesAtom smilesAtom2 = smilesSearch.patternAtoms[n8];
            int n9 = 1;
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    n9 = 2;
                    break;
                }
                case 3: {
                    n9 = 3;
                }
            }
            new SmilesBond((SmilesAtom)smilesAtom, (SmilesAtom)smilesAtom2, (int)n9, (boolean)false).index = n5++;
        }
        String string2 = "";
        try {
            smilesSearch.isSmarts = true;
            smilesSearch.set();
            object2 = BSUtil.newBitSet2(0, n2);
            string2 = this.getSmiles(smilesSearch.patternAtoms, smilesSearch.ac, (BS)object2, null, 34);
            object = this.getCorrelationMaps(string2, smilesSearch.patternAtoms, n2, (BS)object2, 42);
            int[][] nArray = this.getCorrelationMaps(string2, atomArray, bS.cardinality(), bS, 42);
            return new int[][]{(int[])object[0], nArray[0]};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

