/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.smiles.SmilesRing;
import org.jmol.smiles.SmilesRingSet;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleNode;

public class SmilesAromatic {
    private static final int[][] OS_PI_COUNTS;

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = -2;
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, 2, 1, -1};
        nArrayArray[2] = new int[]{2, 1, 2, 1, 1};
        nArrayArray[3] = new int[]{2, 1};
        nArrayArray[4] = new int[]{-2, 1, 2, 1, -2};
        nArrayArray[5] = new int[]{2, 1, 2, 2};
        OS_PI_COUNTS = nArrayArray;
    }

    /*
     * Unable to fully structure code
     */
    static void setAromatic(int var0, Node[] var1_1, BS var2_2, Lst<Object> var3_3, BS var4_4, int var5_5, boolean var6_6, boolean var7_7, boolean var8_8, VTemp var9_9, Lst<BS> var10_10, Lst<SmilesRing> var11_11, int[] var12_12, boolean var13_13) {
        v0 = var14_14 = var6_6 != false || var5_5 > 0;
        if (!var13_13) {
            var15_15 = var3_3.size();
            while (--var15_15 >= 0) {
                var16_17 = BSUtil.copy((BS)var3_3.get(var15_15));
                var16_17.and(var4_4);
                if (var16_17.cardinality() != var0) continue;
                var10_10.addLast(var16_17);
            }
            return;
        }
        var15_16 = var3_3.size();
        block6: while (--var15_16 >= 0) {
            var16_18 = (BS)var3_3.get(var15_16);
            var17_19 = SmilesAromatic.isSp2Ring(var0, var1_1, var2_2, var16_18, var7_7 != false ? 3.4028235E38f : (var5_5 > 0 ? 0.1f : 0.01f), var8_8, var5_5 == 0);
            if (!var17_19) continue;
            var4_4.or(var16_18);
            if (!var14_14) ** GOTO lbl-1000
            var18_20 = new Lst<Edge>();
            var19_21 = var16_18.nextSetBit(0);
            while (var19_21 >= 0) {
                var20_22 = var1_1[var19_21];
                var21_23 = var20_22.getEdges();
                var22_24 = var20_22.getIndex();
                var23_25 = var21_23.length;
                while (--var23_25 >= 0) {
                    var24_26 = var21_23[var23_25].getOtherNode(var20_22);
                    var25_27 = var24_26.getIndex();
                    if (var25_27 <= var22_24 || !var16_18.get(var25_27)) continue;
                    var18_20.addLast(var21_23[var23_25]);
                }
                var19_21 = var16_18.nextSetBit(var19_21 + 1);
            }
            switch (SmilesAromatic.checkHueckelAromatic(var0, var1_1, var4_4, var16_18, var5_5, var12_12)) {
                case -1: {
                    break;
                }
                case 0: {
                    var17_19 = false;
                }
                case 1: {
                    if (var11_11 != null) {
                        var11_11.addLast(new SmilesRing(var0, var16_18, var18_20, var17_19));
                    }
                    if (!var17_19) continue block6;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var10_10.addLast(var16_18);
                }
            }
        }
    }

    static void checkAromaticDefined(Node[] nodeArray, BS bS, BS bS2) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Edge[] edgeArray = nodeArray[n].getEdges();
            int n2 = 0;
            while (n2 < edgeArray.length) {
                switch (edgeArray[n2].order) {
                    case 513: 
                    case 514: 
                    case 515: {
                        bS2.set(edgeArray[n2].getAtomIndex1());
                        bS2.set(edgeArray[n2].getAtomIndex2());
                    }
                }
                ++n2;
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    private static final boolean isSp2Ring(int n, Node[] nodeArray, BS bS, BS bS2, float f, boolean bl, boolean bl2) {
        int n2;
        if (bl) {
            n2 = bS2.nextSetBit(0);
            while (n2 >= 0) {
                if (nodeArray[n2].getCovalentBondCount() > 3) {
                    return false;
                }
                n2 = bS2.nextSetBit(n2 + 1);
            }
        } else {
            n2 = bS2.nextSetBit(0);
            while (n2 >= 0) {
                if (nodeArray[n2].getCovalentBondCountPlusMissingH() > 3) {
                    return false;
                }
                n2 = bS2.nextSetBit(n2 + 1);
            }
        }
        if (f == Float.MAX_VALUE) {
            return true;
        }
        if (f <= 0.0f) {
            f = 0.01f;
        }
        V3 v3 = null;
        V3 v32 = null;
        V3 v33 = null;
        int n3 = bS2.cardinality();
        V3[] v3Array = new V3[n3 * 2];
        int n4 = 0;
        float f2 = 1.0f - f * 5.0f;
        int n5 = bS2.nextSetBit(0);
        while (n5 >= 0) {
            int n6;
            Node node = nodeArray[n5];
            Edge[] edgeArray = node.getEdges();
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = edgeArray.length;
            while (--n10 >= 0) {
                n6 = node.getBondedAtomIndex(n10);
                if (!bS.get(n6)) continue;
                if (!bS2.get(n6)) {
                    if (node.getElementNumber() == 16) {
                        if (!bl2) {
                            return false;
                        }
                        n6 = -1;
                    }
                    n7 = n6;
                    continue;
                }
                if (n8 < 0) {
                    n8 = n6;
                    continue;
                }
                n9 = n6;
            }
            if (v33 == null) {
                v33 = new V3();
                v3 = new V3();
                v32 = new V3();
            }
            n10 = 0;
            n6 = n5;
            while (n10 < 2) {
                Measure.getNormalThroughPoints((P3)((Object)nodeArray[n8]), (P3)((Object)nodeArray[n6]), (P3)((Object)nodeArray[n9]), v3, v32);
                if (!SmilesAromatic.addNormal(v3, v33, f2)) {
                    return false;
                }
                v3Array[n4++] = V3.newV(v3);
                n6 = n7;
                if (n6 < 0) break;
                ++n10;
            }
            n5 = bS2.nextSetBit(n5 + 1);
        }
        return SmilesAromatic.checkStandardDeviation(v3Array, v33, n4, f);
    }

    private static final boolean addNormal(V3 v3, V3 v32, float f) {
        float f2 = v32.dot(v3);
        if (f2 != 0.0f && Math.abs(f2) < f) {
            return false;
        }
        if (f2 < 0.0f) {
            v3.scale(-1.0f);
        }
        v32.add(v3);
        v32.normalize();
        return true;
    }

    private static final boolean checkStandardDeviation(V3[] v3Array, V3 v3, int n, float f) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            float f2 = v3Array[n2].dot(v3);
            d += (double)f2;
            d2 += (double)f2 * (double)f2;
            ++n2;
        }
        return (d = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1))) < (double)f;
    }

    private static int checkHueckelAromatic(int n, Node[] nodeArray, BS bS, BS bS2, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = 0;
        int n5 = bS2.nextSetBit(0);
        while (n5 >= 0 && n3 >= 0) {
            int n6;
            Node node = nodeArray[n5];
            int n7 = node.getElementNumber();
            int n8 = node.getCovalentBondCountPlusMissingH();
            n8 += node.getValence();
            n8 -= 4;
            if (n7 == 6 && (n6 = node.getFormalCharge()) != Integer.MIN_VALUE) {
                n8 += n6;
            }
            int n9 = n7 >= 5 && n7 <= 8 ? n7 - 5 : (n7 == 15 ? 2 : (n7 == 34 ? 3 : (n7 == 33 ? 4 : (n6 = n7 == 16 ? 5 : -1))));
            if (n6 >= 0) {
                int[] nArray2 = OS_PI_COUNTS[n6];
                if (n8 < 0 || n8 >= nArray2.length) {
                    return -1;
                }
                n8 = nArray2[n8];
                block0 : switch (n8) {
                    case -2: {
                        return -1;
                    }
                    case -1: {
                        Edge[] edgeArray = node.getEdges();
                        n8 = 0;
                        int n10 = edgeArray.length;
                        while (--n10 >= 0) {
                            Edge edge = edgeArray[n10];
                            if (edge.getCovalentOrder() != 2) continue;
                            SimpleNode simpleNode = edge.getOtherNode(node);
                            n8 = simpleNode.getElementNumber() == 6 || bS.get(simpleNode.getIndex()) ? 1 : (n2 > 0 ? -100 : 0);
                            break block0;
                        }
                        break;
                    }
                }
                if (n8 < 0) {
                    return -1;
                }
                if (nArray != null) {
                    nArray[n5] = n8;
                }
                n3 += n8;
                if (n8 == 1) {
                    ++n4;
                }
                if (Logger.debuggingHigh) {
                    Logger.info("atom " + node + " pi=" + n8 + " npi=" + n3);
                }
            }
            n5 = bS2.nextSetBit(n5 + 1);
        }
        return (n3 - 2) % 4 == 0 && (n2 < 2 || n == 5 || n4 == 6) ? 1 : 0;
    }

    static void finalizeAromatic(Node[] nodeArray, BS bS, Lst<BS> lst, Lst<SmilesRing> lst2, int[] nArray, boolean bl, boolean bl2) {
        if (bl2) {
            SmilesAromatic.removeBridgingRings(lst, lst2);
        }
        SmilesAromatic.checkFusedRings(lst2, nArray, lst);
        bS.clearAll();
        int n = lst.size();
        while (--n >= 0) {
            bS.or((BS)lst.get(n));
        }
        if (bl2 || bl) {
            n = bS.nextSetBit(0);
            while (n >= 0) {
                Edge[] edgeArray = nodeArray[n].getEdges();
                int n2 = 0;
                int n3 = edgeArray.length;
                while (--n3 >= 0) {
                    SimpleNode simpleNode = edgeArray[n3].getOtherNode(nodeArray[n]);
                    int n4 = edgeArray[n3].getCovalentOrder();
                    int n5 = simpleNode.getIndex();
                    boolean bl3 = bS.get(n5);
                    if (bl3) {
                        if (n4 == 2) {
                            boolean bl4 = false;
                            int n6 = lst2.size();
                            while (--n6 >= 0) {
                                SmilesRing smilesRing = (SmilesRing)lst2.get(n6);
                                if (!smilesRing.get(n) || !smilesRing.get(n5)) continue;
                                bl4 = true;
                                break;
                            }
                            if (!bl4) {
                                n2 = -1;
                                break;
                            }
                        }
                        ++n2;
                        continue;
                    }
                    if (!bl2 || simpleNode.getElementNumber() != 6 || n4 != 2) continue;
                    n2 = -1;
                    break;
                }
                if (n2 < 2) {
                    bS.clear(n);
                    n = -1;
                }
                n = bS.nextSetBit(n + 1);
            }
        }
    }

    private static void removeBridgingRings(Lst<BS> lst, Lst<SmilesRing> lst2) {
        BS bS = new BS();
        BS bS2 = new BS();
        BS bS3 = new BS();
        SmilesAromatic.checkBridges(lst, bS2, lst, bS2, bS);
        SmilesAromatic.checkBridges(lst2, bS3, lst2, bS3, bS);
        SmilesAromatic.checkBridges(lst, bS2, lst2, bS3, bS);
        int n = lst.size();
        while (--n >= 0) {
            if (!bS2.get(n)) continue;
            lst.removeItemAt(n);
        }
        n = lst2.size();
        while (--n >= 0) {
            if (!bS3.get(n)) continue;
            lst2.removeItemAt(n);
        }
    }

    private static void checkBridges(Lst<?> lst, BS bS, Lst<?> lst2, BS bS2, BS bS3) {
        boolean bl = lst == lst2;
        int n = lst.size();
        while (--n >= 0) {
            BS bS4 = (BS)lst.get(n);
            int n2 = bl ? n + 1 : 0;
            int n3 = lst2.size();
            while (--n3 >= n2) {
                BS bS5 = (BS)lst2.get(n3);
                if (bS5.equals(bS4)) continue;
                bS3.clearAll();
                bS3.or(bS4);
                bS3.and(bS5);
                int n4 = bS3.cardinality();
                if (n4 <= 2) continue;
                bS.set(n);
                bS2.set(n3);
            }
        }
    }

    private static void checkFusedRings(Lst<SmilesRing> lst, int[] nArray, Lst<BS> lst2) {
        int n;
        SmilesRing smilesRing;
        Hashtable<String, SmilesRingSet> hashtable = new Hashtable<String, SmilesRingSet>();
        int n2 = lst.size();
        while (--n2 >= 0) {
            SmilesRingSet smilesRingSet;
            smilesRing = (SmilesRing)lst.get(n2);
            Lst<Edge> lst3 = smilesRing.edges;
            n = lst3.size();
            while (--n >= 0) {
                SmilesRingSet smilesRingSet2 = SmilesRing.getSetByEdge((Edge)lst3.get(n), hashtable);
                if (smilesRingSet2 == null || smilesRingSet2 == smilesRing.set) continue;
                if (smilesRing.set != null) {
                    smilesRingSet2.addSet(smilesRing.set, hashtable);
                    continue;
                }
                smilesRingSet2.addRing(smilesRing);
            }
            if (smilesRing.set == null) {
                smilesRingSet = new SmilesRingSet();
                smilesRing.set = smilesRing.set;
            } else {
                smilesRingSet = smilesRing.set;
            }
            smilesRingSet.addRing(smilesRing);
            smilesRing.addEdges(hashtable);
        }
        int n3 = lst.size();
        while (--n3 >= 0) {
            SmilesRingSet smilesRingSet;
            smilesRing = (SmilesRing)lst.get(n3);
            if (smilesRing.isOK || (smilesRingSet = smilesRing.set) == null || smilesRingSet.isEmpty()) continue;
            if (smilesRingSet.getElectronCount(nArray) % 4 == 2) {
                n = smilesRingSet.size();
                while (--n >= 0) {
                    smilesRing = (SmilesRing)smilesRingSet.get(n);
                    if (smilesRing.isOK) continue;
                    lst2.addLast(smilesRing);
                }
            }
            smilesRingSet.clear();
        }
    }
}

