/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.JmolNMRInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.Model;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class NMRCalculation
implements JmolNMRInterface {
    private static final int MAGNETOGYRIC_RATIO = 1;
    private static final int QUADRUPOLE_MOMENT = 2;
    private static final double e_charge = 1.60217646E-19;
    private static final double h_planck = 6.62606957E-34;
    private static final double h_bar_planck = 1.0545717253362894E-34;
    private static final double DIPOLAR_FACTOR = 1054.5717253362893;
    private static final double J_FACTOR = 0.0167840302932219;
    private static final double Q_FACTOR = 2.349647144641375E8;
    private Viewer vwr;
    private Map<String, double[]> isotopeData;
    private static final String resource = "nmr_data.txt";
    private Map<String, Float> shiftRefsPPM = new Hashtable<String, Float>();

    @Override
    public JmolNMRInterface setViewer(Viewer viewer) {
        this.vwr = viewer;
        this.getData();
        return this;
    }

    @Override
    public float getQuadrupolarConstant(Tensor tensor) {
        if (tensor == null) {
            return 0.0f;
        }
        Atom atom = this.vwr.ms.at[tensor.atomIndex1];
        return (float)(this.getIsotopeData(atom, 2) * (double)tensor.eigenValues[2] * 2.349647144641375E8);
    }

    private Lst<Tensor> getInteractionTensorList(String string, BS bS) {
        if (string != null) {
            string = string.toLowerCase();
        }
        BS bS2 = this.vwr.ms.getModelBS(bS, false);
        BS bS3 = this.getAtomSiteBS(bS);
        int n = bS3.cardinality() == 1 ? bS3.nextSetBit(0) : -1;
        Lst<Tensor> lst = new Lst<Tensor>();
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            Lst lst2 = (Lst)this.vwr.ms.getInfo(n2, "interactionTensors");
            if (lst2 != null) {
                int n3 = lst2.size();
                int n4 = 0;
                while (n4 < n3) {
                    Tensor tensor = (Tensor)lst2.get(n4);
                    if (string == null || tensor.type.equals(string) && tensor.isSelected(bS3, n)) {
                        lst.addLast(tensor);
                    }
                    ++n4;
                }
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
        return lst;
    }

    private BS getAtomSiteBS(BS bS) {
        if (bS == null) {
            return null;
        }
        BS bS2 = new BS();
        Atom[] atomArray = this.vwr.ms.at;
        Model[] modelArray = this.vwr.ms.am;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (bS.get(n)) {
                Atom atom = atomArray[n];
                bS2.set(modelArray[atom.mi].firstAtomIndex - 1 + atom.atomSite);
            }
            n = bS.nextSetBit(n + 1);
        }
        return bS2;
    }

    @Override
    public BS getUniqueTensorSet(BS bS) {
        BS bS2 = new BS();
        Atom[] atomArray = this.vwr.ms.at;
        int n = this.vwr.ms.mc;
        while (--n >= 0) {
            BS bS3 = this.vwr.getModelUndeletedAtomsBitSet(n);
            bS3.and(bS);
            if (this.vwr.ms.getUnitCell(n) == null) continue;
            int n2 = bS3.nextSetBit(0);
            while (n2 >= 0) {
                if (atomArray[n2].atomSite != atomArray[n2].i + 1) {
                    bS3.clear(n2);
                }
                n2 = bS3.nextSetBit(n2 + 1);
            }
            bS2.or(bS3);
            n2 = bS3.nextSetBit(0);
            while (n2 >= 0) {
                Object[] objectArray = atomArray[n2].getTensors();
                if (objectArray != null) {
                    int n3 = objectArray.length;
                    while (--n3 >= 0) {
                        Tensor tensor = (Tensor)objectArray[n3];
                        if (tensor == null) continue;
                        int n4 = bS3.nextSetBit(n2 + 1);
                        while (n4 >= 0) {
                            Object[] objectArray2 = atomArray[n4].getTensors();
                            if (objectArray2 != null) {
                                int n5 = objectArray2.length;
                                while (--n5 >= 0) {
                                    if (!tensor.isEquiv((Tensor)objectArray2[n5])) continue;
                                    bS3.clear(n4);
                                    bS2.clear(n4);
                                    break;
                                }
                            }
                            n4 = bS3.nextSetBit(n4 + 1);
                        }
                    }
                }
                n2 = bS3.nextSetBit(n2 + 1);
            }
        }
        return bS2;
    }

    public float getJCouplingHz(Atom atom, Atom atom2, String string, Tensor tensor) {
        return this.getIsoOrAnisoHz(true, atom, atom2, string, tensor);
    }

    @Override
    public float getIsoOrAnisoHz(boolean bl, Atom atom, Atom atom2, String string, Tensor tensor) {
        if (tensor == null) {
            if ((string = this.getISCtype(atom, string)) == null || atom.mi != atom2.mi) {
                return 0.0f;
            }
            BS bS = new BS();
            bS.set(atom.i);
            bS.set(atom2.i);
            Lst<Tensor> lst = this.getInteractionTensorList(string, bS);
            if (lst.size() == 0) {
                return Float.NaN;
            }
            tensor = (Tensor)lst.get(0);
        } else {
            atom = this.vwr.ms.at[tensor.atomIndex1];
            atom2 = this.vwr.ms.at[tensor.atomIndex2];
        }
        return (float)(this.getIsotopeData(atom, 1) * this.getIsotopeData(atom2, 1) * (double)(bl ? tensor.isotropy() : tensor.anisotropy()) * 0.0167840302932219);
    }

    private String getISCtype(Atom atom, String string) {
        Lst lst = (Lst)this.vwr.ms.getInfo(atom.mi, "interactionTensors");
        if (lst == null) {
            return null;
        }
        string = string == null ? "" : string.toLowerCase();
        int n = -1;
        n = string.indexOf("_hz");
        if (n >= 0 || (n = string.indexOf("_khz")) >= 0 || (n = string.indexOf("hz")) >= 0 || (n = string.indexOf("khz")) >= 0) {
            string = string.substring(0, n);
        }
        if (string.length() == 0) {
            string = "isc";
        }
        return string;
    }

    @Override
    public float getDipolarConstantHz(Atom atom, Atom atom2) {
        float f;
        if (Logger.debugging) {
            Logger.debug(atom + " g=" + this.getIsotopeData(atom, 1) + "; " + atom2 + " g=" + this.getIsotopeData(atom2, 1));
        }
        return (f = (float)(-this.getIsotopeData(atom, 1) * this.getIsotopeData(atom2, 1) / Math.pow(atom.distance(atom2), 3.0) * 1054.5717253362893)) == 0.0f || atom == atom2 ? Float.NaN : f;
    }

    @Override
    public float getDipolarCouplingHz(Atom atom, Atom atom2, V3 v3) {
        V3 v32 = V3.newVsub(atom2, atom);
        double d = v32.length();
        double d2 = (double)v32.dot(v3) / d / (double)v3.length();
        return (float)((double)this.getDipolarConstantHz(atom, atom2) * (3.0 * d2 - 1.0) / 2.0);
    }

    private double getIsotopeData(Atom atom, int n) {
        int n2 = atom.getIsotopeNumber();
        String string = atom.getElementSymbolIso(false);
        double[] dArray = this.isotopeData.get(n2 == 0 ? string : n2 + string);
        return dArray == null ? 0.0 : dArray[n];
    }

    private void getData() {
        BufferedReader bufferedReader = null;
        try {
            try {
                String string;
                boolean bl = Logger.debugging;
                bufferedReader = FileManager.getBufferedReaderForResource(this.vwr, this, "org/jmol/quantum/", resource);
                this.isotopeData = new Hashtable<String, double[]>();
                while ((string = bufferedReader.readLine()) != null) {
                    if (bl) {
                        Logger.info(string);
                    }
                    if (string.indexOf("#") >= 0) continue;
                    String[] stringArray = PT.getTokens(string);
                    String string2 = stringArray[0];
                    String string3 = String.valueOf(stringArray[2]) + string2;
                    if (bl) {
                        Logger.info(String.valueOf(string2) + " default isotope " + string3);
                    }
                    int n = 3;
                    while (n < stringArray.length) {
                        int n2 = Integer.parseInt(stringArray[n]);
                        String string4 = String.valueOf(n2) + string2;
                        double[] dArray = new double[]{n2, Double.parseDouble(stringArray[n + 1]), Double.parseDouble(stringArray[n + 2])};
                        if (bl) {
                            Logger.info(String.valueOf(string4) + "  " + Escape.eAD(dArray));
                        }
                        this.isotopeData.put(string4, dArray);
                        n += 3;
                    }
                    double[] dArray = this.isotopeData.get(string3);
                    if (dArray == null) {
                        Logger.error("Cannot find default NMR data in nmr_data.txt for " + string3);
                        throw new NullPointerException();
                    }
                    dArray[0] = -dArray[0];
                    this.isotopeData.put(string2, dArray);
                }
            }
            catch (Exception exception) {
                Logger.error("Exception " + exception.toString() + " reading " + resource);
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Object getInfo(String string) {
        if (string.equals("all")) {
            Hashtable<String, Map<String, Object>> hashtable = new Hashtable<String, Map<String, Object>>();
            hashtable.put("isotopes", this.isotopeData);
            hashtable.put("shiftRefsPPM", this.shiftRefsPPM);
            return hashtable;
        }
        if (PT.isDigit(string.charAt(0))) {
            return this.isotopeData.get(string);
        }
        Lst<double[]> lst = new Lst<double[]>();
        for (Map.Entry<String, double[]> entry : this.isotopeData.entrySet()) {
            String string2 = entry.getKey();
            if (!PT.isDigit(string2.charAt(0)) || !string2.endsWith(string)) continue;
            lst.addLast(entry.getValue());
        }
        return lst;
    }

    @Override
    public float getChemicalShift(Atom atom) {
        float f = this.getMagneticShielding(atom);
        if (Float.isNaN(f)) {
            return f;
        }
        Float f2 = this.shiftRefsPPM.get(atom.getElementSymbol());
        return (f2 == null ? 0.0f : f2.floatValue()) - f;
    }

    @Override
    public float getMagneticShielding(Atom atom) {
        Tensor tensor = this.vwr.ms.getAtomTensor(atom.i, "ms");
        return tensor == null ? Float.NaN : tensor.isotropy();
    }

    @Override
    public boolean getState(SB sB) {
        if (this.shiftRefsPPM.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Float> entry : this.shiftRefsPPM.entrySet()) {
            sB.append("  set shift_").append(entry.getKey()).append(" ").appendO(entry.getValue()).append("\n");
        }
        return true;
    }

    @Override
    public boolean setChemicalShiftReference(String string, float f) {
        if (string == null) {
            this.shiftRefsPPM.clear();
            return false;
        }
        string = String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
        this.shiftRefsPPM.put(string, Float.valueOf(f));
        return true;
    }

    @Override
    public Lst<Object> getTensorInfo(String string, String string2, BS bS) {
        int n;
        boolean bl;
        boolean bl2;
        if ("".equals(string)) {
            string = null;
        }
        string2 = string2 == null ? ";all." : ";" + string2 + ".";
        Lst<Object> lst = new Lst<Object>();
        if (";dc.".equals(string2)) {
            Atom[] atomArray = this.vwr.ms.at;
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                int n3 = bS.nextSetBit(n2 + 1);
                while (n3 >= 0) {
                    Lst<Number> lst2 = new Lst<Number>();
                    lst2.addLast(atomArray[n2].i);
                    lst2.addLast(atomArray[n3].i);
                    lst2.addLast(Float.valueOf(this.getDipolarConstantHz(atomArray[n2], atomArray[n3])));
                    lst.addLast(lst2);
                    n3 = bS.nextSetBit(n3 + 1);
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
            return lst;
        }
        if (string == null || string.startsWith("isc")) {
            bl2 = string2.equals(";j.");
            bl = string2.equals(";eta.");
            Lst<Tensor> lst3 = this.getInteractionTensorList(string, bS);
            int n4 = lst3 == null ? 0 : lst3.size();
            n = 0;
            while (n < n4) {
                Tensor tensor = (Tensor)lst3.get(n);
                Lst<Object> lst4 = new Lst<Object>();
                lst4.addLast(Integer.valueOf(tensor.atomIndex1));
                lst4.addLast(Integer.valueOf(tensor.atomIndex2));
                lst4.addLast(bl || bl2 ? Float.valueOf(this.getIsoOrAnisoHz(bl2, null, null, null, tensor)) : tensor.getInfo(string2));
                lst.addLast(lst4);
                ++n;
            }
            if (string != null) {
                return lst;
            }
        }
        bl2 = string != null && string.startsWith("efg") && string2.equals(";chi.");
        bl = bl2 || Tensor.isFloatInfo(string2);
        int n5 = bS.nextSetBit(0);
        while (n5 >= 0) {
            Object object;
            if (string == null) {
                object = this.vwr.ms.getAtomTensorList(n5);
                if (object != null) {
                    n = 0;
                    while (n < ((Object[])object).length) {
                        lst.addLast(((Tensor)object[n]).getInfo(string2));
                        ++n;
                    }
                }
            } else {
                object = this.vwr.ms.getAtomTensor(n5, string);
                lst.addLast(object == null ? (bl ? Float.valueOf(0.0f) : "") : (bl2 ? Float.valueOf(this.getQuadrupolarConstant((Tensor)object)) : ((Tensor)object).getInfo(string2)));
            }
            n5 = bS.nextSetBit(n5 + 1);
        }
        return lst;
    }

    @Override
    public Map<String, Integer> getMinDistances(MeasurementData measurementData) {
        BS bS = (BS)measurementData.points.get(0);
        int n = bS.cardinality();
        if (n == 0 || !(measurementData.points.get(1) instanceof BS)) {
            return null;
        }
        BS bS2 = (BS)measurementData.points.get(1);
        int n2 = bS2.cardinality();
        if (n < 2 && n2 < 2) {
            return null;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Atom[] atomArray = this.vwr.ms.at;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            Atom atom = atomArray[n3];
            String string = atom.getAtomName();
            int n4 = bS2.nextSetBit(0);
            while (n4 >= 0) {
                Atom atom2 = atomArray[n4];
                int n5 = (int)(atom2.distanceSquared(atom) * 100.0f);
                if (n5 != 0) {
                    String string2 = atom2.getAtomName();
                    String string3 = string.compareTo(string2) < 0 ? String.valueOf(string) + string2 : String.valueOf(string2) + string;
                    Integer n6 = (Integer)hashtable.get(string3);
                    if (n6 == null) {
                        n6 = n5;
                        hashtable.put(string3, n6);
                    } else if (n5 < n6) {
                        hashtable.put(string3, n5);
                    }
                }
                n4 = bS2.nextSetBit(n4 + 1);
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        return hashtable;
    }
}

