/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.FFParam;

class UFFVDWCalc
extends Calculation {
    UFFVDWCalc() {
    }

    @Override
    void setData(Lst<Object[]> lst, int n, int n2, double d) {
        this.a = this.calcs.minAtoms[n];
        this.b = this.calcs.minAtoms[n2];
        FFParam fFParam = (FFParam)this.calcs.getParameter(this.a.sType);
        FFParam fFParam2 = (FFParam)this.calcs.getParameter(this.b.sType);
        double d2 = fFParam.dVal[2];
        double d3 = fFParam.dVal[3];
        if (fFParam2 == null || fFParam2.dVal == null) {
            System.out.println("OHOH");
        }
        double d4 = fFParam2.dVal[2];
        double d5 = fFParam2.dVal[3];
        double d6 = 4.1868 * Math.sqrt(d3 * d5);
        double d7 = Math.sqrt(d2 * d4);
        lst.addLast(new Object[]{new int[]{n, n2}, new double[]{d7, d6}});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        double d = this.dData[0];
        double d2 = this.dData[1];
        this.calcs.setPairVariables(this);
        double d3 = d / this.rab;
        double d4 = d3 * d3 * d3;
        d4 *= d4;
        this.energy = d2 * d4 * (d4 - 2.0);
        if (this.calcs.gradients) {
            this.dE = d2 * 12.0 * (1.0 - d4) * d4 * d3 / d;
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(5, this));
        }
        return this.energy;
    }
}

