/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.script.SV;

public class JSONWriter {
    protected OC oc;
    protected int indent = 0;
    private Map<String, String> modifiedKeys;
    private boolean writeNullAsString = false;
    private static final String SPACES = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

    public void setModifyKeys(Map<String, String> map) {
        this.modifiedKeys = map;
    }

    public void setWriteNullAsString(boolean bl) {
        this.writeNullAsString = bl;
    }

    protected OC append(String string) {
        if (string != null) {
            this.oc.append(SPACES.substring(0, Math.min(this.indent, SPACES.length()))).append(string);
        }
        return this.oc;
    }

    public void setStream(OutputStream outputStream) {
        this.oc = new OC().setParams(null, null, true, outputStream);
    }

    public boolean closeStream() {
        this.oc.closeChannel();
        return true;
    }

    public void writeObject(Object object) {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof Map) {
            this.writeMap((Map)object);
        } else if (object instanceof List) {
            this.writeList((List)object);
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Number) {
            this.writeNumber((Number)object);
        } else if (object.getClass().isArray()) {
            this.writeArray(object);
        } else if (object instanceof SV) {
            this.append(((SV)object).toJSON());
        } else {
            this.writeString(object.toString());
        }
    }

    public void writeNull() {
        this.oc.append(this.writeNullAsString ? "\"null\"" : "null");
    }

    public void writeNumber(Number number) {
        String string = number.toString();
        if (string.equals("NaN")) {
            this.writeString(string);
        } else {
            this.oc.append(string);
        }
    }

    public void writeBoolean(Boolean bl) {
        this.oc.append(bl.toString());
    }

    public void writeString(String string) {
        this.oc.append(PT.esc(string));
    }

    public void writeString(String string, SB sB) {
        sB.append(PT.esc(string));
    }

    public void writeMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            this.append("{}");
            return;
        }
        this.mapOpen();
        String string = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            Object object = this.getAndCheckValue(map, string2);
            if (object == null) continue;
            this.oc.append(string);
            this.mapAddKeyValue(string2, object, null);
            string = ",\n";
        }
        this.mapClose();
    }

    protected Object getAndCheckValue(Map<String, Object> map, String string) {
        return map.get(string);
    }

    public void mapOpen() {
        this.oc.append("{\n");
        ++this.indent;
    }

    public void mapClose() {
        --this.indent;
        this.oc.append("\n");
        this.append("}");
    }

    public void mapAddKey(String string) {
        this.append("");
        if (this.modifiedKeys != null && this.modifiedKeys.containsKey(string)) {
            string = this.modifiedKeys.get(string);
        }
        this.writeString(string);
        this.oc.append(":");
    }

    public void mapAddKeyValue(String string, Object object, String string2) {
        this.mapAddKey(string);
        this.writeObject(object);
        if (string2 != null) {
            this.oc.append(string2);
        }
    }

    public void mapAddKeyValueRaw(String string, Object object, String string2) {
        this.mapAddKey(string);
        this.oc.append(object.toString());
        if (string2 != null) {
            this.oc.append(string2);
        }
    }

    public void mapAddMapAllExcept(String string, Map<String, Object> map, String string2) {
        this.mapAddKey(string);
        this.mapOpen();
        String string3 = "";
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string4 = entry.getKey();
            if (PT.isOneOf(string4, string2)) continue;
            this.oc.append(string3);
            this.mapAddKeyValue(string4, entry.getValue(), null);
            string3 = ",\n";
        }
        this.mapClose();
    }

    public void writeList(List<Object> list) {
        int n = list.size();
        this.arrayOpen(false);
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                this.oc.append(",");
            }
            this.arrayAdd(list.get(n2));
            ++n2;
        }
        this.arrayClose(false);
    }

    public void writeArray(Object object) {
        this.arrayOpen(false);
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                this.oc.append(",");
            }
            this.arrayAdd(Array.get(object, n2));
            ++n2;
        }
        this.arrayClose(false);
    }

    public void arrayOpen(boolean bl) {
        this.oc.append("[");
        if (bl) {
            ++this.indent;
        }
    }

    public void arrayAdd(Object object) {
        this.writeObject(object instanceof Float && ((Float)object).isNaN() || object instanceof Double && ((Double)object).isNaN() ? "NaN" : object);
    }

    public void arrayClose(boolean bl) {
        if (bl) {
            --this.indent;
            this.append("");
        }
        this.oc.append("]");
    }
}

