/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMeasure;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

public class SmilesParser {
    private Map<Integer, SmilesBond> connections = new Hashtable<Integer, SmilesBond>();
    private Map<String, SmilesMeasure> htMeasures = new Hashtable<String, SmilesMeasure>();
    private int flags;
    private boolean isSmarts;
    private boolean isBioSequence;
    private char bioType = '\u0000';
    private int braceCount;
    private int branchLevel;
    private int componentCount;
    private int componentParenCount;
    private boolean ignoreStereochemistry;
    private boolean bondDirectionPaired = true;
    private boolean isTarget;

    static SmilesSearch newSearch(String string, boolean bl, boolean bl2) throws InvalidSmilesException {
        return new SmilesParser(bl, bl2).parse(string);
    }

    SmilesParser(boolean bl, boolean bl2) {
        this.isSmarts = bl;
        this.isTarget = bl2;
    }

    SmilesSearch parse(String string) throws InvalidSmilesException {
        if (string == null) {
            throw new InvalidSmilesException("expression must not be null");
        }
        SmilesSearch smilesSearch = new SmilesSearch();
        if (string.indexOf("$(select") >= 0) {
            string = this.parseNested(smilesSearch, string, "select");
        }
        int[] nArray = new int[1];
        string = SmilesParser.extractFlags(string, nArray);
        this.flags = nArray[0];
        this.ignoreStereochemistry = (this.flags & 0x20) == 32;
        smilesSearch.setFlags(this.flags);
        if (string.indexOf("$") >= 0) {
            string = this.parseVariables(string);
        }
        if (this.isSmarts && string.indexOf("[$") >= 0) {
            string = this.parseVariableLength(string);
        }
        if (string.indexOf("||") < 0) {
            return this.getSubsearch(smilesSearch, string, this.flags);
        }
        String[] stringArray = PT.split(string, "||");
        String string2 = "";
        smilesSearch.subSearches = new SmilesSearch[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string3 = "|" + stringArray[n] + "|";
            if (string2.indexOf(string3) < 0) {
                smilesSearch.subSearches[n] = this.getSubsearch(smilesSearch, stringArray[n], this.flags);
                string2 = String.valueOf(string2) + string3;
            }
            ++n;
        }
        return smilesSearch;
    }

    private String parseVariableLength(String string) throws InvalidSmilesException {
        SB sB = new SB();
        int n = string.length() - 1;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            switch (string.charAt(n3)) {
                case '(': {
                    ++n2;
                    break;
                }
                case ')': {
                    --n2;
                    break;
                }
                case '|': {
                    if (n2 <= 0) break;
                    bl = true;
                    if (string.charAt(n3 + 1) != '|') break;
                    string = String.valueOf(string.substring(0, n3)) + string.substring(n3 + 1);
                    --n;
                }
            }
            ++n3;
        }
        if (string.indexOf("||") >= 0) {
            String[] stringArray = PT.split(string, "||");
            int n4 = 0;
            while (n4 < stringArray.length) {
                sB.append("||").append(this.parseVariableLength(stringArray[n4]));
                ++n4;
            }
        } else {
            n3 = -1;
            int[] nArray = new int[1];
            boolean bl2 = true;
            String string2 = null;
            while ((n3 = string.indexOf("[$", n3 + 1)) >= 0) {
                int n5;
                int n6;
                int n7 = n3;
                int n8 = Integer.MIN_VALUE;
                int n9 = Integer.MIN_VALUE;
                n3 = SmilesParser.getDigits(string, n3 + 2, nArray);
                n8 = nArray[0];
                if (n8 != Integer.MIN_VALUE && SmilesParser.getChar(string, n3) == '-') {
                    n3 = SmilesParser.getDigits(string, n3 + 1, nArray);
                    n9 = nArray[0];
                }
                if (SmilesParser.getChar(string, n3) != '(' || !(string2 = SmilesParser.getSubPattern(string, n7, '[')).endsWith(")")) continue;
                int n10 = n7 + string2.length() + 2;
                String string3 = SmilesParser.getSubPattern(string, n3, '(');
                int n11 = n3;
                string2 = SmilesParser.getSubPattern(string, n3, '[');
                n3 += 1 + string3.length();
                if (string3.indexOf(58) >= 0 && string3.indexOf(124) < 0) {
                    n6 = 0;
                    int n12 = string3.length();
                    n5 = -1;
                    int n13 = 0;
                    while (n13 < n12) {
                        switch (string3.charAt(n13)) {
                            case '(': 
                            case '[': {
                                ++n6;
                                break;
                            }
                            case ')': 
                            case ']': {
                                --n6;
                                break;
                            }
                            case '.': {
                                if (n5 < 0 || n6 != 0) break;
                                n12 = n13;
                                break;
                            }
                            case ':': {
                                if (n5 >= 0 || n6 != 0) break;
                                n5 = n13;
                            }
                        }
                        ++n13;
                    }
                    if (n5 > 0) {
                        string3 = String.valueOf(string3.substring(0, n5)) + "(" + string3.substring(n5, n12) + ")" + string3.substring(n12);
                    }
                }
                if (n8 == Integer.MIN_VALUE) {
                    n6 = string3.indexOf("|");
                    if (n6 < 0) continue;
                    return this.parseVariableLength(String.valueOf(string.substring(0, n7)) + "[$1" + string.substring(n11, n11 + n6 + 1) + ")]" + string.substring(n10) + "||" + string.substring(0, n7) + "[$1(" + string.substring(n11 + n6 + 2) + string.substring(n10));
                }
                if (n9 == Integer.MIN_VALUE) {
                    n9 = n8;
                }
                if (string3.indexOf("|") >= 0) {
                    string3 = "[$(" + string3 + ")]";
                }
                n6 = n8;
                while (n6 <= n9) {
                    SB sB2 = new SB();
                    sB2.append("||").append(string.substring(0, n7));
                    n5 = 0;
                    while (n5 < n6) {
                        sB2.append(string3);
                        ++n5;
                    }
                    sB2.append(string.substring(n10));
                    sB.appendSB(sB2);
                    ++n6;
                }
            }
            if (!bl2) {
                throw new InvalidSmilesException("bad variable expression: " + string2);
            }
        }
        return bl ? this.parseVariableLength(sB.substring(2)) : (sB.length() < 2 ? string : sB.substring(2));
    }

    SmilesSearch getSubsearch(SmilesSearch smilesSearch, String string, int n) throws InvalidSmilesException {
        this.htMeasures = new Hashtable<String, SmilesMeasure>();
        SmilesSearch smilesSearch2 = new SmilesSearch();
        smilesSearch2.setTop(smilesSearch);
        smilesSearch2.isSmarts = this.isSmarts;
        smilesSearch2.pattern = string;
        smilesSearch2.setFlags(n);
        if (string.indexOf("$(") >= 0) {
            string = this.parseNested(smilesSearch2, string, "");
        }
        this.parseSmiles(smilesSearch2, string, null, false);
        if (this.braceCount != 0) {
            throw new InvalidSmilesException("unmatched '{'");
        }
        if (!this.connections.isEmpty()) {
            throw new InvalidSmilesException("Open connection");
        }
        smilesSearch2.set();
        if (this.isSmarts) {
            int n2 = smilesSearch2.ac;
            while (--n2 >= 0) {
                this.checkNested(smilesSearch2, smilesSearch2.patternAtoms[n2], n);
            }
        } else if (!this.isBioSequence) {
            smilesSearch2.elementCounts[1] = smilesSearch2.getMissingHydrogenCount();
        }
        if (!this.ignoreStereochemistry && !this.isTarget) {
            this.fixChirality(smilesSearch2);
        }
        return smilesSearch2;
    }

    private void checkNested(SmilesSearch smilesSearch, SmilesAtom smilesAtom, int n) throws InvalidSmilesException {
        Object object;
        if (smilesAtom.iNested > 0 && (object = smilesSearch.getNested(smilesAtom.iNested)) instanceof String) {
            String string = (String)object;
            if (string.startsWith("select")) {
                return;
            }
            if (string.charAt(0) != '~' && smilesAtom.bioType != '\u0000') {
                string = "~" + smilesAtom.bioType + "~" + string;
            }
            SmilesSearch smilesSearch2 = this.getSubsearch(smilesSearch, string, n);
            if (smilesSearch2.ac > 0 && smilesSearch2.patternAtoms[0].selected) {
                smilesAtom.selected = true;
            }
            smilesSearch.setNested(smilesAtom.iNested, smilesSearch2);
        }
        int n2 = 0;
        while (n2 < smilesAtom.nSubAtoms) {
            this.checkNested(smilesSearch, smilesAtom.subAtoms[n2], n);
            ++n2;
        }
    }

    private void fixChirality(SmilesSearch smilesSearch) throws InvalidSmilesException {
        int n = smilesSearch.ac;
        while (--n >= 0) {
            SmilesAtom smilesAtom = smilesSearch.patternAtoms[n];
            if (smilesAtom.stereo == null) continue;
            smilesAtom.stereo.fixStereo(smilesAtom);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseSmiles(SmilesSearch var1_1, String var2_2, SmilesAtom var3_3, boolean var4_4) throws InvalidSmilesException {
        var5_5 = new int[1];
        var6_6 = 0;
        var8_7 = null;
        var9_8 = false;
        var10_9 = false;
        block16: while (var2_2 != null && var2_2.length() != 0) {
            block47: {
                var11_11 = 0;
                if (var3_3 == null) {
                    var11_11 = this.checkBioType(var2_2, 0);
                    if (var11_11 == var2_2.length()) {
                        var2_2 = String.valueOf(var2_2) + "*";
                    }
                    if (this.isBioSequence) {
                        var1_1.top.needAromatic = false;
                        var1_1.needAromatic = false;
                    }
                }
                if (var12_12 = this.checkBrace(var1_1, var7_10 = SmilesParser.getChar(var2_2, var11_11), '{')) {
                    var7_10 = SmilesParser.getChar(var2_2, ++var11_11);
                }
                if (var7_10 == '(') {
                    var13_13 = SmilesParser.getSubPattern(var2_2, var11_11, '(');
                    v0 = var14_15 = SmilesParser.getChar(var2_2, var11_11 + 1) == '.';
                    if (var3_3 == null) {
                        if (var14_15 || !this.isSmarts) {
                            throw new InvalidSmilesException("No previous atom for measure");
                        }
                        var1_1.haveComponents = true;
                        do {
                            ++this.componentCount;
                            ++this.componentParenCount;
                        } while ((var7_10 = SmilesParser.getChar(var2_2 = var2_2.substring(1), 0)) == '(');
                        if (!var12_12 && (var12_12 = this.checkBrace(var1_1, var7_10, '{'))) {
                            var2_2 = var2_2.substring(1);
                            var7_10 = SmilesParser.getChar(var2_2, 0);
                        }
                    } else {
                        var10_9 = false;
                        var9_8 = false;
                        if (var13_13.startsWith(".")) {
                            this.parseMeasure(var1_1, var13_13.substring(1), var3_3);
                            var9_8 = true;
                        } else if (var13_13.length() == 0 && this.isBioSequence) {
                            var3_3.notCrossLinked = true;
                        } else {
                            ++this.branchLevel;
                            this.parseSmiles(var1_1, var13_13, var3_3, true);
                            var10_9 = true;
                            --this.branchLevel;
                        }
                        var11_11 = var13_13.length() + 2;
                        var7_10 = SmilesParser.getChar(var2_2, var11_11);
                        if (var7_10 == '}' && this.checkBrace(var1_1, var7_10, '}')) {
                            ++var11_11;
                        }
                        var7_10 = '\u0000';
                    }
                }
                if (var7_10 == '\u0000') break block47;
                var6_6 = var11_11;
                block18: while (var7_10 != '\u0000') {
                    switch (SmilesBond.isBondType(var7_10, this.isSmarts, this.isBioSequence)) {
                        case 1: {
                            ** GOTO lbl61
                        }
                        case 0: {
                            break block18;
                        }
                        case -1: {
                            if ((!PT.isDigit(SmilesParser.getChar(var2_2, ++var11_11)) || var11_11++ <= 0 || PT.isDigit(SmilesParser.getChar(var2_2, var11_11++))) && (var7_10 = SmilesParser.getChar(var2_2, var11_11)) == '-') continue block18;
                            throw new InvalidSmilesException("malformed atropisomerism bond ^nn-  or ^^nn-");
                        }
lbl61:
                        // 2 sources

                        default: {
                            var7_10 = SmilesParser.getChar(var2_2, ++var11_11);
                        }
                    }
                }
                var7_10 = SmilesParser.getChar(var2_2, var11_11);
                if (var7_10 == ')') {
                    var7_10 = SmilesParser.getChar(var2_2, ++var11_11);
                    switch (var7_10) {
                        case '\u0000': 
                        case ')': 
                        case '.': {
                            var2_2 = var2_2.substring(var11_11);
                            --this.componentParenCount;
                            if (this.componentParenCount >= 0) continue block16;
                        }
                        default: {
                            throw new InvalidSmilesException("invalid continuation after component grouping (SMARTS).(SMARTS)");
                        }
                    }
                }
                var8_7 = this.parseBond(var1_1, null, var2_2.substring(var6_6, var11_11), null, var3_3, false, var4_4, var11_11 - var6_6, var5_5);
                if (var12_12 && var8_7.order != -1) {
                    var11_11 = var6_6;
                    var7_10 = SmilesParser.getChar(var2_2, var11_11);
                }
                if (this.checkBrace(var1_1, var7_10, '{')) {
                    var7_10 = SmilesParser.getChar(var2_2, ++var11_11);
                }
                switch (var7_10) {
                    case '~': {
                        if (var8_7.order != 0 || (var11_11 = this.checkBioType(var2_2, var11_11)) != var2_2.length()) break;
                        var2_2 = String.valueOf(var2_2) + "*";
                        break;
                    }
                    case '(': {
                        do {
                            ++this.componentCount;
                            ++this.componentParenCount;
                        } while ((var7_10 = SmilesParser.getChar(var2_2, ++var11_11)) == '(');
                        break;
                    }
                    case '\u0000': {
                        if (var8_7.order != 0) break;
                        return;
                    }
                }
                var13_14 = PT.isDigit(var7_10) != false || var7_10 == '%';
                v1 = var14_15 = var13_14 == false && (var7_10 == '_' || var7_10 == '[' || var7_10 == '*' || PT.isLetter(var7_10) != false);
                if (var13_14) {
                    if (var9_8 || var10_9) {
                        throw new InvalidSmilesException("connection number must immediately follow its connecting atom");
                    }
                    var11_11 = SmilesParser.getRingNumber(var2_2, var11_11, var7_10, var5_5);
                    var15_16 = var5_5[0];
                    this.parseConnection(var1_1, var15_16, var3_3, var8_7);
                    var8_7 = null;
                } else if (var14_15) {
                    var10_9 = false;
                    var9_8 = false;
                    switch (var7_10) {
                        case '[': 
                        case '_': {
                            var15_17 = SmilesParser.getSubPattern(var2_2, var11_11, var7_10);
                            var11_11 += var15_17.length() + (var7_10 == '[' ? 2 : 0);
                            if (this.isBioSequence && var7_10 == '[' && var15_17.indexOf(".") < 0 && var15_17.indexOf("_") < 0) {
                                var15_17 = String.valueOf(var15_17) + ".0";
                            }
                            var3_3 = this.parseAtom(var1_1, null, var15_17, var3_3, var8_7, var7_10 == '[', false, var4_4);
                            var3_3.hasSubpattern = true;
                            if (var8_7.order != -1 && var8_7.order != 0) {
                                this.setBondAtom(var8_7, null, var3_3, var1_1);
                            }
                            var8_7 = null;
                            break;
                        }
                        default: {
                            v2 = var16_18 = this.isBioSequence == false && PT.isUpperCase(var7_10) != false ? SmilesParser.getChar(var2_2, var11_11 + 1) : '\u0000';
                            if (!(var7_10 == 'X' && var16_18 == 'x' || PT.isLowerCase(var16_18) && Elements.elementNumberFromSymbol(var2_2.substring(var11_11, var11_11 + 2), true) != 0)) {
                                var16_18 = '\u0000';
                            }
                            if (var16_18 != '\u0000' && "NA CA BA PA SC AC".indexOf(var2_2.substring(var11_11, var11_11 + 2)) >= 0) {
                                var16_18 = '\u0000';
                            }
                            var17_19 = PT.isUpperCase(var7_10) != false && PT.isLowerCase(var16_18) != false ? 2 : 1;
                            var3_3 = this.parseAtom(var1_1, null, var2_2.substring(var11_11, var11_11 + var17_19), var3_3, var8_7, false, false, var4_4);
                            var8_7 = null;
                            var11_11 += var17_19;
                            break;
                        }
                    }
                } else {
                    throw new InvalidSmilesException("Unexpected character: " + SmilesParser.getChar(var2_2, var11_11));
                }
                var7_10 = SmilesParser.getChar(var2_2, var11_11);
                if (var7_10 == '}' && this.checkBrace(var1_1, var7_10, '}')) {
                    ++var11_11;
                }
            }
            var2_2 = var2_2.substring(var11_11);
            var4_4 = false;
        }
    }

    private void parseConnection(SmilesSearch smilesSearch, int n, SmilesAtom smilesAtom, SmilesBond smilesBond) throws InvalidSmilesException {
        Integer n2 = n;
        SmilesBond smilesBond2 = this.connections.get(n2);
        if (smilesBond2 == null) {
            this.connections.put(n2, smilesBond);
            ++smilesSearch.top.ringCount;
            return;
        }
        this.connections.remove(n2);
        switch (smilesBond.order) {
            case -1: {
                smilesBond.order = smilesBond2.order != -1 ? smilesBond2.order : (this.isSmarts || smilesAtom.isAromatic && smilesBond2.atom1.isAromatic ? 81 : 1);
                break;
            }
            case 1025: {
                smilesBond.order = 1041;
                break;
            }
            case 1041: {
                smilesBond.order = 1025;
            }
        }
        if (smilesBond2.order != -1 && smilesBond2.order != smilesBond.order || smilesAtom == smilesBond2.atom1 || smilesBond2.atom1.getBondTo(smilesAtom) != null) {
            throw new InvalidSmilesException("Bad connection type or atom");
        }
        smilesBond2.set(smilesBond);
        --smilesAtom.bondCount;
        smilesBond2.setAtom2(smilesAtom, smilesSearch);
    }

    private void setBondAtom(SmilesBond smilesBond, SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesSearch smilesSearch) {
        smilesBond.set2a(smilesAtom, smilesAtom2);
        if (smilesSearch != null && smilesBond.order == 2 && smilesBond.atom1 != null && smilesBond.atom2 != null && smilesBond.atom1.isAromatic && smilesBond.atom2.isAromatic && (this.flags & 0x200) == 0) {
            smilesSearch.setFlags(this.flags |= 0x200);
        }
    }

    static int getRingNumber(String string, int n, char c, int[] nArray) throws InvalidSmilesException {
        int n2;
        switch (c) {
            case '%': {
                if (SmilesParser.getChar(string, n + 1) == '(') {
                    String string2 = SmilesParser.getSubPattern(string, n + 1, '(');
                    SmilesParser.getDigits(string2, 0, nArray);
                    n += string2.length() + 3;
                    if (nArray[0] < 0) {
                        throw new InvalidSmilesException("Invalid number designation: " + string2);
                    }
                } else {
                    if (n + 3 <= string.length()) {
                        n = SmilesParser.getDigits(string.substring(0, n + 3), n + 1, nArray);
                    }
                    if (nArray[0] < 10) {
                        throw new InvalidSmilesException("Two digits must follow the % sign");
                    }
                }
                n2 = nArray[0];
                break;
            }
            default: {
                n2 = c - 48;
                ++n;
            }
        }
        nArray[0] = n2;
        return n;
    }

    private int checkBioType(String string, int n) {
        boolean bl = this.isBioSequence = string.charAt(n) == '~';
        if (this.isBioSequence) {
            ++n;
            this.bioType = (char)42;
            char c = SmilesParser.getChar(string, 2);
            if (c == '~' && ((c = string.charAt(1)) == '*' || PT.isLowerCase(c))) {
                this.bioType = c;
                n = 3;
            }
        }
        return n;
    }

    private void parseMeasure(SmilesSearch smilesSearch, String string, SmilesAtom smilesAtom) throws InvalidSmilesException {
        block11: {
            SmilesMeasure smilesMeasure;
            String string2;
            int n = string.indexOf(":");
            String string3 = string2 = n < 0 ? string : string.substring(0, n);
            if (n == 0) break block11;
            int n2 = string2.length();
            if (n2 == 1) {
                string2 = String.valueOf(string2) + "0";
            }
            if ((smilesMeasure = this.htMeasures.get(string2)) == null == n < 0 || n2 == 0) break block11;
            try {
                block14: {
                    block12: {
                        int n3;
                        block13: {
                            String[] stringArray;
                            boolean bl;
                            if (n <= 0) break block12;
                            int n4 = "__dat".indexOf(string2.charAt(0));
                            if (n4 < 2) break block11;
                            int[] nArray = new int[1];
                            SmilesParser.getDigits(string2, 1, nArray);
                            n3 = nArray[0];
                            string = string.substring(n + 1);
                            boolean bl2 = string.startsWith("!");
                            if (bl2) {
                                string = string.substring(1);
                            }
                            if (bl = string.startsWith("-")) {
                                string = string.substring(1);
                            }
                            string = PT.rep(string, "-", ",");
                            string = PT.rep(string, ",,", ",-");
                            if (bl) {
                                string = "-" + string;
                            }
                            if ((stringArray = PT.split(string, ",")).length % 2 == 1 || bl2 && stringArray.length != 2) break block11;
                            float[] fArray = new float[stringArray.length];
                            int n5 = stringArray.length;
                            while (--n5 >= 0) {
                                fArray[n5] = Float.parseFloat(stringArray[n5]);
                                if (Float.isNaN(fArray[n5])) break;
                            }
                            if (n5 >= 0) break block11;
                            smilesMeasure = new SmilesMeasure(smilesSearch, n3, n4, bl2, fArray);
                            smilesSearch.measures.addLast(smilesMeasure);
                            if (n3 <= 0) break block13;
                            this.htMeasures.put(string2, smilesMeasure);
                            break block14;
                        }
                        if (n3 != 0 || !Logger.debugging) break block14;
                        Logger.debug("measure created: " + smilesMeasure);
                        break block14;
                    }
                    if (smilesMeasure.addPoint(smilesAtom.index)) {
                        if (smilesMeasure.nPoints == smilesMeasure.type) {
                            this.htMeasures.remove(string2);
                            if (Logger.debugging) {
                                Logger.debug("measure created: " + smilesMeasure);
                            }
                        }
                        return;
                    }
                    break block11;
                }
                if (!smilesMeasure.addPoint(smilesAtom.index)) {
                }
            }
            catch (NumberFormatException numberFormatException) {}
            break block11;
            return;
        }
        throw new InvalidSmilesException("invalid measure: " + string);
    }

    private boolean checkBrace(SmilesSearch smilesSearch, char c, char c2) throws InvalidSmilesException {
        switch (c) {
            case '{': {
                if (c != c2) break;
                ++this.braceCount;
                smilesSearch.top.haveSelected = true;
                return true;
            }
            case '}': {
                if (c != c2 || this.braceCount <= 0) break;
                --this.braceCount;
                return true;
            }
            default: {
                return false;
            }
        }
        throw new InvalidSmilesException("Unmatched '}'");
    }

    private String parseNested(SmilesSearch smilesSearch, String string, String string2) throws InvalidSmilesException {
        int n;
        string2 = "$(" + string2;
        while ((n = string.lastIndexOf(string2)) >= 0) {
            String string3 = SmilesParser.getSubPattern(string, n + 1, '(');
            int n2 = n + string3.length() + 3;
            String string4 = string.substring(n2);
            string = string.substring(0, n);
            String string5 = "";
            if (string.endsWith("]")) {
                throw new InvalidSmilesException("$(...) must be enclosed in brackets: " + string + "$(" + string3 + ")");
            }
            if (n > 1 && string2.length() == 2 && (n2 = string.length()) > 1 && ",;&![".indexOf(string.substring(n2 - 1)) < 0) {
                string5 = "&";
            }
            if (string4.length() > 1 && ",;&!)]".indexOf(string4.charAt(0)) < 0) {
                string4 = "&" + string4;
            }
            string = String.valueOf(string) + string5 + "_" + smilesSearch.top.addNested(string3) + "_" + string4;
        }
        return string;
    }

    private String parseVariables(String string) throws InvalidSmilesException {
        String string2;
        int n;
        Lst<String> lst = new Lst<String>();
        Lst<String> lst2 = new Lst<String>();
        int n2 = 0;
        int n3 = -1;
        if (Logger.debugging) {
            Logger.info(string);
        }
        while ((n = string.indexOf("$", n2)) >= 0) {
            if (SmilesParser.getChar(string, n + 1) == '(' || (n2 = SmilesParser.skipTo(string, n, '=')) <= n + 1 || SmilesParser.getChar(string, n2 + 1) != '\"') break;
            String string3 = string.substring(n, n2);
            if (string3.lastIndexOf(36) > 0 || string3.indexOf(93) > 0) {
                throw new InvalidSmilesException("Invalid variable name: " + string3);
            }
            string2 = SmilesParser.getSubPattern(string, n2 + 1, '\"');
            lst.addLast("[" + string3 + "]");
            lst2.addLast(string2);
            n2 += string2.length() + 2;
            n2 = SmilesParser.skipTo(string, n2, ';');
            n3 = ++n2;
        }
        if (n3 < 0) {
            return string;
        }
        string = string.substring(n3);
        int n4 = lst.size();
        while (--n4 >= 0) {
            string2 = (String)lst.get(n4);
            String string4 = (String)lst2.get(n4);
            if (string4.equals(string2)) continue;
            string = PT.rep(string, string2, string4);
        }
        if (Logger.debugging) {
            Logger.info(string);
        }
        return string;
    }

    private SmilesAtom parseAtom(SmilesSearch smilesSearch, SmilesAtom smilesAtom, String string, SmilesAtom smilesAtom2, SmilesBond smilesBond, boolean bl, boolean bl2, boolean bl3) throws InvalidSmilesException {
        if (string == null || string.length() == 0) {
            throw new InvalidSmilesException("Empty atom definition");
        }
        SmilesAtom smilesAtom3 = new SmilesAtom();
        if (this.componentParenCount > 0) {
            smilesAtom3.component = this.componentCount;
        }
        if (smilesAtom == null) {
            smilesSearch.appendAtom(smilesAtom3);
        }
        boolean bl4 = true;
        if (!this.checkLogic(smilesSearch, string, smilesAtom3, null, smilesAtom2, bl2, bl3, null)) {
            int n;
            int n2;
            int[] nArray = new int[1];
            if (this.isBioSequence && string.length() == 1) {
                string = String.valueOf(string) + ".0";
            }
            char c = string.charAt(0);
            int n3 = 0;
            boolean bl5 = false;
            if (this.isSmarts && c == '!') {
                if ((c = SmilesParser.getChar(string, ++n3)) == '\u0000') {
                    throw new InvalidSmilesException("invalid '!'");
                }
                bl5 = true;
                smilesAtom3.not = true;
            }
            if ((n2 = string.indexOf(46)) >= 0) {
                smilesAtom3.isBioResidue = true;
                String string2 = string.substring(n3, n2);
                string = string.substring(n2 + 1).toUpperCase();
                n = string2.length();
                n2 = string2.indexOf("^");
                if (n2 >= 0) {
                    if (n2 == n - 2 && (c = string2.charAt(n - 1)) != '*') {
                        smilesAtom3.insCode = c;
                    }
                    string2 = string2.substring(0, n2);
                }
                if ((n2 = string2.indexOf("#")) >= 0) {
                    SmilesParser.getDigits(string2, n2 + 1, nArray);
                    smilesAtom3.residueNumber = nArray[0];
                    string2 = string2.substring(0, n2);
                }
                if (string2.length() == 0) {
                    string2 = "*";
                }
                if (string2.length() > 1) {
                    smilesAtom3.residueName = string2.toUpperCase();
                } else if (!string2.equals("*")) {
                    smilesAtom3.residueChar = string2;
                }
                string2 = string;
                n2 = string2.indexOf("#");
                if (n2 >= 0) {
                    SmilesParser.getDigits(string2, n2 + 1, nArray);
                    smilesAtom3.elementNumber = nArray[0];
                    string2 = string2.substring(0, n2);
                }
                if (string2.length() == 0) {
                    string2 = "*";
                } else if (string2.equals("0")) {
                    string2 = "\u0000";
                }
                if (string2.equals("*")) {
                    smilesAtom3.isBioAtomWild = true;
                } else {
                    smilesAtom3.setAtomName(string2);
                }
                c = '\u0000';
            }
            smilesAtom3.setBioAtom(this.bioType);
            int n4 = Integer.MIN_VALUE;
            while (c != '\u0000' && bl4) {
                smilesAtom3.setAtomName(this.isBioSequence ? "\u0000" : "");
                if (PT.isDigit(c)) {
                    n3 = SmilesParser.getDigits(string, n3, nArray);
                    n = nArray[0];
                    if (n == Integer.MIN_VALUE) {
                        throw new InvalidSmilesException("Non numeric atomic mass");
                    }
                    if (SmilesParser.getChar(string, n3) == '?') {
                        ++n3;
                        n = -n;
                    }
                    if (smilesAtom3.elementDefined) {
                        throw new InvalidSmilesException("atom mass must precede atom symbol or be separated from it with \";\"");
                    }
                    smilesAtom3.setAtomicMass(n);
                } else {
                    block0 : switch (c) {
                        case '\"': {
                            String string3 = PT.getQuotedStringAt(string, n3);
                            n3 += string3.length() + 2;
                            smilesAtom3.atomType = string3;
                            break;
                        }
                        case '_': {
                            n3 = SmilesParser.getDigits(string, n3 + 1, nArray) + 1;
                            if (nArray[0] == Integer.MIN_VALUE) {
                                throw new InvalidSmilesException("Invalid SEARCH primitive: " + string.substring(n3));
                            }
                            smilesAtom3.iNested = nArray[0];
                            if (!bl) {
                                throw new InvalidSmilesException("nesting must appear in [...]: $(" + smilesSearch.getNested(nArray[0]) + ")");
                            }
                            if (!this.isBioSequence || n3 == string.length()) break;
                            throw new InvalidSmilesException("invalid characters: " + string.substring(n3));
                        }
                        case '=': {
                            n3 = SmilesParser.getDigits(string, n3 + 1, nArray);
                            smilesAtom3.jmolIndex = nArray[0];
                            break;
                        }
                        case '#': {
                            boolean bl6 = string.charAt(n3 + 1) == '-';
                            n3 = SmilesParser.getDigits(string, n3 + (bl6 ? 2 : 1), nArray);
                            if (bl6) {
                                smilesAtom3.atomNumber = nArray[0];
                                break;
                            }
                            smilesAtom3.elementNumber = nArray[0];
                            break;
                        }
                        case '+': 
                        case '-': {
                            n3 = this.checkCharge(string, n3, smilesAtom3);
                            break;
                        }
                        case '@': {
                            if (smilesSearch.stereo == null) {
                                smilesSearch.stereo = SmilesStereo.newStereo(smilesSearch);
                            }
                            n3 = SmilesStereo.checkChirality(smilesSearch, string, n3, smilesSearch.patternAtoms[smilesAtom3.index]);
                            break;
                        }
                        case ':': {
                            ++n3;
                            n3 = SmilesParser.getDigits(string, n3, nArray);
                            if (nArray[0] == Integer.MIN_VALUE) {
                                throw new InvalidSmilesException("Invalid atom class");
                            }
                            smilesAtom3.atomClass = nArray[0];
                            break;
                        }
                        default: {
                            boolean bl7;
                            char c2 = SmilesParser.getChar(string, n3 + 1);
                            int n5 = n3 + (PT.isLowerCase(c2) && (!bl || !PT.isDigit(SmilesParser.getChar(string, n3 + 2))) ? 2 : 1);
                            String string4 = string.substring(n3 + 1, n5);
                            String string5 = String.valueOf(Character.toUpperCase(c)) + string4;
                            boolean bl8 = true;
                            boolean bl9 = bl7 = bl && PT.isLetter(c);
                            if (bl7) {
                                if (!bl5 && (bl2 ? smilesAtom : smilesAtom3).hasSymbol) {
                                    bl8 = false;
                                } else if (c == 'H') {
                                    bl8 = string.length() == 1 || !PT.isDigit(c2);
                                } else if (PT.isDigit(c2)) {
                                    bl8 = false;
                                } else if (!string5.equals("A") && !string5.equals("Xx")) {
                                    boolean bl10 = bl8 = (c != 'h' || n5 == 2) && Elements.elementNumberFromSymbol(string5, true) > 0;
                                    if (!bl8 && n5 == 2) {
                                        string4 = "";
                                        boolean bl11 = bl8 = Elements.elementNumberFromSymbol(string5 = string5.substring(0, 1), true) > 0;
                                    }
                                }
                            }
                            if (bl8) {
                                if (!((bl || this.isSmarts || this.isBioSequence || SmilesAtom.allowSmilesUnbracketed(string5)) && smilesAtom3.setSymbol(string5 = String.valueOf(c) + string4))) {
                                    throw new InvalidSmilesException("Invalid atom symbol: " + string5);
                                }
                                if (bl2) {
                                    smilesAtom.hasSymbol = true;
                                }
                                n3 += string5.length();
                                break;
                            }
                            n3 = SmilesParser.getDigits(string, n3 + 1, nArray);
                            int n6 = nArray[0];
                            switch (c) {
                                default: {
                                    throw new InvalidSmilesException("Invalid SEARCH primitive: " + string.substring(n3));
                                }
                                case 'D': {
                                    smilesAtom3.setDegree(n6 == Integer.MIN_VALUE ? 1 : n6);
                                    break block0;
                                }
                                case 'd': {
                                    smilesAtom3.setNonhydrogenDegree(n6 == Integer.MIN_VALUE ? 1 : n6);
                                    break block0;
                                }
                                case 'H': {
                                    n4 = n6 == Integer.MIN_VALUE ? 1 : n6;
                                    break block0;
                                }
                                case 'h': {
                                    smilesAtom3.setImplicitHydrogenCount(n6 == Integer.MIN_VALUE ? -1 : n6);
                                    break block0;
                                }
                                case 'R': {
                                    if (n6 == Integer.MIN_VALUE) {
                                        n6 = -1;
                                    }
                                    smilesAtom3.setRingMembership(n6);
                                    smilesSearch.top.needRingData = true;
                                    break block0;
                                }
                                case 'r': {
                                    if (n6 == Integer.MIN_VALUE) {
                                        n6 = -1;
                                        smilesAtom3.setRingMembership(n6);
                                    } else {
                                        smilesAtom3.setRingSize(n6);
                                        switch (n6) {
                                            case 500: {
                                                n6 = 5;
                                                break;
                                            }
                                            case 600: {
                                                n6 = 6;
                                            }
                                        }
                                        if (n6 > smilesSearch.ringDataMax) {
                                            smilesSearch.ringDataMax = n6;
                                        }
                                    }
                                    smilesSearch.top.needRingData = true;
                                    break block0;
                                }
                                case 'v': {
                                    smilesAtom3.setValence(n6 == Integer.MIN_VALUE ? 1 : n6);
                                    break block0;
                                }
                                case 'X': {
                                    smilesAtom3.setConnectivity(n6 == Integer.MIN_VALUE ? 1 : n6);
                                    break block0;
                                }
                                case 'x': 
                            }
                            smilesAtom3.setRingConnectivity(n6 == Integer.MIN_VALUE ? -1 : n6);
                            smilesSearch.top.needRingData = true;
                        }
                    }
                }
                c = SmilesParser.getChar(string, n3);
                if (!bl5 || c == '\u0000') continue;
                throw new InvalidSmilesException("'!' may only involve one primitive.");
            }
            if (n4 == Integer.MIN_VALUE && bl) {
                n4 = -2147483647;
            }
            smilesAtom3.setExplicitHydrogenCount(n4);
            smilesSearch.patternAtoms[smilesAtom3.index].setExplicitHydrogenCount(n4);
        }
        if (this.braceCount > 0) {
            smilesAtom3.selected = true;
        }
        if (bl4 && smilesAtom != null) {
            smilesAtom.addSubAtom(smilesAtom3, bl2);
        }
        if (smilesAtom2 != null && smilesBond.order == 0) {
            smilesAtom3.notBondedIndex = smilesAtom2.index;
        }
        if (smilesAtom2 != null && smilesBond.order != 0) {
            if (smilesBond.order == -1) {
                int n = this.isBioSequence && bl3 ? 112 : (smilesBond.order = this.isSmarts || smilesAtom2.isAromatic && smilesAtom3.isAromatic ? 81 : 1);
            }
            if (!bl) {
                this.setBondAtom(smilesBond, null, smilesAtom3, smilesSearch);
            }
            if (this.branchLevel == 0 && (smilesBond.order == 17 || smilesBond.order == 112)) {
                ++this.branchLevel;
            }
        }
        if (this.branchLevel == 0) {
            smilesSearch.lastChainAtom = smilesAtom3;
        }
        return smilesAtom3;
    }

    /*
     * Unable to fully structure code
     */
    private int checkCharge(String var1_1, int var2_2, SmilesAtom var3_3) throws InvalidSmilesException {
        block3: {
            var4_4 = var1_1.length();
            var5_5 = var1_1.charAt(var2_2);
            var6_6 = 1;
            if (++var2_2 >= var4_4) break block3;
            var7_7 = var1_1.charAt(var2_2);
            if (!PT.isDigit(var7_7)) ** GOTO lbl14
            var8_8 = new int[1];
            var2_2 = SmilesParser.getDigits(var1_1, var2_2, var8_8);
            var6_6 = var8_8[0];
            if (var6_6 != -2147483648) break block3;
            throw new InvalidSmilesException("Non numeric charge");
lbl-1000:
            // 1 sources

            {
                ++var2_2;
                ++var6_6;
lbl14:
                // 2 sources

                ** while (var2_2 < var4_4 && var1_1.charAt((int)var2_2) == var5_5)
            }
        }
        var3_3.setCharge(var5_5 == '+' ? var6_6 : -var6_6);
        return var2_2;
    }

    private SmilesBond parseBond(SmilesSearch smilesSearch, SmilesBond smilesBond, String string, SmilesBond smilesBond2, SmilesAtom smilesAtom, boolean bl, boolean bl2, int n, int[] nArray) throws InvalidSmilesException {
        SmilesBond smilesBond3;
        char c;
        block27: {
            block26: {
                if (n <= 0) break block26;
                c = string.charAt(0);
                switch (c) {
                    case '>': {
                        if (!string.equals(">>")) {
                            n = -1;
                            break;
                        }
                    }
                    case '.': {
                        if (smilesBond2 == null && smilesBond == null) {
                            this.isBioSequence = SmilesParser.getChar(string, 1) == '~';
                            return new SmilesBond(null, null, 0, false);
                        }
                        n = -1;
                        break;
                    }
                    case '+': {
                        if (smilesBond == null) break block27;
                        n = -1;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block27;
            }
            c = '\u0000';
        }
        SmilesBond smilesBond4 = smilesBond == null ? (smilesBond2 == null ? new SmilesBond(smilesAtom, null, this.isBioSequence && smilesAtom != null ? (bl2 ? 112 : 96) : -1, false) : smilesBond2) : (smilesBond3 = bl ? smilesBond.addPrimitive() : smilesBond.addBondOr());
        if (n > 0 && !this.checkLogic(smilesSearch, string, null, smilesBond3, smilesAtom, bl, false, nArray)) {
            boolean bl3;
            boolean bl4 = bl3 = c == '!';
            if (bl3 && ((c = SmilesParser.getChar(string, 1)) == '\u0000' || c == '!')) {
                throw new InvalidSmilesException("invalid '!'");
            }
            int n2 = SmilesBond.getBondTypeFromCode(c);
            if (n2 == 65) {
                smilesSearch.top.needRingMemberships = true;
            }
            if (smilesAtom == null && n2 != 0) {
                throw new InvalidSmilesException("Bond without a previous atom");
            }
            switch (n2) {
                case 65537: 
                case 65538: {
                    n = string.length();
                    if (n < (bl3 ? 3 : 2) || string.charAt(n - 1) != '-') {
                        n = 0;
                    } else if (n == (bl3 ? 3 : 2)) {
                        smilesBond3.setAtropType(22);
                    } else {
                        SmilesParser.getDigits(string, bl3 ? 2 : 1, nArray);
                        smilesBond3.setAtropType(nArray[0]);
                    }
                    smilesSearch.haveBondStereochemistry = true;
                    break;
                }
                case 1025: 
                case 1041: {
                    this.bondDirectionPaired = !this.bondDirectionPaired;
                    smilesSearch.haveBondStereochemistry = true;
                    break;
                }
                case 17: {
                    break;
                }
                case 2: {
                    ++smilesSearch.top.nDouble;
                }
                case 1: {
                    if (!smilesAtom.isAromatic) break;
                    smilesSearch.top.needRingData = true;
                }
            }
            smilesBond3.set2(n2, bl3);
            if (this.isBioSequence && smilesBond != null) {
                smilesBond.set2(n2, bl3);
            }
        }
        if (n == -1) {
            throw new InvalidSmilesException("invalid bond:" + c);
        }
        return smilesBond3;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private boolean checkLogic(SmilesSearch var1_1, String var2_2, SmilesAtom var3_3, SmilesBond var4_4, SmilesAtom var5_5, boolean var6_6, boolean var7_7, int[] var8_8) throws InvalidSmilesException {
        block21: {
            block24: {
                block23: {
                    block22: {
                        var9_9 = var2_2.lastIndexOf("!");
                        if (var3_3 != null) {
                            var3_3.pattern = var2_2;
                        }
                        while (var9_9 > 0) {
                            if (",;&!".indexOf(var2_2.charAt(var9_9 - 1)) < 0) {
                                var2_2 = String.valueOf(var2_2.substring(0, var9_9)) + "&" + var2_2.substring(var9_9);
                            }
                            var9_9 = var2_2.lastIndexOf("!", var9_9 - 1);
                        }
                        var9_9 = var2_2.indexOf(44);
                        var10_10 = var2_2.length();
                        var11_11 = "&";
                        v0 = var12_12 = var9_9 > 0 ? '\u0001' : '\u0000';
                        if (var12_12 != '\u0000' && !this.isSmarts || var9_9 == 0) break block21;
                        var9_9 = var2_2.indexOf(59);
                        if (var9_9 < 0) break block22;
                        if (!this.isSmarts || var9_9 == 0) break block21;
                        if (var12_12 != '\u0000') {
                            var11_11 = ";";
                            var12_12 = '\u0000';
                        } else {
                            var2_2 = var2_2.replace(';', '&');
                        }
                    }
                    var13_13 = 0;
                    if (var12_12 == '\u0000') break block23;
                    var2_2 = String.valueOf(var2_2) + ",";
                    if (true) ** GOTO lbl53
                }
                var9_9 = var2_2.indexOf(var11_11);
                if (var9_9 < 0) {
                    if (var4_4 == null) return false;
                    if (var10_10 <= 1) return false;
                    if (var6_6 != false) return false;
                }
                if (var9_9 == 0 || var4_4 == null && !this.isSmarts) break block21;
                if (var4_4 == null || var9_9 >= 0 || var10_10 <= 1) break block24;
                var14_15 = new SB();
                var15_16 = 0;
                if (true) ** GOTO lbl77
                do {
                    if ((var14_14 = var2_2.substring(var13_13, var9_9)).length() == 0) {
                        v1 = new StringBuilder("missing ");
                        if (var4_4 == null) {
                            v2 = "atom";
                            throw new InvalidSmilesException(v1.append(v2).append(" token").toString());
                        }
                        v2 = "bond";
                        throw new InvalidSmilesException(v1.append(v2).append(" token").toString());
                    }
                    if (var4_4 == null) {
                        this.parseAtom(var1_1, var3_3, var14_14, null, null, true, false, var7_7);
                    } else {
                        this.parseBond(var1_1, var4_4, var14_14, null, var5_5, false, false, var14_14.length(), var8_8);
                    }
                    var13_13 = var9_9 + 1;
lbl53:
                    // 2 sources

                    var9_9 = var2_2.indexOf(44, var13_13);
                    if (var9_9 <= 0) return true;
                } while (var9_9 <= var10_10);
                return true;
                block6: do {
                    var16_17 = var2_2.charAt(var15_16++);
                    var14_15.appendC(var16_17);
                    switch (var16_17) {
                        case '!': {
                            if (this.isSmarts) continue block6;
                            break block21;
                        }
                        case '^': 
                        case '`': {
                            while ((var16_17 = var2_2.charAt(var15_16++)) != '-' && var16_17 != '\u0000') {
                                var14_15.appendC(var16_17);
                            }
                            var14_15.appendC('-');
                        }
                        default: {
                            if (var15_16 >= var10_10) continue block6;
                            if (!this.isSmarts) break block21;
                            var14_15.append(var11_11);
                        }
                    }
lbl77:
                    // 4 sources

                } while (var15_16 < var10_10);
                var2_2 = var14_15.toString();
                var10_10 = var2_2.length();
            }
            var2_2 = String.valueOf(var2_2) + var11_11;
            if (true) ** GOTO lbl99
        }
        var12_12 = var2_2.charAt(var9_9);
        if (this.isSmarts) {
            v3 = "invalid placement for '" + var12_12 + "'";
            throw new InvalidSmilesException(String.valueOf(v3) + " in " + var2_2);
        }
        v3 = "[" + var12_12 + "] notation only valid with SMARTS, not SMILES,";
        throw new InvalidSmilesException(String.valueOf(v3) + " in " + var2_2);
        do {
            var14_15 = var2_2.substring(var13_13, var9_9);
            if (var4_4 == null) {
                this.parseAtom(var1_1, var3_3, (String)var14_15, null, null, true, true, var7_7);
            } else {
                this.parseBond(var1_1, this.isSmarts != false ? var4_4 : null, (String)var14_15, this.isSmarts != false ? null : var4_4, var5_5, true, false, var14_15.length(), var8_8);
            }
            var13_13 = var9_9 + 1;
lbl99:
            // 2 sources

            var9_9 = var2_2.indexOf(var11_11, var13_13);
            if (var9_9 <= 0) return true;
        } while (var9_9 <= var10_10);
        return true;
    }

    static String getSubPattern(String string, int n, char c) throws InvalidSmilesException {
        char c2;
        int n2 = 1;
        switch (c) {
            case '[': {
                c2 = ']';
                break;
            }
            case '\"': 
            case '%': 
            case '/': {
                c2 = c;
                break;
            }
            case '(': {
                c2 = ')';
                break;
            }
            default: {
                c2 = c;
                n2 = 0;
            }
        }
        int n3 = string.length();
        int n4 = 1;
        int n5 = n + 1;
        while (n5 < n3) {
            char c3 = string.charAt(n5);
            if (c3 == c2) {
                if (--n4 == 0) {
                    return string.substring(n + n2, n5 + 1 - n2);
                }
            } else if (c3 == c) {
                ++n4;
            }
            ++n5;
        }
        throw new InvalidSmilesException("Unmatched " + c);
    }

    static char getChar(String string, int n) {
        return n < string.length() ? string.charAt(n) : (char)'\u0000';
    }

    static int getDigits(String string, int n, int[] nArray) {
        int n2 = n;
        int n3 = string.length();
        while (n2 < n3 && PT.isDigit(string.charAt(n2))) {
            ++n2;
        }
        if (n2 > n) {
            try {
                nArray[0] = Integer.parseInt(string.substring(n, n2));
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        nArray[0] = Integer.MIN_VALUE;
        return n2;
    }

    private static int skipTo(String string, int n, char c) {
        char c2;
        int n2 = n;
        while ((c2 = SmilesParser.getChar(string, ++n2)) != c && c2 != '\u0000') {
        }
        return c2 == '\u0000' ? -1 : n2;
    }

    static String cleanPattern(String string) {
        string = PT.replaceAllCharacters(string, " \t\n\r", "");
        string = PT.rep(string, "^^", "`");
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf("//*")) >= 0 && (n2 = string.indexOf("*//")) >= n) {
            string = String.valueOf(string.substring(0, n)) + string.substring(n2 + 3);
        }
        string = PT.rep(string, "//", "");
        return string;
    }

    static String extractFlags(String string, int[] nArray) throws InvalidSmilesException {
        string = SmilesParser.cleanPattern(string);
        int n = 0;
        while (string.startsWith("/")) {
            String string2 = SmilesParser.getSubPattern(string, 0, '/').toUpperCase();
            string = string.substring(string2.length() + 2);
            n = SmilesSearch.addFlags(n, string2);
        }
        nArray[0] = n;
        return string;
    }

    static int getFlags(String string) throws InvalidSmilesException {
        int[] nArray = new int[1];
        SmilesParser.extractFlags(string, nArray);
        return nArray[0];
    }
}

