/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javajs.awt.Font;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.shape.FontLineShape;
import org.jmol.viewer.JC;

public class Axes
extends FontLineShape {
    public P3 axisXY = new P3();
    public float scale;
    public P3 fixedOrigin;
    public final P3 originPoint = new P3();
    public final P3[] axisPoints = new P3[6];
    public String[] labels;
    public String axisType;
    private static final float MIN_AXIS_LEN = 1.5f;
    private final P3 pt0;
    public final P3 fixedOriginUC;
    final P3 ptTemp;
    V3 corner;

    public Axes() {
        int n = 6;
        while (--n >= 0) {
            this.axisPoints[n] = new P3();
        }
        this.pt0 = new P3();
        this.fixedOriginUC = new P3();
        this.ptTemp = new P3();
        this.corner = new V3();
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("position" == string) {
            boolean bl = this.axisXY.z == 0.0f && ((P3)object).z != 0.0f;
            this.axisXY = (P3)object;
            this.setScale(bl ? 1.0f : this.scale);
            return;
        }
        if ("origin" == string) {
            if (object == null || ((P3)object).length() == 0.0f) {
                this.fixedOrigin = null;
            } else {
                if (this.fixedOrigin == null) {
                    this.fixedOrigin = new P3();
                }
                this.fixedOrigin.setT((P3)object);
            }
            this.reinitShape();
            return;
        }
        if ("labels" == string) {
            this.labels = (String[])object;
            return;
        }
        if ("labelsOn" == string) {
            this.labels = null;
            return;
        }
        if ("labelsOff" == string) {
            this.labels = new String[]{"", "", ""};
            return;
        }
        if ("type" == string) {
            this.axisType = (String)object;
            if (this.axisType.equals("abc")) {
                this.axisType = null;
            }
        }
        this.setPropFLS(string, object);
    }

    @Override
    public void initShape() {
        SymmetryInterface symmetryInterface;
        this.translucentAllowed = false;
        this.myType = "axes";
        this.font3d = this.vwr.gdata.getFont3D(14.0f);
        int n = this.vwr.g.axesMode;
        if (n == 0x24000020 && this.ms.unitCells != null && (symmetryInterface = this.vwr.getCurrentUnitCell()) != null) {
            float f = this.vwr.getFloat(0x22000001);
            this.fixedOriginUC.set(f, f, f);
            P3 p3 = symmetryInterface.getCartesianOffset();
            P3[] p3Array = symmetryInterface.getUnitCellVerticesNoOffset();
            this.originPoint.add2(p3, p3Array[0]);
            if (f != 0.0f) {
                symmetryInterface.toCartesian(this.fixedOriginUC, false);
            } else if (this.fixedOrigin != null) {
                this.originPoint.setT(this.fixedOrigin);
            }
            if (f != 0.0f) {
                this.originPoint.add(this.fixedOriginUC);
            }
            this.scale = this.vwr.getFloat(0x22000002) / 2.0f;
            this.axisPoints[0].scaleAdd2(this.scale, p3Array[4], this.originPoint);
            this.axisPoints[1].scaleAdd2(this.scale, p3Array[2], this.originPoint);
            this.axisPoints[2].scaleAdd2(this.scale, p3Array[1], this.originPoint);
            return;
        }
        this.originPoint.setT(this.fixedOrigin != null ? this.fixedOrigin : (n == 603979809 ? this.vwr.getBoundBoxCenter() : this.pt0));
        this.setScale(this.vwr.getFloat(0x22000002) / 2.0f);
    }

    public void reinitShape() {
        Font font = this.font3d;
        this.initShape();
        if (font != null) {
            this.font3d = font;
        }
    }

    public P3 getAxisPoint(int n, boolean bl) {
        if (!bl && this.axisXY.z == 0.0f) {
            return this.axisPoints[n];
        }
        this.ptTemp.sub2(this.axisPoints[n], this.originPoint);
        this.ptTemp.scale(0.5f);
        return this.ptTemp;
    }

    @Override
    public Object getProperty(String string, int n) {
        if (string == "origin") {
            return this.fixedOrigin;
        }
        if (string == "axesTypeXY") {
            return this.axisXY.z == 0.0f ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    void setScale(float f) {
        this.scale = f;
        this.corner.setT(this.vwr.getBoundBoxCornerVector());
        int n = 6;
        while (--n >= 0) {
            P3 p3 = this.axisPoints[n];
            p3.setT(JC.unitAxisVectors[n]);
            if (this.corner.x < 1.5f) {
                this.corner.x = 1.5f;
            }
            if (this.corner.y < 1.5f) {
                this.corner.y = 1.5f;
            }
            if (this.corner.z < 1.5f) {
                this.corner.z = 1.5f;
            }
            if (this.axisXY.z == 0.0f) {
                p3.x *= this.corner.x * f;
                p3.y *= this.corner.y * f;
                p3.z *= this.corner.z * f;
            }
            p3.add(this.originPoint);
        }
    }
}

