/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.P3;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;

abstract class MapFileReader
extends VolumeFileReader {
    protected float dmin = Float.MAX_VALUE;
    protected float dmax;
    protected float dmean;
    protected float drange;
    protected int mapc;
    protected int mapr;
    protected int maps;
    protected int n0;
    protected int n1;
    protected int n2;
    protected int mode;
    protected float[] xyzStart = new float[3];
    protected int na;
    protected int nb;
    protected int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected P3 origin = new P3();
    protected P3[] vectors = new P3[3];
    protected int xIndex = -1;
    protected int yIndex;
    protected int zIndex;
    protected P3 p3 = new P3();

    MapFileReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2MFR(surfaceGenerator, bufferedReader);
    }

    protected void init2MFR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        this.isAngstroms = true;
    }

    protected void checkInsideOut(int n, int n2, int n3) {
        if (this.params.thePlane == null) {
            this.params.insideOut = ";123;231;312;".indexOf(";" + n + n2 + n3) >= 0;
        }
    }

    protected void getVectorsAndOrigin() {
        this.checkInsideOut(this.mapc, this.mapr, this.maps);
        Logger.info("grid parameters: nx,ny,nz: " + this.n0 + "," + this.n1 + "," + this.n2);
        Logger.info("grid parameters: nxStart,nyStart,nzStart: " + this.xyzStart[0] + "," + this.xyzStart[1] + "," + this.xyzStart[2]);
        Logger.info("grid parameters: mx,my,mz: " + this.na + "," + this.nb + "," + this.nc);
        Logger.info("grid parameters: a,b,c,alpha,beta,gamma: " + this.a + "," + this.b + "," + this.c + "," + this.alpha + "," + this.beta + "," + this.gamma);
        Logger.info("grid parameters: mapc,mapr,maps: " + this.mapc + "," + this.mapr + "," + this.maps);
        Logger.info("grid parameters: originX,Y,Z: " + this.origin);
        SimpleUnitCell simpleUnitCell = SimpleUnitCell.newA(new float[]{this.a / (float)this.na, this.b / (float)this.nb, this.c / (float)this.nc, this.alpha, this.beta, this.gamma});
        this.vectors[0] = P3.new3(1.0f, 0.0f, 0.0f);
        this.vectors[1] = P3.new3(0.0f, 1.0f, 0.0f);
        this.vectors[2] = P3.new3(0.0f, 0.0f, 1.0f);
        simpleUnitCell.toCartesian(this.vectors[0], false);
        simpleUnitCell.toCartesian(this.vectors[1], false);
        simpleUnitCell.toCartesian(this.vectors[2], false);
        Logger.info("Jmol unit cell vectors:");
        Logger.info("    a: " + this.vectors[0]);
        Logger.info("    b: " + this.vectors[1]);
        Logger.info("    c: " + this.vectors[2]);
        this.voxelCounts[0] = this.n2;
        this.voxelCounts[1] = this.n1;
        this.voxelCounts[2] = this.n0;
        this.volumetricVectors[0].setT(this.vectors[this.maps - 1]);
        this.volumetricVectors[1].setT(this.vectors[this.mapr - 1]);
        this.volumetricVectors[2].setT(this.vectors[this.mapc - 1]);
        if (this.origin.x == 0.0f && this.origin.y == 0.0f && this.origin.z == 0.0f) {
            if (this.xIndex == -1) {
                int[] nArray = new int[3];
                nArray[this.mapc - 1] = 0;
                nArray[this.mapr - 1] = 1;
                nArray[this.maps - 1] = 2;
                this.xIndex = nArray[0];
                this.yIndex = nArray[1];
                this.zIndex = nArray[2];
            }
            this.origin.scaleAdd2(this.xyzStart[this.xIndex], this.vectors[0], this.origin);
            this.origin.scaleAdd2(this.xyzStart[this.yIndex], this.vectors[1], this.origin);
            this.origin.scaleAdd2(this.xyzStart[this.zIndex], this.vectors[2], this.origin);
        }
        this.volumetricOrigin.setT(this.origin);
        Logger.info("Jmol grid origin in Cartesian coordinates: " + this.origin);
        Logger.info("Use  isosurface OFFSET {x y z}  if you want to shift it.\n");
        this.p3.set(this.na, this.nb, this.nc);
        simpleUnitCell.toCartesian(this.p3, true);
        this.p3.add(this.origin);
        Logger.info("boundbox corners " + this.origin + " " + this.p3 + ";draw bbox boundbox mesh nofill");
    }

    protected void setCutoffAutomatic() {
        if (this.params.thePlane == null && this.params.cutoffAutomatic) {
            this.params.cutoff = -1.0f;
            Logger.info("MapReader: setting cutoff to default value of " + this.params.cutoff + (this.boundingBox == null ? " (no BOUNDBOX parameter)\n" : "\n"));
        }
    }
}

