/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.P3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.G3DRenderer;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.PrecisionRenderer;
import org.jmol.util.GData;
import org.jmol.util.Rgb16;

public class TriangleRenderer
extends PrecisionRenderer
implements G3DRenderer {
    private Graphics3D g3d;
    private static final int DEFAULT = 64;
    private int[] ax = new int[3];
    private int[] ay = new int[3];
    private int[] az = new int[3];
    private float[] aa = new float[64];
    private float[] bb = new float[64];
    private int[] axW = new int[64];
    private int[] azW = new int[64];
    private int[] axE = new int[64];
    private int[] azE = new int[64];
    private Rgb16[] rgb16sW;
    private Rgb16[] rgb16sE;
    private Rgb16[] rgb16sGouraud;
    private final Rgb16 rgb16t1 = new Rgb16();
    private final Rgb16 rgb16t2 = new Rgb16();

    @Override
    public G3DRenderer set(JmolRendererInterface jmolRendererInterface, GData gData) {
        try {
            this.rgb16sW = new Rgb16[64];
            this.rgb16sE = new Rgb16[64];
            int n = 64;
            while (--n >= 0) {
                this.rgb16sW[n] = new Rgb16();
                this.rgb16sE[n] = new Rgb16();
            }
            this.g3d = (Graphics3D)jmolRendererInterface;
            this.rgb16sGouraud = new Rgb16[3];
            n = 3;
            while (--n >= 0) {
                this.rgb16sGouraud[n] = new Rgb16();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private Rgb16[] reallocRgb16s(Rgb16[] rgb16Array, int n) {
        Rgb16[] rgb16Array2 = new Rgb16[n];
        System.arraycopy(rgb16Array, 0, rgb16Array2, 0, rgb16Array.length);
        int n2 = rgb16Array.length;
        while (n2 < n) {
            rgb16Array2[n2] = new Rgb16();
            ++n2;
        }
        return rgb16Array2;
    }

    void setGouraud(int n, int n2, int n3) {
        this.rgb16sGouraud[0].setInt(n);
        this.rgb16sGouraud[1].setInt(n2);
        this.rgb16sGouraud[2].setInt(n3);
    }

    /*
     * Unable to fully structure code
     */
    void fillTriangle(P3i var1_1, P3i var2_2, P3i var3_3, boolean var4_4) {
        block31: {
            block30: {
                this.ax[0] = var1_1.x;
                this.ax[1] = var2_2.x;
                this.ax[2] = var3_3.x;
                this.ay[0] = var1_1.y;
                this.ay[1] = var2_2.y;
                this.ay[2] = var3_3.y;
                this.az[0] = var1_1.z;
                this.az[1] = var2_2.z;
                this.az[2] = var3_3.z;
                if (this.az[0] <= 1 || this.az[1] <= 1 || this.az[2] <= 1) {
                    return;
                }
                var5_5 = this.g3d.clipCode3(this.ax[0], this.ay[0], this.az[0]);
                var8_8 = var5_5 | (var6_6 = this.g3d.clipCode3(this.ax[1], this.ay[1], this.az[1])) | (var7_7 = this.g3d.clipCode3(this.ax[2], this.ay[2], this.az[2]));
                v0 = var9_9 = var8_8 != 0;
                if (var9_9 && (var8_8 == -1 || (var5_5 & var6_6 & var7_7) != 0)) {
                    return;
                }
                var10_10 = 0;
                if (this.ay[1] < this.ay[var10_10]) {
                    var10_10 = 1;
                }
                if (this.ay[2] < this.ay[var10_10]) {
                    var10_10 = 2;
                }
                if (this.ay[var11_11 = (var10_10 + 1) % 3] > this.ay[var12_12 = (var10_10 + 2) % 3]) {
                    var13_13 = var11_11;
                    var11_11 = var12_12;
                    var12_12 = var13_13;
                }
                var13_13 = this.ay[var10_10];
                var14_14 = this.ay[var11_11];
                var15_15 = this.ay[var12_12];
                var16_16 = var15_15 - var13_13 + 1;
                if (var16_16 > this.g3d.height * 3) {
                    return;
                }
                if (var16_16 > this.axW.length) {
                    var17_17 = var16_16 + 31 & -32;
                    this.axW = new int[var17_17];
                    this.azW = new int[var17_17];
                    this.axE = new int[var17_17];
                    this.azE = new int[var17_17];
                    this.aa = new float[var17_17];
                    this.bb = new float[var17_17];
                    this.rgb16sW = this.reallocRgb16s(this.rgb16sW, var17_17);
                    this.rgb16sE = this.reallocRgb16s(this.rgb16sE, var17_17);
                }
                if (var4_4) {
                    var17_18 = this.rgb16sW;
                    var18_19 = this.rgb16sE;
                } else {
                    var18_19 = null;
                    var17_18 = null;
                }
                var19_20 = var14_14 - var13_13;
                if (var19_20 == 0) {
                    if (this.ax[var11_11] < this.ax[var10_10]) {
                        var20_21 = var11_11;
                        var11_11 = var10_10;
                        var10_10 = var20_21;
                    }
                    this.generateRaster(var16_16, var10_10, var12_12, this.axW, this.azW, 0, var17_18);
                    this.generateRaster(var16_16, var11_11, var12_12, this.axE, this.azE, 0, var18_19);
                } else if (var14_14 == var15_15) {
                    if (this.ax[var12_12] < this.ax[var11_11]) {
                        var20_21 = var11_11;
                        var11_11 = var12_12;
                        var12_12 = var20_21;
                    }
                    this.generateRaster(var16_16, var10_10, var11_11, this.axW, this.azW, 0, var17_18);
                    this.generateRaster(var16_16, var10_10, var12_12, this.axE, this.azE, 0, var18_19);
                } else {
                    var20_21 = this.ax[var12_12] - this.ax[var10_10];
                    var21_22 = GData.roundInt(var16_16 / 2);
                    if (var20_21 < 0) {
                        var21_22 = -var21_22;
                    }
                    if ((var22_23 = this.ax[var10_10] + (var20_21 * var19_20 + var21_22) / var16_16) < this.ax[var11_11]) {
                        this.generateRaster(var16_16, var10_10, var12_12, this.axW, this.azW, 0, var17_18);
                        this.generateRaster(var19_20 + 1, var10_10, var11_11, this.axE, this.azE, 0, var18_19);
                        this.generateRaster(var16_16 - var19_20, var11_11, var12_12, this.axE, this.azE, var19_20, var18_19);
                    } else {
                        this.generateRaster(var19_20 + 1, var10_10, var11_11, this.axW, this.azW, 0, var17_18);
                        this.generateRaster(var16_16 - var19_20, var11_11, var12_12, this.axW, this.azW, var19_20, var17_18);
                        this.generateRaster(var16_16, var10_10, var12_12, this.axE, this.azE, 0, var18_19);
                    }
                }
                this.g3d.setZMargin(5);
                var20_21 = this.g3d.pass2Flag01;
                var21_22 = 1 - var20_21;
                var23_24 = 0;
                if (var13_13 < 0) {
                    var16_16 += var13_13;
                    var23_24 -= var13_13;
                    var13_13 = 0;
                }
                if (var13_13 + var16_16 > this.g3d.height) {
                    var16_16 = this.g3d.height - var13_13;
                }
                if (!var4_4) break block30;
                if (!var9_9) ** GOTO lbl107
                while (--var16_16 >= var20_21) {
                    var22_23 = this.axW[var23_24];
                    var24_25 = this.axE[var23_24] - var22_23 + var21_22;
                    if (var24_25 > 0) {
                        this.g3d.plotPixelsClippedRaster(var24_25, var22_23, var13_13, this.azW[var23_24], this.azE[var23_24], this.rgb16sW[var23_24], this.rgb16sE[var23_24]);
                    }
                    ++var13_13;
                    ++var23_24;
                }
                break block31;
lbl-1000:
                // 1 sources

                {
                    var22_23 = this.axW[var23_24];
                    var24_26 = this.axE[var23_24] - var22_23 + var21_22;
                    if (var20_21 == 1 && var24_26 < 0) {
                        var24_26 = 1;
                        --var22_23;
                    }
                    if (var24_26 > 0) {
                        this.g3d.plotPixelsUnclippedRaster(var24_26, var22_23, var13_13, this.azW[var23_24], this.azE[var23_24], this.rgb16sW[var23_24], this.rgb16sE[var23_24]);
                    }
                    ++var13_13;
                    ++var23_24;
lbl107:
                    // 2 sources

                    ** while (--var16_16 >= var20_21)
                }
lbl108:
                // 1 sources

                break block31;
            }
            if (!var9_9) ** GOTO lbl129
            while (--var16_16 >= var20_21) {
                var22_23 = this.axW[var23_24];
                var24_27 = this.axE[var23_24] - var22_23 + var21_22;
                if (var24_27 > 0) {
                    this.g3d.plotPixelsClippedRasterBits(var24_27, var22_23, var13_13, this.azW[var23_24], this.azE[var23_24], null, null, this.aa[var23_24], this.bb[var23_24]);
                }
                ++var13_13;
                ++var23_24;
            }
            break block31;
lbl-1000:
            // 1 sources

            {
                var22_23 = this.axW[var23_24];
                var24_28 = this.axE[var23_24] - var22_23 + var21_22;
                if (var20_21 == 1 && var24_28 < 0) {
                    var24_28 = 1;
                    --var22_23;
                }
                if (var24_28 > 0) {
                    this.g3d.plotPixelsUnclippedRasterBits(var24_28, var22_23, var13_13, null, null, this.aa[var23_24], this.bb[var23_24]);
                }
                ++var13_13;
                ++var23_24;
lbl129:
                // 2 sources

                ** while (--var16_16 >= var20_21)
            }
        }
        this.g3d.setZMargin(0);
    }

    private void generateRaster(int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, Rgb16[] rgb16Array) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.ax[n2];
        int n11 = this.ax[n3];
        int n12 = n11 - n10;
        int n13 = n10;
        if (n12 >= 0) {
            n9 = 1;
            n8 = n12;
            n7 = 0;
        } else {
            n9 = -1;
            n8 = -n12;
            n7 = 1 - n;
        }
        if (n8 <= n) {
            n6 = 0;
            n5 = n8;
        } else {
            n6 = GData.roundInt(n12 / n);
            n5 = n8 % n;
        }
        this.setRastAB(this.ay[n2], this.az[n2], this.ay[n3], this.az[n3]);
        float f = this.a;
        float f2 = this.b;
        boolean bl = nArray == this.axE;
        int n14 = 0;
        int n15 = this.ay[n2];
        int n16 = n - 1;
        int n17 = n4;
        while (n14 <= n16) {
            if (n17 == 0 || n17 > n4) {
                nArray[n17] = n14 == n16 ? this.ax[n3] : n13;
                nArray2[n17] = this.getZCurrent(f, f2, n15);
                if (bl) {
                    this.setRastAB(this.axW[n17], this.azW[n17], nArray[n17], nArray2[n17]);
                    this.aa[n17] = this.a;
                    this.bb[n17] = this.b;
                }
            }
            n13 += n6;
            if ((n7 += n5) > 0) {
                n13 += n9;
                n7 -= n;
            }
            ++n17;
            ++n14;
            ++n15;
        }
        if (rgb16Array != null) {
            Rgb16 rgb16 = this.rgb16t1;
            rgb16.setRgb(this.rgb16sGouraud[n2]);
            Rgb16 rgb162 = this.rgb16t2;
            rgb162.diffDiv(this.rgb16sGouraud[n3], rgb16, n);
            n16 = n4;
            n17 = n4 + n;
            while (n16 < n17) {
                rgb16Array[n16].setAndIncrement(rgb16, rgb162);
                ++n16;
            }
        }
    }
}

