/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.IOException;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.JSR223TestElement;
import org.apache.jmeter.visualizers.Visualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="displayName")
public class JSR223Listener
extends JSR223TestElement
implements Cloneable,
SampleListener,
TestBean,
Visualizer {
    private static final Logger log = LoggerFactory.getLogger(JSR223Listener.class);
    private static final long serialVersionUID = 235L;

    public void sampleOccurred(SampleEvent event) {
        try {
            ScriptEngine scriptEngine = this.getScriptEngine();
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("sampleEvent", (Object)event);
            bindings.put("sampleResult", (Object)event.getResult());
            this.processFileOrScript(scriptEngine, bindings);
        }
        catch (IOException | ScriptException e) {
            log.error("Problem in JSR223 script, {}", (Object)this.getName(), (Object)e);
        }
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void add(SampleResult sample) {
    }

    public boolean isStats() {
        return false;
    }

    public Object clone() {
        return super.clone();
    }
}

