/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.util.Comparator;
import java.util.function.Function;

public class Pair<T, H> {
    private T first;
    private H second;

    public Pair(T first, H second) {
        this.first = first;
        this.second = second;
    }

    public H getSecond() {
        return this.second;
    }

    public T getFirst() {
        return this.first;
    }

    public void setFirst(T first) {
        this.first = first;
    }

    public void setSecond(H second) {
        this.second = second;
    }

    public String toString() {
        return "[" + this.first.toString() + "," + this.second.toString() + "]";
    }

    public static <L extends Comparable<L>, R> Comparator<Pair<L, R>> compareFirst() {
        return Pair.compareFirst(first -> first);
    }

    public static <L, R, C extends Comparable<C>> Comparator<Pair<L, R>> compareFirst(Function<L, C> mapping) {
        return Comparator.comparing(pair -> (Comparable)mapping.apply(pair.first));
    }

    public static <L, R extends Comparable<R>> Comparator<Pair<L, R>> compareSecond() {
        return Pair.compareSecond(second -> second);
    }

    public static <L, R, C extends Comparable<C>> Comparator<Pair<L, R>> compareSecond(Function<R, C> mapping) {
        return Comparator.comparing(pair -> (Comparable)mapping.apply(pair.second));
    }
}

