/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.ServiceLoader;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.rmi.RmiUtils;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.RemoteThreadsLifeCycleListener;
import org.apache.jmeter.threads.RemoteThreadsListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.LogAndIgnoreServiceLoadExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteThreadsListenerImpl
extends UnicastRemoteObject
implements RemoteThreadsListener,
ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(RemoteThreadsListenerImpl.class);
    private final Collection<RemoteThreadsLifeCycleListener> listeners = JMeterUtils.loadServicesAndScanJars(RemoteThreadsLifeCycleListener.class, ServiceLoader.load(RemoteThreadsLifeCycleListener.class), Thread.currentThread().getContextClassLoader(), new LogAndIgnoreServiceLoadExceptionHandler(log));
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_LOCAL_PORT = RemoteThreadsListenerImpl.addOffset(JMeterUtils.getPropDefault("client.rmi.localport", 0), 1);

    public RemoteThreadsListenerImpl() throws RemoteException {
        super(DEFAULT_LOCAL_PORT, RmiUtils.createClientSocketFactory(), RmiUtils.createServerSocketFactory());
    }

    private static int addOffset(int port, int offset) {
        if (port == 0) {
            return 0;
        }
        return port + offset;
    }

    @Override
    public void threadStarted() {
        JMeterContextService.incrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        for (RemoteThreadsLifeCycleListener listener : this.listeners) {
            listener.threadNumberIncreased(JMeterContextService.getNumberOfThreads());
        }
    }

    @Override
    public void threadFinished() {
        JMeterContextService.decrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        for (RemoteThreadsLifeCycleListener listener : this.listeners) {
            listener.threadNumberDecreased(JMeterContextService.getNumberOfThreads());
        }
    }
}

