/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.properties;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jCharts.Chart;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.util.ChartFont;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;
import org.jCharts.types.PieLabelType;

public final class PieChart2DProperties
extends ChartTypeProperties
implements HTMLTestable {
    public static final Paint DEFAULT_BORDER_PAINT = Color.black;
    public static final Stroke DEFAULT_BORDER_STROKE = new BasicStroke(1.5f, 2, 1);
    private Paint borderPaint = DEFAULT_BORDER_PAINT;
    private Stroke borderStroke = DEFAULT_BORDER_STROKE;
    private float zeroDegreeOffset = 20.0f;
    private PieLabelType pieLabelType = PieLabelType.NO_LABELS;
    private boolean isCurrency = false;
    private boolean showGrouping = false;
    private int roundingPowerOfTen = 0;
    private ChartFont valueLabelFont = ChartFont.DEFAULT_PIE_VALUE;
    private float tickLength = 5.0f;

    public void setZeroDegreeOffset(float f) {
        this.zeroDegreeOffset = f;
    }

    public float getZeroDegreeOffset() {
        return this.zeroDegreeOffset;
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(Stroke stroke) {
        this.borderStroke = stroke;
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
    }

    public PieLabelType getPieLabelType() {
        return this.pieLabelType;
    }

    public void setPieLabelType(PieLabelType pieLabelType) {
        this.pieLabelType = pieLabelType;
    }

    public ChartFont getValueLabelFont() {
        return this.valueLabelFont;
    }

    public void setValueLabelFont(ChartFont chartFont) {
        this.valueLabelFont = chartFont;
    }

    public void setCurrency(boolean bl) {
        this.isCurrency = bl;
    }

    public void setShowGrouping(boolean bl) {
        this.showGrouping = bl;
    }

    public void setRoundingPowerOfTen(int n) {
        this.roundingPowerOfTen = n;
    }

    public void setTickLength(float f) {
        this.tickLength = f;
    }

    public float getTickLength() {
        return this.tickLength;
    }

    public boolean showValueLabelCurrency() {
        return this.isCurrency;
    }

    public boolean showValueLabelGrouping() {
        return this.showGrouping;
    }

    public int getValueLabelRoundingPowerOfTen() {
        return this.roundingPowerOfTen;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart("PieChart2DProperties");
        hTMLGenerator.addTableRow("Zero Degree Offset", Double.toString(this.getZeroDegreeOffset()));
        hTMLGenerator.addTableRow("Border Paint", this.getBorderPaint());
        hTMLGenerator.addTableRow("Border Stroke", this.getBorderStroke());
        hTMLGenerator.addTableRow("Label Type", this.pieLabelType);
        hTMLGenerator.propertiesTableEnd();
    }

    public void validate(Chart chart) throws PropertyException {
    }
}

