/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.jmeter.protocol.jms.sampler.MessageAdmin;
import org.apache.jmeter.protocol.jms.sampler.QueueExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedQueueExecutor
implements QueueExecutor {
    private static final Logger log = LoggerFactory.getLogger(FixedQueueExecutor.class);
    private final MessageProducer producer;
    private final int timeout;
    private final boolean useReqMsgIdAsCorrelId;

    public FixedQueueExecutor(MessageProducer producer, int timeout, boolean useReqMsgIdAsCorrelId) {
        this.producer = producer;
        this.timeout = timeout;
        this.useReqMsgIdAsCorrelId = useReqMsgIdAsCorrelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message sendAndReceive(Message request, int deliveryMode, int priority, long expiration) throws JMSException {
        String id = request.getJMSCorrelationID();
        if (id == null && !this.useReqMsgIdAsCorrelId) {
            throw new IllegalArgumentException("Correlation id is null. Set the JMSCorrelationID header.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MessageAdmin admin = MessageAdmin.getAdmin();
        if (this.useReqMsgIdAsCorrelId) {
            MessageAdmin messageAdmin = admin;
            synchronized (messageAdmin) {
                this.producer.send(request, deliveryMode, priority, expiration);
                id = request.getJMSMessageID();
                admin.putRequest(id, request, countDownLatch);
            }
        } else {
            admin.putRequest(id, request, countDownLatch);
            this.producer.send(request, deliveryMode, priority, expiration);
        }
        try {
            log.debug("{} will wait for reply {} started on {}", new Object[]{Thread.currentThread().getName(), id, System.currentTimeMillis()});
            if (this.timeout == 0) {
                log.debug("Waiting infinitely for message");
                countDownLatch.await();
            } else if (!countDownLatch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                log.debug("Timeout {} ms reached before getting a reply message", (Object)this.timeout);
            }
            log.debug("{} done waiting for {} on {} ended on {}", new Object[]{Thread.currentThread().getName(), id, request, System.currentTimeMillis()});
        }
        catch (InterruptedException e) {
            log.warn("Interrupt exception caught", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return admin.get(id);
    }

    @Override
    public void close() throws JMSException {
    }
}

