/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.mapper.composite;

import jetbrains.datalore.base.function.Function;
import jetbrains.datalore.base.geometry.Rectangle;
import jetbrains.datalore.base.geometry.Vector;
import jetbrains.datalore.mapper.composite.Composites;
import jetbrains.datalore.mapper.composite.HasBounds;
import jetbrains.datalore.mapper.composite.HasFocusability;
import jetbrains.datalore.mapper.composite.NavComposite;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u0002H\u00072\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ/\u0010\f\u001a\u0002H\u0007\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\r*\u00020\u000e*\u00020\u000f*\u00020\b2\u0006\u0010\u0010\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u0011J/\u0010\u0012\u001a\u0002H\u0007\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\r*\u00020\u000e*\u00020\u000f*\u00020\b2\u0006\u0010\u0010\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0007*\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00072\b\u0010\u0016\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0018\u001a\u00020\u0014\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u0016\u001a\u0002H\u00072\b\u0010\u0015\u001a\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010\u0017J9\u0010\u0019\u001a\u0004\u0018\u0001H\u0007\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\r*\u00020\u000e*\u00020\u000f*\u00020\b2\u0006\u0010\u001a\u001a\u0002H\u00072\u0006\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u001cJ5\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001e\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\r*\u00020\u000e*\u00020\u000f*\u00020\b2\u0006\u0010\u001a\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u001fJ9\u0010 \u001a\u0004\u0018\u0001H\u0007\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\r*\u00020\u000e*\u00020\u000f*\u00020\b2\u0006\u0010\u001a\u001a\u0002H\u00072\u0006\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u001cJ5\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001e\"\u001a\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\r*\u00020\u000e*\u00020\u000f*\u00020\b2\u0006\u0010\u001a\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ljetbrains/datalore/mapper/composite/CompositesWithBounds;", "", "myThreshold", "", "(I)V", "distanceTo", "", "ViewT", "Ljetbrains/datalore/mapper/composite/HasBounds;", "c", "x", "(Ljetbrains/datalore/mapper/composite/HasBounds;I)D", "endElement", "Ljetbrains/datalore/mapper/composite/NavComposite;", "Ljetbrains/datalore/mapper/composite/HasFocusability;", "Ljetbrains/datalore/mapper/composite/HasVisibility;", "cell", "(Ljetbrains/datalore/mapper/composite/NavComposite;)Ljetbrains/datalore/mapper/composite/NavComposite;", "homeElement", "isAbove", "", "upper", "lower", "(Ljetbrains/datalore/mapper/composite/HasBounds;Ljetbrains/datalore/mapper/composite/HasBounds;)Z", "isBelow", "lowerFocusable", "v", "xOffset", "(Ljetbrains/datalore/mapper/composite/NavComposite;I)Ljetbrains/datalore/mapper/composite/NavComposite;", "lowerFocusables", "", "(Ljetbrains/datalore/mapper/composite/NavComposite;)Ljava/lang/Iterable;", "upperFocusable", "upperFocusables", "NextLowerFocusable", "NextUpperFocusable", "mapper-core"})
public final class CompositesWithBounds {
    private final int myThreshold;

    public CompositesWithBounds(int myThreshold) {
        this.myThreshold = myThreshold;
    }

    public final <ViewT extends HasBounds> boolean isAbove(@Nullable ViewT upper, @Nullable ViewT lower) {
        ViewT ViewT = upper;
        Intrinsics.checkNotNull(ViewT);
        Rectangle upperBounds = ViewT.getBounds();
        ViewT ViewT2 = lower;
        Intrinsics.checkNotNull(ViewT2);
        Rectangle lowerBounds = ViewT2.getBounds();
        return upperBounds.getOrigin().getY() + upperBounds.getDimension().getY() - this.myThreshold <= lowerBounds.getOrigin().getY();
    }

    public final <ViewT extends HasBounds> boolean isBelow(@NotNull ViewT lower, @Nullable ViewT upper) {
        Intrinsics.checkNotNullParameter(lower, (String)"lower");
        return this.isAbove(upper, lower);
    }

    @NotNull
    public final <ViewT extends NavComposite<ViewT> & HasFocusability & HasBounds> ViewT homeElement(@NotNull ViewT cell) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        ViewT current = cell;
        ViewT prev;
        while ((prev = Composites.INSTANCE.prevFocusable(current)) != null && !this.isAbove(prev, cell)) {
            current = prev;
        }
        return current;
    }

    @NotNull
    public final <ViewT extends NavComposite<ViewT> & HasFocusability & HasBounds> ViewT endElement(@NotNull ViewT cell) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        ViewT current = cell;
        ViewT next;
        while ((next = Composites.INSTANCE.nextFocusable(current)) != null && !this.isBelow(next, cell)) {
            current = next;
        }
        return current;
    }

    @NotNull
    public final <ViewT extends NavComposite<ViewT> & HasFocusability & HasBounds> Iterable<ViewT> upperFocusables(@NotNull ViewT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        NextUpperFocusable nextUpperFocusable = new NextUpperFocusable(this, v);
        return Composites.INSTANCE.iterate$mapper_core(v, (Function1)new Function1<ViewT, ViewT>(nextUpperFocusable){
            final /* synthetic */ NextUpperFocusable<ViewT> $nextUpperFocusable;
            {
                this.$nextUpperFocusable = $nextUpperFocusable;
                super(1);
            }

            @Nullable
            public final ViewT invoke(@NotNull ViewT it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$nextUpperFocusable.apply(it);
            }
        });
    }

    @NotNull
    public final <ViewT extends NavComposite<ViewT> & HasFocusability & HasBounds> Iterable<ViewT> lowerFocusables(@NotNull ViewT v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        NextLowerFocusable nextLowerFocusable = new NextLowerFocusable(this, v);
        return Composites.INSTANCE.iterate$mapper_core(v, (Function1)new Function1<ViewT, ViewT>(nextLowerFocusable){
            final /* synthetic */ NextLowerFocusable<ViewT> $nextLowerFocusable;
            {
                this.$nextLowerFocusable = $nextLowerFocusable;
                super(1);
            }

            @Nullable
            public final ViewT invoke(@NotNull ViewT it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$nextLowerFocusable.apply(it);
            }
        });
    }

    @Nullable
    public final <ViewT extends NavComposite<ViewT> & HasFocusability & HasBounds> ViewT upperFocusable(@NotNull ViewT v, int xOffset2) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        ViewT current = Composites.INSTANCE.prevFocusable(v);
        ViewT bestMatch = null;
        while (!(current == null || bestMatch != null && this.isAbove(current, (HasBounds)bestMatch))) {
            if (bestMatch != null) {
                if (this.distanceTo((HasBounds)bestMatch, xOffset2) > this.distanceTo(current, xOffset2)) {
                    bestMatch = current;
                }
            } else if (this.isAbove(current, v)) {
                bestMatch = current;
            }
            current = Composites.INSTANCE.prevFocusable(current);
        }
        return bestMatch;
    }

    @Nullable
    public final <ViewT extends NavComposite<ViewT> & HasFocusability & HasBounds> ViewT lowerFocusable(@NotNull ViewT v, int xOffset2) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        ViewT current = Composites.INSTANCE.nextFocusable(v);
        ViewT bestMatch = null;
        while (!(current == null || bestMatch != null && this.isBelow(current, (HasBounds)bestMatch))) {
            if (bestMatch != null) {
                if (this.distanceTo((HasBounds)bestMatch, xOffset2) > this.distanceTo(current, xOffset2)) {
                    bestMatch = current;
                }
            } else if (this.isBelow(current, v)) {
                bestMatch = current;
            }
            current = Composites.INSTANCE.nextFocusable(current);
        }
        return bestMatch;
    }

    public final <ViewT extends HasBounds> double distanceTo(@NotNull ViewT c, int x2) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        Rectangle bounds = c.getBounds();
        return bounds.distance(new Vector(x2, bounds.getOrigin().getY()));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u0000*\u001a\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u00020\u0003*\u00020\u0004*\u00020\u00052\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0006B\u000f\b\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\rR\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0007\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/mapper/composite/CompositesWithBounds$NextUpperFocusable;", "ViewT", "Ljetbrains/datalore/mapper/composite/NavComposite;", "Ljetbrains/datalore/mapper/composite/HasFocusability;", "Ljetbrains/datalore/mapper/composite/HasVisibility;", "Ljetbrains/datalore/mapper/composite/HasBounds;", "Ljetbrains/datalore/base/function/Function;", "myInitial", "(Ljetbrains/datalore/mapper/composite/CompositesWithBounds;Ljetbrains/datalore/mapper/composite/NavComposite;)V", "myFirstFocusableAbove", "Ljetbrains/datalore/mapper/composite/NavComposite;", "apply", "value", "(Ljetbrains/datalore/mapper/composite/NavComposite;)Ljetbrains/datalore/mapper/composite/NavComposite;", "firstFocusableAbove", "initial", "mapper-core"})
    private static final class NextUpperFocusable<ViewT extends NavComposite<ViewT> & HasFocusability & HasBounds>
    implements Function<ViewT, ViewT> {
        @NotNull
        private final ViewT myInitial;
        @Nullable
        private final ViewT myFirstFocusableAbove;
        final /* synthetic */ CompositesWithBounds this$0;

        public NextUpperFocusable(ViewT myInitial) {
            Intrinsics.checkNotNullParameter(myInitial, (String)"myInitial");
            this.this$0 = this$0;
            this.myInitial = myInitial;
            this.myFirstFocusableAbove = this.firstFocusableAbove(this.myInitial);
        }

        private final ViewT firstFocusableAbove(ViewT initial) {
            ViewT current = Composites.INSTANCE.prevFocusable(initial);
            while (current != null && !this.this$0.isAbove((HasBounds)current, (HasBounds)initial)) {
                current = Composites.INSTANCE.prevFocusable(current);
            }
            return current;
        }

        @Override
        @Nullable
        public ViewT apply(@NotNull ViewT value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            if (value == this.myInitial) {
                return this.myFirstFocusableAbove;
            }
            ViewT next = Composites.INSTANCE.prevFocusable(value);
            return next != null && !this.this$0.isAbove((HasBounds)next, (HasBounds)this.myFirstFocusableAbove) ? (ViewT)next : null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u0000*\u001a\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u00020\u0003*\u00020\u0004*\u00020\u00052\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0006B\u000f\b\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\rR\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0007\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/mapper/composite/CompositesWithBounds$NextLowerFocusable;", "ViewT", "Ljetbrains/datalore/mapper/composite/NavComposite;", "Ljetbrains/datalore/mapper/composite/HasFocusability;", "Ljetbrains/datalore/mapper/composite/HasVisibility;", "Ljetbrains/datalore/mapper/composite/HasBounds;", "Ljetbrains/datalore/base/function/Function;", "myInitial", "(Ljetbrains/datalore/mapper/composite/CompositesWithBounds;Ljetbrains/datalore/mapper/composite/NavComposite;)V", "myFirstFocusableBelow", "Ljetbrains/datalore/mapper/composite/NavComposite;", "apply", "value", "(Ljetbrains/datalore/mapper/composite/NavComposite;)Ljetbrains/datalore/mapper/composite/NavComposite;", "firstFocusableBelow", "initial", "mapper-core"})
    private static final class NextLowerFocusable<ViewT extends NavComposite<ViewT> & HasFocusability & HasBounds>
    implements Function<ViewT, ViewT> {
        @NotNull
        private final ViewT myInitial;
        @Nullable
        private final ViewT myFirstFocusableBelow;
        final /* synthetic */ CompositesWithBounds this$0;

        public NextLowerFocusable(ViewT myInitial) {
            Intrinsics.checkNotNullParameter(myInitial, (String)"myInitial");
            this.this$0 = this$0;
            this.myInitial = myInitial;
            this.myFirstFocusableBelow = this.firstFocusableBelow(this.myInitial);
        }

        private final ViewT firstFocusableBelow(ViewT initial) {
            ViewT current = Composites.INSTANCE.nextFocusable(initial);
            while (current != null && !this.this$0.isBelow((HasBounds)current, (HasBounds)initial)) {
                current = Composites.INSTANCE.nextFocusable(current);
            }
            return current;
        }

        @Override
        @Nullable
        public ViewT apply(@NotNull ViewT value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            if (value == this.myInitial) {
                return this.myFirstFocusableBelow;
            }
            ViewT next = Composites.INSTANCE.nextFocusable(value);
            return next != null && !this.this$0.isBelow((HasBounds)next, (HasBounds)this.myFirstFocusableBelow) ? (ViewT)next : null;
        }
    }
}

