/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.datetime;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/base/datetime/Time;", "", "hours", "", "minutes", "seconds", "milliseconds", "(IIII)V", "getHours", "()I", "getMilliseconds", "getMinutes", "getSeconds", "compareTo", "other", "equals", "", "", "hashCode", "toPrettyHMString", "", "toString", "Companion", "base-portable"})
public final class Time
implements Comparable<Time> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int milliseconds;
    private static final char DELIMITER = (char)58;
    @NotNull
    private static final Time DAY_START = new Time(0, 0, 0, 0, 12, null);
    @NotNull
    private static final Time DAY_END = new Time(24, 0, 0, 0, 12, null);

    @JvmOverloads
    public Time(int hours, int minutes, int seconds, int milliseconds) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
        if (this.hours < 0 || this.hours > 24) {
            throw new IllegalArgumentException();
        }
        if (this.hours == 24 && (this.minutes != 0 || this.seconds != 0)) {
            throw new IllegalArgumentException();
        }
        if (this.minutes < 0 || this.minutes >= 60) {
            throw new IllegalArgumentException();
        }
        if (this.seconds < 0 || this.seconds >= 60) {
            throw new IllegalArgumentException();
        }
    }

    public /* synthetic */ Time(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    public final int getHours() {
        return this.hours;
    }

    public final int getMinutes() {
        return this.minutes;
    }

    public final int getSeconds() {
        return this.seconds;
    }

    public final int getMilliseconds() {
        return this.milliseconds;
    }

    @Override
    public int compareTo(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int delta = this.hours - other.hours;
        if (delta != 0) {
            return delta;
        }
        delta = this.minutes - other.minutes;
        if (delta != 0) {
            return delta;
        }
        delta = this.seconds - other.seconds;
        return delta != 0 ? delta : this.milliseconds - other.milliseconds;
    }

    public int hashCode() {
        return this.hours * 239 + this.minutes * 491 + this.seconds * 41 + this.milliseconds;
    }

    public boolean equals(@Nullable Object other) {
        return !(other instanceof Time) ? false : this.compareTo((Time)other) == 0;
    }

    @NotNull
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.hours < 10) {
            result2.append("0");
        }
        result2.append(this.hours);
        if (this.minutes < 10) {
            result2.append("0");
        }
        result2.append(this.minutes);
        if (this.seconds < 10) {
            result2.append("0");
        }
        result2.append(this.seconds);
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public final String toPrettyHMString() {
        StringBuilder result2 = new StringBuilder();
        if (this.hours < 10) {
            result2.append("0");
        }
        result2.append(this.hours).append(DELIMITER);
        if (this.minutes < 10) {
            result2.append("0");
        }
        result2.append(this.minutes);
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @JvmOverloads
    public Time(int hours, int minutes, int seconds) {
        this(hours, minutes, seconds, 0, 8, null);
    }

    @JvmOverloads
    public Time(int hours, int minutes) {
        this(hours, minutes, 0, 0, 12, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/base/datetime/Time$Companion;", "", "()V", "DAY_END", "Ljetbrains/datalore/base/datetime/Time;", "getDAY_END", "()Ljetbrains/datalore/base/datetime/Time;", "DAY_START", "getDAY_START", "DELIMITER", "", "fromPrettyHMString", "time", "", "parse", "s", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Time getDAY_START() {
            return DAY_START;
        }

        @NotNull
        public final Time getDAY_END() {
            return DAY_END;
        }

        @NotNull
        public final Time parse(@NotNull String s2) {
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            if (s2.length() < 6) {
                throw new IllegalArgumentException();
            }
            String string = s2.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            int hours = Integer.parseInt(string);
            String string2 = s2.substring(2, 4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            int minutes = Integer.parseInt(string2);
            String string3 = s2.substring(4, 6);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            int seconds = Integer.parseInt(string3);
            return new Time(hours, minutes, seconds, 0, 8, null);
        }

        @NotNull
        public final Time fromPrettyHMString(@NotNull String time2) {
            Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
            char c = DELIMITER;
            String string = "";
            if (!StringsKt.contains$default((CharSequence)time2, (CharSequence)(c + string), (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException();
            }
            int length = time2.length();
            if (length != 5 && length != 4) {
                throw new IllegalArgumentException();
            }
            int hourLength = length == 4 ? 1 : 2;
            try {
                String string2 = time2.substring(0, hourLength);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                int n = Integer.parseInt(string2);
                String string3 = time2.substring(hourLength + 1, length);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return new Time(n, Integer.parseInt(string3), 0, 0, 8, null);
            }
            catch (NumberFormatException ignored) {
                throw new IllegalArgumentException();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

