/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.IError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.text.ConstantHasErrorText;
import com.helger.commons.error.text.DynamicHasErrorText;
import com.helger.commons.error.text.IHasErrorText;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.location.ILocation;
import com.helger.commons.location.SimpleLocation;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.traits.IGenericImplTrait;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.stream.Location;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

@Immutable
public class SingleError
implements IError {
    private final LocalDateTime m_aErrorDT;
    private final IErrorLevel m_aErrorLevel;
    private final String m_sErrorID;
    private final String m_sErrorFieldName;
    private final ILocation m_aErrorLocation;
    private final IHasErrorText m_aErrorText;
    private final Throwable m_aLinkedException;

    protected SingleError(@Nonnull AbstractBuilder<?, ?> abstractBuilder) {
        this(abstractBuilder.m_aErrorDT, abstractBuilder.m_aErrorLevel, abstractBuilder.m_sErrorID, abstractBuilder.m_sErrorFieldName, abstractBuilder.m_aErrorLocation, abstractBuilder.m_aErrorText, abstractBuilder.m_aLinkedException);
    }

    @Deprecated
    public SingleError(@Nonnull IErrorLevel iErrorLevel, @Nullable String string, @Nullable String string2, @Nullable ILocation iLocation, @Nullable IHasErrorText iHasErrorText, @Nullable Throwable throwable) {
        this(null, iErrorLevel, string, string2, iLocation, iHasErrorText, throwable);
    }

    public SingleError(@Nullable LocalDateTime localDateTime, @Nonnull IErrorLevel iErrorLevel, @Nullable String string, @Nullable String string2, @Nullable ILocation iLocation, @Nullable IHasErrorText iHasErrorText, @Nullable Throwable throwable) {
        this.m_aErrorDT = localDateTime;
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        this.m_sErrorID = string;
        this.m_sErrorFieldName = string2;
        this.m_aErrorLocation = iLocation != null ? iLocation : SimpleLocation.NO_LOCATION;
        this.m_aErrorText = iHasErrorText;
        this.m_aLinkedException = throwable;
    }

    @Override
    @Nullable
    public LocalDateTime getErrorDateTime() {
        return this.m_aErrorDT;
    }

    @Override
    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Override
    @Nullable
    public String getErrorID() {
        return this.m_sErrorID;
    }

    @Override
    @Nullable
    public String getErrorFieldName() {
        return this.m_sErrorFieldName;
    }

    @Override
    @Nonnull
    public ILocation getErrorLocation() {
        return this.m_aErrorLocation;
    }

    @Override
    @Nullable
    public IHasErrorText getErrorTexts() {
        return this.m_aErrorText;
    }

    @Override
    @Nullable
    public Throwable getLinkedException() {
        return this.m_aLinkedException;
    }

    @OverrideOnDemand
    protected boolean equalsLinkedException(@Nullable Throwable throwable, @Nullable Throwable throwable2) {
        if (EqualsHelper.identityEqual(throwable, throwable2)) {
            return true;
        }
        if (throwable == null || throwable2 == null) {
            return false;
        }
        return throwable.getClass().equals(throwable2.getClass()) && EqualsHelper.equals(throwable.getMessage(), throwable2.getMessage());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleError singleError = (SingleError)object;
        return EqualsHelper.equals(this.m_aErrorDT, singleError.m_aErrorDT) && this.m_aErrorLevel.equals(singleError.m_aErrorLevel) && EqualsHelper.equals(this.m_sErrorID, singleError.m_sErrorID) && EqualsHelper.equals(this.m_sErrorFieldName, singleError.m_sErrorFieldName) && EqualsHelper.equals(this.m_aErrorLocation, singleError.m_aErrorLocation) && EqualsHelper.equals(this.m_aErrorText, singleError.m_aErrorText) && this.equalsLinkedException(this.m_aLinkedException, singleError.m_aLinkedException);
    }

    @OverrideOnDemand
    protected void hashCodeLinkedException(@Nonnull HashCodeGenerator hashCodeGenerator, @Nullable Throwable throwable) {
        if (throwable == null) {
            hashCodeGenerator.append(129);
        } else {
            hashCodeGenerator.append(throwable.getClass()).append(throwable.getMessage());
        }
    }

    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this).append(this.m_aErrorDT).append(this.m_aErrorLevel).append(this.m_sErrorID).append(this.m_sErrorFieldName).append(this.m_aErrorLocation).append(this.m_aErrorText);
        this.hashCodeLinkedException(hashCodeGenerator, this.m_aLinkedException);
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("ErrorDateTime", this.m_aErrorDT).append("ErrorLevel", this.m_aErrorLevel).appendIfNotNull("ErrorID", this.m_sErrorID).appendIfNotNull("ErrorFieldName", this.m_sErrorFieldName).appendIfNotNull("ErrorLocation", this.m_aErrorLocation).appendIfNotNull("ErrorText", this.m_aErrorText).appendIfNotNull("LinkedException", this.m_aLinkedException).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nonnull IError iError) {
        return new Builder(iError);
    }

    @Nonnull
    public static Builder builderSuccess() {
        return (Builder)SingleError.builder().errorLevel(EErrorLevel.SUCCESS);
    }

    @Nonnull
    public static Builder builderInfo() {
        return (Builder)SingleError.builder().errorLevel(EErrorLevel.INFO);
    }

    @Nonnull
    public static Builder builderWarn() {
        return (Builder)SingleError.builder().errorLevel(EErrorLevel.WARN);
    }

    @Nonnull
    public static Builder builderError() {
        return (Builder)SingleError.builder().errorLevel(EErrorLevel.ERROR);
    }

    @Nonnull
    public static Builder builderFatalError() {
        return (Builder)SingleError.builder().errorLevel(EErrorLevel.FATAL_ERROR);
    }

    public static final class Builder
    extends AbstractBuilder<SingleError, Builder> {
        public Builder() {
        }

        public Builder(@Nonnull IError iError) {
            super(iError);
        }

        @Override
        @Nonnull
        public SingleError build() {
            if (this.m_aErrorLevel == null) {
                throw new IllegalStateException("The error level must be provided");
            }
            return new SingleError(this);
        }
    }

    public static abstract class AbstractBuilder<ERRTYPE extends SingleError, IMPLTYPE extends AbstractBuilder<ERRTYPE, IMPLTYPE>>
    implements IGenericImplTrait<IMPLTYPE>,
    IBuilder<ERRTYPE> {
        public static final IErrorLevel DEFAULT_ERROR_LEVEL = EErrorLevel.ERROR;
        protected LocalDateTime m_aErrorDT;
        protected IErrorLevel m_aErrorLevel = DEFAULT_ERROR_LEVEL;
        protected String m_sErrorID;
        protected String m_sErrorFieldName;
        protected ILocation m_aErrorLocation;
        protected IHasErrorText m_aErrorText;
        protected Throwable m_aLinkedException;

        public AbstractBuilder() {
        }

        public AbstractBuilder(@Nonnull IError iError) {
            ValueEnforcer.notNull(iError, "Error");
            this.errorLevel(iError.getErrorLevel());
            this.errorID(iError.getErrorID());
            this.errorFieldName(iError.getErrorFieldName());
            this.errorLocation(iError.getErrorLocation());
            this.errorText(iError.getErrorTexts());
            this.linkedException(iError.getLinkedException());
        }

        @Nonnull
        public final IMPLTYPE dateTimeNow() {
            return this.dateTime(PDTFactory.getCurrentLocalDateTime());
        }

        @Nonnull
        public final IMPLTYPE dateTime(@Nullable LocalDateTime localDateTime) {
            this.m_aErrorDT = localDateTime;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE errorLevel(@Nonnull IErrorLevel iErrorLevel) {
            ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
            this.m_aErrorLevel = iErrorLevel;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE errorID(@Nullable String string) {
            this.m_sErrorID = string;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE errorFieldName(@Nullable String string) {
            this.m_sErrorFieldName = string;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE errorLocation(@Nullable String string) {
            return this.errorLocation(new SimpleLocation(string));
        }

        @Nonnull
        public final IMPLTYPE errorLocation(@Nullable Locator locator) {
            return this.errorLocation(SimpleLocation.create(locator));
        }

        @Nonnull
        public final IMPLTYPE errorLocation(@Nullable SAXParseException sAXParseException) {
            return this.errorLocation(SimpleLocation.create(sAXParseException));
        }

        @Nonnull
        public final IMPLTYPE errorLocation(@Nullable Location location) {
            return this.errorLocation(SimpleLocation.create(location));
        }

        @Nonnull
        public final IMPLTYPE errorLocation(@Nullable ILocation iLocation) {
            this.m_aErrorLocation = iLocation;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE errorText(@Nullable String string) {
            return this.errorText(ConstantHasErrorText.createOnDemand(string));
        }

        @Nonnull
        public final IMPLTYPE errorText(@Nullable IMultilingualText iMultilingualText) {
            this.m_aErrorText = iMultilingualText == null ? null : (iMultilingualText.texts().size() == 1 ? ConstantHasErrorText.createOnDemand((String)iMultilingualText.texts().getFirstValue()) : new DynamicHasErrorText(iMultilingualText));
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE errorText(@Nullable IHasErrorText iHasErrorText) {
            this.m_aErrorText = iHasErrorText;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }

        @Nonnull
        public final IMPLTYPE linkedException(@Nullable Throwable throwable) {
            this.m_aLinkedException = throwable;
            return (IMPLTYPE)((AbstractBuilder)this.thisAsT());
        }
    }
}

