/*
 * Decompiled with CFR 0.152.
 */
package jodd.system;

import java.io.File;
import jodd.system.RuntimeInfo;
import jodd.system.SystemUtil;
import jodd.util.StringUtil;

abstract class UserInfo
extends RuntimeInfo {
    private final String USER_NAME = SystemUtil.get("user.name");
    private final String USER_HOME = this.nosep(SystemUtil.get("user.home"));
    private final String USER_DIR = this.nosep(SystemUtil.get("user.dir"));
    private final String USER_LANGUAGE = SystemUtil.get("user.language");
    private final String USER_COUNTRY = SystemUtil.get("user.country") == null ? SystemUtil.get("user.region") : SystemUtil.get("user.country");
    private final String JAVA_IO_TMPDIR = SystemUtil.get("java.io.tmpdir");
    private final String JAVA_HOME = this.nosep(SystemUtil.get("java.home"));
    private final String[] SYSTEM_CLASS_PATH = StringUtil.splitc(SystemUtil.get("java.class.path"), File.pathSeparator);

    UserInfo() {
    }

    public final String getUserName() {
        return this.USER_NAME;
    }

    public final String getHomeDir() {
        return this.USER_HOME;
    }

    public final String getWorkingDir() {
        return this.USER_DIR;
    }

    public final String getTempDir() {
        return this.JAVA_IO_TMPDIR;
    }

    public final String getUserLanguage() {
        return this.USER_LANGUAGE;
    }

    public final String getUserCountry() {
        return this.USER_COUNTRY;
    }

    public String getJavaHomeDir() {
        return this.JAVA_HOME;
    }

    public String[] getSystemClasspath() {
        return this.SYSTEM_CLASS_PATH;
    }

    @Override
    public final String toString() {
        return super.toString() + "\nUser name:        " + this.getUserName() + "\nUser home dir:    " + this.getHomeDir() + "\nUser current dir: " + this.getWorkingDir() + "\nUser temp dir:    " + this.getTempDir() + "\nUser language:    " + this.getUserLanguage() + "\nUser country:     " + this.getUserCountry();
    }
}

