/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.FacetedPlotLayoutUtil;
import jetbrains.datalore.plot.builder.layout.PlotAxisLayoutUtil;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayoutProvider;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/layout/facet/FixedScalesTilesLayouter;", "", "()V", "createTileLayoutInfos", "", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "tilesAreaSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "layoutProviderByTile", "Ljetbrains/datalore/plot/builder/layout/TileLayoutProvider;", "addedHSize", "", "addedVSize", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "hAxisTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "vAxisTheme", "plot-builder-portable"})
public final class FixedScalesTilesLayouter {
    @NotNull
    public static final FixedScalesTilesLayouter INSTANCE = new FixedScalesTilesLayouter();

    private FixedScalesTilesLayouter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TileLayoutInfo> createTileLayoutInfos(@NotNull DoubleVector tilesAreaSize, @NotNull PlotFacets facets, @NotNull List<? extends TileLayoutProvider> layoutProviderByTile, double addedHSize, double addedVSize, @NotNull CoordProvider coordProvider, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tilesAreaSize, (String)"tilesAreaSize");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter(layoutProviderByTile, (String)"layoutProviderByTile");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        List<PlotFacets.FacetTileInfo> facetTiles = facets.tileInfos();
        int vAxisCount = FacetedPlotLayoutUtil.INSTANCE.countVAxisInFirstRow(facetTiles);
        double vAxisThickness = PlotAxisLayoutUtil.INSTANCE.initialThickness(Orientation.LEFT, vAxisTheme);
        double geomWidth = (tilesAreaSize.getX() - addedHSize - (double)vAxisCount * vAxisThickness) / (double)facets.getColCount();
        double tileWidth = geomWidth + vAxisThickness;
        int hAxisCount = FacetedPlotLayoutUtil.INSTANCE.countHAxisInFirstCol(facetTiles);
        double hAxisThickness = PlotAxisLayoutUtil.INSTANCE.initialThickness(Orientation.BOTTOM, hAxisTheme);
        double geomHeight = (tilesAreaSize.getY() - addedVSize - (double)hAxisCount * hAxisThickness) / (double)facets.getRowCount();
        double tileHeight = geomHeight + hAxisThickness;
        TileLayout tileLayout = layoutProviderByTile.get(0).createTopDownTileLayout();
        TileLayoutInfo tileLayoutInfo = tileLayout.doLayout(new DoubleVector(tileWidth, tileHeight), coordProvider);
        Iterable $this$map$iv = facetTiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            PlotFacets.FacetTileInfo facetTileInfo = (PlotFacets.FacetTileInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(tileLayoutInfo.withAxisShown(it.getHasHAxis(), it.getHasVAxis()));
        }
        List tileLayoutInfos = (List)destination$iv$iv;
        DoubleVector tilesAreaSizeNew = FacetedPlotLayoutUtil.INSTANCE.tilesAreaSize(tileLayoutInfos, facets, addedHSize, addedVSize);
        double widthDiff = tilesAreaSize.getX() - tilesAreaSizeNew.getX();
        double heightDiff = tilesAreaSize.getY() - tilesAreaSizeNew.getY();
        if (Math.abs(widthDiff) <= (double)facets.getColCount() && Math.abs(heightDiff) <= (double)facets.getRowCount()) {
            return tileLayoutInfos;
        }
        double geomWidthDelta = widthDiff / (double)facets.getColCount();
        double geomHeightDelta = heightDiff / (double)facets.getRowCount();
        double tileWidth2 = tileLayoutInfo.geomOuterWidth() + geomWidthDelta + tileLayoutInfo.axisThicknessY();
        double tileHeight2 = tileLayoutInfo.geomOuterHeight() + geomHeightDelta + tileLayoutInfo.axisThicknessX();
        TileLayoutInfo tileLayoutInfo2 = tileLayout.doLayout(new DoubleVector(tileWidth2, tileHeight2), coordProvider);
        Iterable $this$map$iv2 = facetTiles;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PlotFacets.FacetTileInfo facetTileInfo = (PlotFacets.FacetTileInfo)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(tileLayoutInfo2.withAxisShown(it.getHasHAxis(), it.getHasVAxis()));
        }
        return (List)destination$iv$iv2;
    }
}

