/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.gcommon.collect.Ordering;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.aes.AestheticsUtil;
import jetbrains.datalore.plot.base.geom.StepGeom;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.geom.util.MultiPointData;
import jetbrains.datalore.plot.base.geom.util.MultiPointDataConstructor;
import jetbrains.datalore.plot.base.render.linetype.LineType;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import jetbrains.datalore.plot.common.geometry.PolylineSimplifier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u0001:\u00016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJP\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\f2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\f2\b\b\u0002\u0010\u0018\u001a\u00020\nJ0\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\fJ1\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u001f\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b J:\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00160\f2\u0006\u0010\u001f\u001a\u00020\nH\u0002J)\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001c2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J6\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\n2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\fH\u0004J\u0018\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0014H\u0002J$\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001c2\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001c0\u0013H\u0002J\u000e\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\nJ\u001e\u00101\u001a\u00020'2\u0016\u00102\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u001e\u00103\u001a\u00020'2\u0016\u00104\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fJ\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ljetbrains/datalore/plot/base/geom/util/LinesHelper;", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "(Ljetbrains/datalore/plot/base/PositionAdjustment;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/base/GeomContext;)V", "myAlphaEnabled", "", "myAlphaFilter", "Lkotlin/Function1;", "", "myWidthFilter", "createBands", "", "Ljetbrains/datalore/plot/base/render/svg/LinePath;", "dataPoints", "", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "toLocationUpper", "Ljetbrains/datalore/base/geometry/DoubleVector;", "toLocationLower", "simplifyBorders", "createLines", "toLocation", "createPaths", "", "aes", "points", "closePath", "createPaths$plot_base_portable", "createSteps", "Ljetbrains/datalore/plot/base/geom/util/LinesHelper$PathInfo;", "dir", "Ljetbrains/datalore/plot/base/geom/StepGeom$Direction;", "createSteps$plot_base_portable", "decorate", "", "path", "p", "filled", "strokeScaler", "decorateFillingPart", "insertPathSeparators", "rings", "setAlphaEnabled", "b", "setAlphaFilter", "alphaFilter", "setWidthFilter", "widthFilter", "simplify", "PathInfo", "plot-base-portable"})
public class LinesHelper
extends GeomHelper {
    @NotNull
    private Function1<? super Double, Double> myAlphaFilter;
    @NotNull
    private Function1<? super Double, Double> myWidthFilter;
    private boolean myAlphaEnabled;

    public LinesHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(pos, coord, ctx);
        this.myAlphaFilter = myAlphaFilter.1.INSTANCE;
        this.myWidthFilter = myWidthFilter.1.INSTANCE;
        this.myAlphaEnabled = true;
    }

    private final List<DoubleVector> insertPathSeparators(Iterable<? extends List<DoubleVector>> rings) {
        ArrayList<DoubleVector> result = new ArrayList<DoubleVector>();
        for (List<DoubleVector> list2 : rings) {
            if (!result.isEmpty()) {
                result.add(LinePath.Companion.getEND_OF_SUBPATH());
            }
            result.addAll((Collection)list2);
        }
        return result;
    }

    public final void setAlphaEnabled(boolean b2) {
        this.myAlphaEnabled = b2;
    }

    @NotNull
    public final List<LinePath> createLines(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocation) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocation, (String)"toLocation");
        return this.createPaths(dataPoints2, toLocation, false);
    }

    private final List<LinePath> createPaths(Iterable<? extends DataPointAesthetics> dataPoints2, Function1<? super DataPointAesthetics, DoubleVector> toLocation, boolean closePath) {
        ArrayList paths2 = new ArrayList();
        List<MultiPointData> multiPointDataList2 = MultiPointDataConstructor.INSTANCE.createMultiPointDataByGroup(dataPoints2, MultiPointDataConstructor.INSTANCE.singlePointAppender(this.toClientLocation$plot_base_portable((Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(toLocation){
            final /* synthetic */ Function1<DataPointAesthetics, DoubleVector> $toLocation;
            {
                this.$toLocation = $toLocation;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (DoubleVector)this.$toLocation.invoke((Object)it);
            }
        }))), MultiPointDataConstructor.INSTANCE.reducer(0.999, closePath));
        for (MultiPointData multiPointData : multiPointDataList2) {
            paths2.addAll(this.createPaths$plot_base_portable(multiPointData.getAes(), multiPointData.getPoints(), closePath));
        }
        return paths2;
    }

    @NotNull
    public final List<LinePath> createPaths$plot_base_portable(@NotNull DataPointAesthetics aes, @NotNull List<DoubleVector> points, boolean closePath) {
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        ArrayList<LinePath> paths2 = new ArrayList<LinePath>();
        if (closePath) {
            paths2.add(LinePath.Companion.polygon((Iterable<DoubleVector>)this.insertPathSeparators(GeometryKt.splitRings(points))));
        } else {
            paths2.add(LinePath.Companion.line((Iterable<DoubleVector>)points));
        }
        Iterable $this$forEach$iv = paths2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinePath path = (LinePath)element$iv;
            boolean bl = false;
            LinesHelper.decorate$default(this, path, aes, closePath, null, 8, null);
        }
        return paths2;
    }

    @NotNull
    public final List<PathInfo> createSteps$plot_base_portable(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull StepGeom.Direction dir) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter((Object)((Object)dir), (String)"dir");
        ArrayList<PathInfo> pathInfos = new ArrayList<PathInfo>();
        List<MultiPointData> multiPointDataList2 = MultiPointDataConstructor.INSTANCE.createMultiPointDataByGroup(dataPoints2, MultiPointDataConstructor.INSTANCE.singlePointAppender(this.toClientLocation$plot_base_portable(GeomUtil.INSTANCE.getTO_LOCATION_X_Y())), MultiPointDataConstructor.INSTANCE.reducer(0.999, false));
        for (MultiPointData multiPointData : multiPointDataList2) {
            List<DoubleVector> points = multiPointData.getPoints();
            if (points.isEmpty()) continue;
            ArrayList<DoubleVector> newPoints = new ArrayList<DoubleVector>();
            DoubleVector prev = null;
            for (DoubleVector point : points) {
                if (prev != null) {
                    double x = dir == StepGeom.Direction.HV ? point.getX() : prev.getX();
                    double y = dir == StepGeom.Direction.HV ? prev.getY() : point.getY();
                    newPoints.add(new DoubleVector(x, y));
                }
                newPoints.add(point);
                prev = point;
            }
            LinePath path = LinePath.Companion.line((Iterable<DoubleVector>)newPoints);
            LinesHelper.decorate$default(this, path, multiPointData.getAes(), false, null, 8, null);
            pathInfos.add(new PathInfo(path));
        }
        return pathInfos;
    }

    @NotNull
    public final List<LinePath> createBands(@NotNull Iterable<? extends DataPointAesthetics> dataPoints2, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationUpper, @NotNull Function1<? super DataPointAesthetics, DoubleVector> toLocationLower, boolean simplifyBorders) {
        Intrinsics.checkNotNullParameter(dataPoints2, (String)"dataPoints");
        Intrinsics.checkNotNullParameter(toLocationUpper, (String)"toLocationUpper");
        Intrinsics.checkNotNullParameter(toLocationLower, (String)"toLocationLower");
        ArrayList<LinePath> lines = new ArrayList<LinePath>();
        Map<Integer, List<DataPointAesthetics>> pointsByGroup = GeomUtil.INSTANCE.createGroups(dataPoints2);
        Iterator iterator = Ordering.Companion.natural().sortedCopy((Iterable)pointsByGroup.keySet()).iterator();
        while (iterator.hasNext()) {
            List<DataPointAesthetics> groupDataPoints;
            int group = ((Number)iterator.next()).intValue();
            Intrinsics.checkNotNull(pointsByGroup.get(group));
            List<DoubleVector> upperPoints2 = this.project((Iterable<? extends DataPointAesthetics>)groupDataPoints, (Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(toLocationUpper){
                final /* synthetic */ Function1<DataPointAesthetics, DoubleVector> $toLocationUpper;
                {
                    this.$toLocationUpper = $toLocationUpper;
                    super(1);
                }

                @Nullable
                public final DoubleVector invoke(@NotNull DataPointAesthetics it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (DoubleVector)this.$toLocationUpper.invoke((Object)it);
                }
            }));
            ArrayList points = new ArrayList(simplifyBorders ? this.simplify(upperPoints2) : upperPoints2);
            ArrayList lowerPoints2 = new ArrayList(this.project(CollectionsKt.reversed((Iterable)groupDataPoints), (Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(toLocationLower){
                final /* synthetic */ Function1<DataPointAesthetics, DoubleVector> $toLocationLower;
                {
                    this.$toLocationLower = $toLocationLower;
                    super(1);
                }

                @Nullable
                public final DoubleVector invoke(@NotNull DataPointAesthetics it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (DoubleVector)this.$toLocationLower.invoke((Object)it);
                }
            })));
            points.addAll(simplifyBorders ? this.simplify(lowerPoints2) : (List<DoubleVector>)lowerPoints2);
            if (points.isEmpty()) continue;
            LinePath path = LinePath.Companion.polygon(points);
            this.decorateFillingPart(path, groupDataPoints.get(0));
            lines.add(path);
        }
        return lines;
    }

    public static /* synthetic */ List createBands$default(LinesHelper linesHelper, Iterable iterable, Function1 function1, Function1 function12, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBands");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return linesHelper.createBands(iterable, (Function1<? super DataPointAesthetics, DoubleVector>)function1, (Function1<? super DataPointAesthetics, DoubleVector>)function12, bl);
    }

    private final List<DoubleVector> simplify(List<DoubleVector> points) {
        double weightLimit = 0.25;
        return PolylineSimplifier.Companion.douglasPeucker(points).setWeightLimit(weightLimit).getPoints();
    }

    protected final void decorate(@NotNull LinePath path, @NotNull DataPointAesthetics p, boolean filled, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler) {
        Color stroke;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
        Color color = stroke = p.color();
        Intrinsics.checkNotNull((Object)color);
        Object object = this.myAlphaFilter.invoke((Object)AestheticsUtil.INSTANCE.alpha(color, p));
        Intrinsics.checkNotNull((Object)object);
        double strokeAlpha = ((Number)object).doubleValue();
        path.color().set((Object)Colors.INSTANCE.withOpacity(stroke, strokeAlpha));
        if (filled || !this.myAlphaEnabled) {
            path.color().set((Object)stroke);
        }
        if (filled) {
            this.decorateFillingPart(path, p);
        }
        Object object2 = this.myWidthFilter.invoke(strokeScaler.invoke((Object)p));
        Intrinsics.checkNotNull((Object)object2);
        double size = ((Number)object2).doubleValue();
        path.width().set((Object)size);
        LineType lineType = p.lineType();
        if (!lineType.isBlank() && !lineType.isSolid()) {
            path.dashArray().set(lineType.getDashArray());
        }
    }

    public static /* synthetic */ void decorate$default(LinesHelper linesHelper, LinePath linePath, DataPointAesthetics dataPointAesthetics, boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decorate");
        }
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AesScaling)this.receiver).strokeWidth(p0);
                }
            };
        }
        linesHelper.decorate(linePath, dataPointAesthetics, bl, (Function1<? super DataPointAesthetics, Double>)function1);
    }

    private final void decorateFillingPart(LinePath path, DataPointAesthetics p) {
        Color fill;
        Color color = fill = p.fill();
        Intrinsics.checkNotNull((Object)color);
        Object object = this.myAlphaFilter.invoke((Object)AestheticsUtil.INSTANCE.alpha(color, p));
        Intrinsics.checkNotNull((Object)object);
        double fillAlpha = ((Number)object).doubleValue();
        path.fill().set((Object)Colors.INSTANCE.withOpacity(fill, fillAlpha));
    }

    public final void setAlphaFilter(@NotNull Function1<? super Double, Double> alphaFilter) {
        Intrinsics.checkNotNullParameter(alphaFilter, (String)"alphaFilter");
        this.myAlphaFilter = alphaFilter;
    }

    public final void setWidthFilter(@NotNull Function1<? super Double, Double> widthFilter) {
        Intrinsics.checkNotNullParameter(widthFilter, (String)"widthFilter");
        this.myWidthFilter = widthFilter;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/base/geom/util/LinesHelper$PathInfo;", "", "path", "Ljetbrains/datalore/plot/base/render/svg/LinePath;", "(Ljetbrains/datalore/plot/base/render/svg/LinePath;)V", "getPath", "()Ljetbrains/datalore/plot/base/render/svg/LinePath;", "plot-base-portable"})
    public static final class PathInfo {
        @NotNull
        private final LinePath path;

        public PathInfo(@NotNull LinePath path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        @NotNull
        public final LinePath getPath() {
            return this.path;
        }
    }
}

