/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.geom.util.DataPointAestheticsDelegate;
import jetbrains.datalore.plot.base.render.linetype.LineType;
import jetbrains.datalore.plot.base.render.linetype.NamedLineType;
import jetbrains.datalore.vis.svg.SvgPathDataBuilder;
import jetbrains.datalore.vis.svg.SvgPathElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Ljetbrains/datalore/plot/base/geom/util/ArrowSpec;", "", "angle", "", "length", "end", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$End;", "type", "Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$Type;", "(DDLjetbrains/datalore/plot/base/geom/util/ArrowSpec$End;Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$Type;)V", "getAngle", "()D", "getEnd", "()Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$End;", "isOnFirstEnd", "", "()Z", "isOnLastEnd", "getLength", "getType", "()Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$Type;", "createElement", "Ljetbrains/datalore/vis/svg/SvgPathElement;", "polarAngle", "x", "y", "toArrowAes", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "p", "End", "Type", "plot-base-portable"})
public final class ArrowSpec {
    private final double angle;
    private final double length;
    @NotNull
    private final End end;
    @NotNull
    private final Type type;

    public ArrowSpec(double angle, double length, @NotNull End end, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)end), (String)"end");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.angle = angle;
        this.length = length;
        this.end = end;
        this.type = type;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final double getLength() {
        return this.length;
    }

    @NotNull
    public final End getEnd() {
        return this.end;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final boolean isOnFirstEnd() {
        return this.end == End.FIRST || this.end == End.BOTH;
    }

    public final boolean isOnLastEnd() {
        return this.end == End.LAST || this.end == End.BOTH;
    }

    @NotNull
    public final SvgPathElement createElement(double polarAngle, double x, double y) {
        double[] dArray = new double[]{x - this.length * Math.cos(polarAngle - this.angle), x, x - this.length * Math.cos(polarAngle + this.angle)};
        double[] xs = dArray;
        double[] dArray2 = new double[]{y - this.length * Math.sin(polarAngle - this.angle), y, y - this.length * Math.sin(polarAngle + this.angle)};
        double[] ys = dArray2;
        SvgPathDataBuilder b2 = SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)new SvgPathDataBuilder(true), (double)xs[0], (double)ys[0], (boolean)false, (int)4, null);
        for (int i = 1; i < 3; ++i) {
            b2.lineTo(xs[i], ys[i], true);
        }
        if (this.type == Type.CLOSED) {
            b2.closePath();
        }
        return new SvgPathElement(b2.build());
    }

    @NotNull
    public final DataPointAesthetics toArrowAes(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new DataPointAestheticsDelegate(this, p){
            private final boolean filled;
            {
                this.filled = $receiver.getType() == Type.CLOSED;
            }

            @Nullable
            public <T> T get(@NotNull Aes<T> aes) {
                Intrinsics.checkNotNullParameter(aes, (String)"aes");
                Aes<T> aes2 = aes;
                Color value = Intrinsics.areEqual(aes2, Aes.Companion.getFILL()) ? (this.filled ? super.get(Aes.Companion.getCOLOR()) : Color.Companion.getTRANSPARENT()) : (Intrinsics.areEqual(aes2, Aes.Companion.getLINETYPE()) ? (this.filled ? (LineType)NamedLineType.SOLID : (LineType)super.get(aes)) : super.get(aes));
                return (T)value;
            }
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$End;", "", "(Ljava/lang/String;I)V", "LAST", "FIRST", "BOTH", "plot-base-portable"})
    public static final class End
    extends Enum<End> {
        public static final /* enum */ End LAST = new End();
        public static final /* enum */ End FIRST = new End();
        public static final /* enum */ End BOTH = new End();
        private static final /* synthetic */ End[] $VALUES;

        public static End[] values() {
            return (End[])$VALUES.clone();
        }

        public static End valueOf(String value) {
            return Enum.valueOf(End.class, value);
        }

        static {
            $VALUES = endArray = new End[]{End.LAST, End.FIRST, End.BOTH};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/geom/util/ArrowSpec$Type;", "", "(Ljava/lang/String;I)V", "OPEN", "CLOSED", "plot-base-portable"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type OPEN = new Type();
        public static final /* enum */ Type CLOSED = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.OPEN, Type.CLOSED};
        }
    }
}

