/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.List;
import java.util.Locale;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.PointLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.plot.base.render.point.PointShapeSvg;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.slim.SvgSlimElements;
import jetbrains.datalore.vis.svg.slim.SvgSlimGroup;
import jetbrains.datalore.vis.svg.slim.SvgSlimObject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Ljetbrains/datalore/plot/base/geom/PointGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "animation", "", "getAnimation", "()Ljava/lang/Object;", "setAnimation", "(Ljava/lang/Object;)V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "sizeUnit", "", "getSizeUnit", "()Ljava/lang/String;", "setSizeUnit", "(Ljava/lang/String;)V", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public class PointGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Object animation;
    @Nullable
    private String sizeUnit;
    public static final boolean HANDLES_GROUPS = false;

    @Nullable
    public final Object getAnimation() {
        return this.animation;
    }

    public final void setAnimation(@Nullable Object object) {
        this.animation = object;
    }

    @Nullable
    public final String getSizeUnit() {
        return this.sizeUnit;
    }

    public final void setSizeUnit(@Nullable String string) {
        this.sizeUnit = string;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new PointLegendKeyElementFactory(0.0, 1, null);
    }

    @Override
    public void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper helper = new GeomHelper(pos, coord, ctx);
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.POINT, ctx);
        int count = aesthetics.dataPointCount();
        SvgSlimGroup slimGroup = SvgSlimElements.INSTANCE.g(count);
        for (int i = 0; i < count; ++i) {
            PointShape shape;
            double d;
            Double size;
            Double y;
            DataPointAesthetics p = aesthetics.dataPointAt(i);
            Double x = p.x();
            if (!SeriesUtil.INSTANCE.allFinite(x, y = p.y(), size = p.size())) continue;
            Double d2 = x;
            Intrinsics.checkNotNull((Object)d2);
            double d3 = d2;
            Double d4 = y;
            Intrinsics.checkNotNull((Object)d4);
            DoubleVector point = new DoubleVector(d3, d4.doubleValue());
            DoubleVector location = helper.toClient(point, p);
            if (location == null) continue;
            Intrinsics.checkNotNull((Object)p.shape());
            if (this.sizeUnit == null) {
                d = 1.0;
            } else {
                String string = this.sizeUnit;
                Intrinsics.checkNotNull((Object)string);
                d = PointGeom.Companion.getSizeUnitRatio(point, coord, string);
            }
            double sizeUnitRatio = d;
            GeomTargetCollector.DefaultImpls.addPoint$default(targetCollector, i, location, (sizeUnitRatio * PointShape.DefaultImpls.size$default(shape, p, 0.0, 2, null) + shape.strokeWidth(p)) / (double)2, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)p), 7, null), null, 16, null);
            SvgSlimObject o = PointShapeSvg.INSTANCE.create(shape, location, p, sizeUnitRatio);
            o.appendTo(slimGroup);
        }
        root.add((SvgNode)GeomBase.Companion.wrap(slimGroup));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/geom/PointGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "getSizeUnitRatio", "", "p", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "axis", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final double getSizeUnitRatio(DoubleVector p, CoordinateSystem coord, String axis) {
            double d;
            DoubleVector unitSquareSize = coord.unitSize(p);
            String string = axis.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"x")) {
                d = unitSquareSize.getX();
            } else if (Intrinsics.areEqual((Object)string2, (Object)"y")) {
                d = unitSquareSize.getY();
            } else {
                throw new IllegalStateException(("Size unit value must be either 'x' or 'y', but was " + axis + '.').toString());
            }
            double unitSize = d;
            return unitSize / 2.2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

