/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.time.interval;

import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.Month;
import jetbrains.datalore.plot.common.time.interval.MeasuredInDays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/common/time/interval/MonthInterval;", "Ljetbrains/datalore/plot/common/time/interval/MeasuredInDays;", "count", "", "(I)V", "tickFormatPattern", "", "getTickFormatPattern", "()Ljava/lang/String;", "addInterval", "Ljetbrains/datalore/base/datetime/DateTime;", "toInstant", "addMonth", "getFirstDayContaining", "Ljetbrains/datalore/base/datetime/Date;", "instant", "plot-common-portable"})
public final class MonthInterval
extends MeasuredInDays {
    public MonthInterval(int count) {
        super(count);
    }

    @Override
    @NotNull
    public String getTickFormatPattern() {
        return "%b";
    }

    @Override
    @NotNull
    protected Date getFirstDayContaining(@NotNull DateTime instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        Date firstDay = instant.getDate();
        firstDay = Date.Companion.firstDayOf(firstDay.getYear(), firstDay.getMonth());
        return firstDay;
    }

    @Override
    @NotNull
    protected DateTime addInterval(@NotNull DateTime toInstant) {
        Intrinsics.checkNotNullParameter((Object)toInstant, (String)"toInstant");
        DateTime result = toInstant;
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            result = this.addMonth(result);
        }
        return result;
    }

    private final DateTime addMonth(DateTime toInstant) {
        int year = toInstant.getYear();
        Month month = toInstant.getMonth();
        Month next = month.next();
        if (next == null) {
            next = Month.Companion.getJANUARY();
            ++year;
        }
        return new DateTime(Date.Companion.firstDayOf(year, next), null, 2, null);
    }
}

